/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.v3.PartitionConsumeRecord;
import java.util.List;
import javax.annotation.Nullable;

final class AutoValue_PartitionConsumeRecord
extends PartitionConsumeRecord {
    private final int partitionId;
    private final long offset;
    private final long timestamp;
    private final Object key;
    private final Object value;
    private final PartitionConsumeRecord.TimestampType timestampType;
    private final List<PartitionConsumeRecord.Header> headers;
    private final PartitionConsumeRecord.ExceededFields exceededFields;

    private AutoValue_PartitionConsumeRecord(int partitionId, long offset, long timestamp, @Nullable Object key, @Nullable Object value, @Nullable PartitionConsumeRecord.TimestampType timestampType, List<PartitionConsumeRecord.Header> headers, @Nullable PartitionConsumeRecord.ExceededFields exceededFields) {
        this.partitionId = partitionId;
        this.offset = offset;
        this.timestamp = timestamp;
        this.key = key;
        this.value = value;
        this.timestampType = timestampType;
        this.headers = headers;
        this.exceededFields = exceededFields;
    }

    @Override
    @JsonProperty(value="partition_id")
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    @JsonProperty(value="offset")
    public long getOffset() {
        return this.offset;
    }

    @Override
    @JsonProperty(value="timestamp")
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    @Nullable
    @JsonProperty(value="key")
    public Object getKey() {
        return this.key;
    }

    @Override
    @Nullable
    @JsonProperty(value="value")
    public Object getValue() {
        return this.value;
    }

    @Override
    @Nullable
    @JsonProperty(value="timestamp_type")
    public PartitionConsumeRecord.TimestampType getTimestampType() {
        return this.timestampType;
    }

    @Override
    @JsonProperty(value="headers")
    public List<PartitionConsumeRecord.Header> getHeaders() {
        return this.headers;
    }

    @Override
    @Nullable
    @JsonProperty(value="exceeded_fields")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PartitionConsumeRecord.ExceededFields getExceededFields() {
        return this.exceededFields;
    }

    public String toString() {
        return "PartitionConsumeRecord{partitionId=" + this.partitionId + ", offset=" + this.offset + ", timestamp=" + this.timestamp + ", key=" + this.key + ", value=" + this.value + ", timestampType=" + (Object)((Object)this.timestampType) + ", headers=" + this.headers + ", exceededFields=" + this.exceededFields + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PartitionConsumeRecord) {
            PartitionConsumeRecord that = (PartitionConsumeRecord)o;
            return this.partitionId == that.getPartitionId() && this.offset == that.getOffset() && this.timestamp == that.getTimestamp() && (this.key == null ? that.getKey() == null : this.key.equals(that.getKey())) && (this.value == null ? that.getValue() == null : this.value.equals(that.getValue())) && (this.timestampType == null ? that.getTimestampType() == null : this.timestampType.equals((Object)that.getTimestampType())) && this.headers.equals(that.getHeaders()) && (this.exceededFields == null ? that.getExceededFields() == null : this.exceededFields.equals(that.getExceededFields()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.partitionId;
        h$ *= 1000003;
        h$ ^= (int)(this.offset >>> 32 ^ this.offset);
        h$ *= 1000003;
        h$ ^= (int)(this.timestamp >>> 32 ^ this.timestamp);
        h$ *= 1000003;
        h$ ^= this.key == null ? 0 : this.key.hashCode();
        h$ *= 1000003;
        h$ ^= this.value == null ? 0 : this.value.hashCode();
        h$ *= 1000003;
        h$ ^= this.timestampType == null ? 0 : this.timestampType.hashCode();
        h$ *= 1000003;
        h$ ^= this.headers.hashCode();
        h$ *= 1000003;
        return h$ ^= this.exceededFields == null ? 0 : this.exceededFields.hashCode();
    }

    static final class Builder
    extends PartitionConsumeRecord.Builder {
        private Integer partitionId;
        private Long offset;
        private Long timestamp;
        private Object key;
        private Object value;
        private PartitionConsumeRecord.TimestampType timestampType;
        private List<PartitionConsumeRecord.Header> headers;
        private PartitionConsumeRecord.ExceededFields exceededFields;

        Builder() {
        }

        @Override
        public PartitionConsumeRecord.Builder setPartitionId(int partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        @Override
        public PartitionConsumeRecord.Builder setOffset(long offset) {
            this.offset = offset;
            return this;
        }

        @Override
        public PartitionConsumeRecord.Builder setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public PartitionConsumeRecord.Builder setKey(Object key) {
            this.key = key;
            return this;
        }

        @Override
        public PartitionConsumeRecord.Builder setValue(Object value) {
            this.value = value;
            return this;
        }

        @Override
        public PartitionConsumeRecord.Builder setTimestampType(PartitionConsumeRecord.TimestampType timestampType) {
            this.timestampType = timestampType;
            return this;
        }

        @Override
        public PartitionConsumeRecord.Builder setHeaders(List<PartitionConsumeRecord.Header> headers) {
            if (headers == null) {
                throw new NullPointerException("Null headers");
            }
            this.headers = headers;
            return this;
        }

        @Override
        public PartitionConsumeRecord.Builder setExceededFields(PartitionConsumeRecord.ExceededFields exceededFields) {
            this.exceededFields = exceededFields;
            return this;
        }

        @Override
        public PartitionConsumeRecord build() {
            String missing = "";
            if (this.partitionId == null) {
                missing = missing + " partitionId";
            }
            if (this.offset == null) {
                missing = missing + " offset";
            }
            if (this.timestamp == null) {
                missing = missing + " timestamp";
            }
            if (this.headers == null) {
                missing = missing + " headers";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PartitionConsumeRecord(this.partitionId, this.offset, this.timestamp, this.key, this.value, this.timestampType, this.headers, this.exceededFields);
        }
    }
}

