/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.BrokerReplicaExclusion;
import io.confluent.kafkarest.entities.v3.AutoValue_BrokerReplicaExclusionData;
import io.confluent.kafkarest.entities.v3.Resource;
import java.util.Optional;
import javax.annotation.Nullable;

@AutoValue
public abstract class BrokerReplicaExclusionData
extends Resource {
    BrokerReplicaExclusionData() {
    }

    @JsonProperty(value="cluster_id")
    public abstract String getClusterId();

    @JsonProperty(value="broker_id")
    public abstract int getBrokerId();

    @JsonProperty(value="reason")
    public abstract String getReason();

    @JsonProperty(value="error_code")
    public abstract Optional<Short> getErrorCode();

    @JsonProperty(value="error_message")
    public abstract Optional<String> getErrorMessage();

    @JsonProperty(value="broker")
    public abstract Resource.Relationship getBroker();

    public static Builder builder() {
        return new AutoValue_BrokerReplicaExclusionData.Builder().setKind("KafkaBrokerReplicaExclusion");
    }

    public static Builder fromBrokerReplicaExclusion(BrokerReplicaExclusion brokerReplicaExclusion) {
        return BrokerReplicaExclusionData.builder().setClusterId(brokerReplicaExclusion.getClusterId()).setBrokerId(brokerReplicaExclusion.getBrokerId()).setReason(brokerReplicaExclusion.getReason()).setErrorCode(brokerReplicaExclusion.getErrorCode().orElse(null)).setErrorMessage(brokerReplicaExclusion.getErrorMessage().orElse(null));
    }

    @JsonCreator
    static BrokerReplicaExclusionData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="cluster_id") String clusterId, @JsonProperty(value="broker_id") int brokerId, @JsonProperty(value="reason") String reason, @JsonProperty(value="error_code") @Nullable Short errorCode, @JsonProperty(value="error_message") @Nullable String errorMessage, @JsonProperty(value="broker") Resource.Relationship broker) {
        return ((Builder)((Builder)BrokerReplicaExclusionData.builder().setKind(kind)).setMetadata(metadata)).setClusterId(clusterId).setBrokerId(brokerId).setReason(reason).setErrorCode(errorCode).setErrorMessage(errorMessage).setBroker(broker).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends Resource.Builder<Builder> {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setBrokerId(int var1);

        public abstract Builder setReason(String var1);

        public abstract Builder setErrorCode(@Nullable Short var1);

        public abstract Builder setErrorMessage(@Nullable String var1);

        public abstract Builder setBroker(Resource.Relationship var1);

        public abstract BrokerReplicaExclusionData build();
    }
}

