/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.v3.AutoValue_CreateLinkRequest;
import io.confluent.kafkarest.entities.v3.AutoValue_CreateLinkRequest_ConfigEntry;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

@AutoValue
public abstract class CreateLinkRequest {
    CreateLinkRequest() {
    }

    @JsonProperty(value="configs")
    public abstract ImmutableList<ConfigEntry> getConfigs();

    @JsonProperty(value="source_cluster_id")
    public abstract Optional<String> getSourceClusterId();

    @JsonProperty(value="destination_cluster_id")
    public abstract Optional<String> getDestinationClusterId();

    @JsonProperty(value="remote_cluster_id")
    public abstract Optional<String> getRemoteClusterId();

    @JsonProperty(value="cluster_link_id")
    public abstract Optional<String> getClusterLinkId();

    public static Builder builder() {
        return new AutoValue_CreateLinkRequest.Builder();
    }

    @JsonCreator
    static CreateLinkRequest fromJson(@JsonProperty(value="configs") @Nullable List<ConfigEntry> configs, @JsonProperty(value="source_cluster_id") @Nullable String sourceClusterId, @JsonProperty(value="destination_cluster_id") @Nullable String destinationClusterId, @JsonProperty(value="remote_cluster_id") @Nullable String remoteClusterId, @JsonProperty(value="cluster_link_id") @Nullable String clusterLinkId) {
        return CreateLinkRequest.builder().setConfigs((List<ConfigEntry>)(configs != null ? configs : ImmutableList.of())).setSourceClusterId(sourceClusterId).setDestinationClusterId(destinationClusterId).setRemoteClusterId(remoteClusterId).setClusterLinkId(clusterLinkId).build();
    }

    @AutoValue
    public static abstract class ConfigEntry {
        ConfigEntry() {
        }

        @JsonProperty(value="name")
        public abstract String getName();

        @JsonProperty(value="value")
        public abstract Optional<String> getValue();

        public static ConfigEntry create(String name, @Nullable String value) {
            return new AutoValue_CreateLinkRequest_ConfigEntry(name, Optional.ofNullable(value));
        }

        @JsonCreator
        static ConfigEntry fromJson(@JsonProperty(value="name") String name, @JsonProperty(value="value") @Nullable String value) {
            return ConfigEntry.create(name, value);
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        public abstract Builder setConfigs(List<ConfigEntry> var1);

        public abstract Builder setSourceClusterId(@Nullable String var1);

        public abstract Builder setDestinationClusterId(@Nullable String var1);

        public abstract Builder setRemoteClusterId(@Nullable String var1);

        public abstract Builder setClusterLinkId(@Nullable String var1);

        public abstract CreateLinkRequest build();
    }
}

