/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.Mirror;
import io.confluent.kafkarest.entities.v3.AutoValue_MirrorData;
import io.confluent.kafkarest.entities.v3.MirrorLagData;
import io.confluent.kafkarest.entities.v3.Resource;
import java.util.List;
import java.util.stream.Collectors;

@AutoValue
public abstract class MirrorData
extends Resource {
    MirrorData() {
    }

    @JsonProperty(value="link_name")
    public abstract String getLinkName();

    @JsonProperty(value="mirror_topic_name")
    public abstract String getMirrorTopicName();

    @JsonProperty(value="source_topic_name")
    public abstract String getSourceTopicName();

    @JsonProperty(value="num_partitions")
    public abstract int getNumPartitions();

    @JsonProperty(value="mirror_lags")
    public abstract ImmutableList<MirrorLagData> getMirrorLags();

    @JsonProperty(value="mirror_status")
    public abstract String getMirrorStatus();

    @JsonProperty(value="mirror_topic_error")
    public abstract String getMirrorTopicError();

    @JsonProperty(value="state_time_ms")
    public abstract long getStateTimeMs();

    public static Builder builder() {
        return new AutoValue_MirrorData.Builder().setKind("KafkaMirrorData");
    }

    @JsonCreator
    static MirrorData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="link_name") String linkName, @JsonProperty(value="mirror_topic_name") String mirrorTopicName, @JsonProperty(value="source_topic_name") String sourceTopicName, @JsonProperty(value="num_partitions") int numPartitions, @JsonProperty(value="mirror_lags") ImmutableList<MirrorLagData> mirrorLags, @JsonProperty(value="mirror_status") String mirrorStatus, @JsonProperty(value="mirror_topic_error") String mirrorTopicError, @JsonProperty(value="state_time_ms") long stateTimeMs) {
        return ((Builder)((Builder)MirrorData.builder().setKind(kind)).setMetadata(metadata)).setLinkName(linkName).setMirrorTopicName(mirrorTopicName).setSourceTopicName(sourceTopicName).setNumPartitions(numPartitions).setMirrorLags(mirrorLags).setMirrorStatus(mirrorStatus).setMirrorTopicError(mirrorTopicError).setStateTimeMs(stateTimeMs).build();
    }

    public static List<MirrorData> fromMirrors(List<Mirror> mirrors, String urlPrefix) {
        return mirrors.stream().map(mirror -> ((Builder)MirrorData.fromMirror(mirror).setMetadata(Resource.Metadata.builder().setSelf(urlPrefix + "/" + mirror.getMirrorTopicName()).build())).build()).collect(Collectors.toList());
    }

    public static Builder fromMirror(Mirror mirror) {
        return MirrorData.builder().setLinkName(mirror.getLinkName()).setMirrorTopicName(mirror.getMirrorTopicName()).setSourceTopicName(mirror.getSourceTopicName()).setNumPartitions(mirror.getNumPartitions()).setMirrorLags(MirrorLagData.fromPartitionLagInfo(mirror.getPartitionLagList())).setMirrorStatus(mirror.getMirrorStatus().toString()).setMirrorTopicError(mirror.getMirrorTopicError().toString()).setStateTimeMs(mirror.getStatusTimeMs());
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends Resource.Builder<Builder> {
        Builder() {
        }

        public abstract Builder setLinkName(String var1);

        public abstract Builder setMirrorTopicName(String var1);

        public abstract Builder setSourceTopicName(String var1);

        public abstract Builder setNumPartitions(int var1);

        public abstract Builder setMirrorLags(ImmutableList<MirrorLagData> var1);

        public abstract Builder setMirrorStatus(String var1);

        public abstract Builder setMirrorTopicError(String var1);

        public abstract Builder setStateTimeMs(long var1);

        public abstract MirrorData build();
    }
}

