/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.v3.AutoValue_TopicPartitionOffsetAndMetaData;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;

@AutoValue
public abstract class TopicPartitionOffsetAndMetaData {
    @JsonProperty(value="offset")
    public abstract long getOffset();

    @Nullable
    @JsonProperty(value="metadata")
    public abstract String getMetadata();

    @JsonProperty(value="partition_id")
    public abstract Integer getPartitionId();

    @JsonProperty(value="topic_name")
    public abstract String getTopicName();

    public static Builder builder() {
        return new AutoValue_TopicPartitionOffsetAndMetaData.Builder();
    }

    public static TopicPartitionOffsetAndMetaData fromOffsetAndMetadata(TopicPartition topicPartition, OffsetAndMetadata offsetMetaData) {
        return TopicPartitionOffsetAndMetaData.builder().setOffset(offsetMetaData.offset()).setPartitionId(topicPartition.partition()).setTopicName(topicPartition.topic()).setMetadata(offsetMetaData.metadata()).build();
    }

    @JsonCreator
    static TopicPartitionOffsetAndMetaData fromJson(@JsonProperty(value="offset") long offset, @JsonProperty(value="metadata") String metadata, @JsonProperty(value="topic_name") String topicName, @JsonProperty(value="partition_id") Integer partitionId) {
        return TopicPartitionOffsetAndMetaData.builder().setOffset(offset).setMetadata(metadata).setTopicName(topicName).setPartitionId(partitionId).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        public abstract Builder setOffset(long var1);

        public abstract Builder setMetadata(String var1);

        public abstract Builder setPartitionId(Integer var1);

        public abstract Builder setTopicName(String var1);

        public abstract TopicPartitionOffsetAndMetaData build();
    }
}

