/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.metrics;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.confluent.kafkarest.utils.MultiTenantUtils;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.MetricNameTemplate;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeCount;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.WindowedCount;
import org.eclipse.jetty.servlets.DoSFilter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTenantMetricsDosFilterListener
extends DoSFilter.Listener {
    static final String UNKNOWN_TENANT = "unknown";
    private static final Logger log = LoggerFactory.getLogger(MultiTenantMetricsDosFilterListener.class);
    private static final long SENSOR_EXPIRY_SECONDS = TimeUnit.HOURS.toSeconds(1L);
    private static final String GROUP_NAME = "jetty-metrics";
    private static final Duration SENSOR_CACHE_EXPIRY = Duration.ofMinutes(1L);
    private final Metrics metrics;
    private final String sensorNamePrefix;
    private final SortedMap<String, String> instanceMetricsTags = new TreeMap<String, String>(){
        {
            this.put("http_status_code", "429");
        }
    };
    private final LoadingCache<String, Sensor> fourTwoNineSensors;

    public MultiTenantMetricsDosFilterListener(Metrics metrics, Map<String, String> metricTags, String jmxPrefix) {
        this.metrics = Objects.requireNonNull(metrics);
        if (metricTags != null) {
            this.instanceMetricsTags.putAll(metricTags);
        }
        String sensorTags = this.instanceMetricsTags.keySet().stream().map(key -> ":" + (String)this.instanceMetricsTags.get(key)).collect(Collectors.joining());
        this.sensorNamePrefix = jmxPrefix + ":" + GROUP_NAME + ":request-errors" + sensorTags;
        this.fourTwoNineSensors = CacheBuilder.newBuilder().expireAfterAccess(SENSOR_CACHE_EXPIRY).build((CacheLoader)new CacheLoader<String, Sensor>(){

            public Sensor load(@NotNull String key) {
                return MultiTenantMetricsDosFilterListener.this.createSensor(key);
            }
        });
    }

    public DoSFilter.Action onRequestOverLimit(HttpServletRequest request, DoSFilter.OverLimit overlimit, DoSFilter dosFilter) {
        DoSFilter.Action action = DoSFilter.Action.fromDelay((long)dosFilter.getDelayMs());
        if (action == DoSFilter.Action.REJECT) {
            try {
                String tenant = MultiTenantMetricsDosFilterListener.extractTenantFromServerName(request.getServerName());
                ((Sensor)this.fourTwoNineSensors.getUnchecked((Object)tenant)).record();
            }
            catch (Exception e) {
                log.debug("Error while recording Jetty 429 metrics", (Throwable)e);
            }
        }
        return action;
    }

    private static String extractTenantFromServerName(String serverName) {
        try {
            return MultiTenantUtils.extractClusterIdFromUriHost(serverName).orElse(UNKNOWN_TENANT);
        }
        catch (IllegalArgumentException e) {
            return UNKNOWN_TENANT;
        }
    }

    private Sensor createSensor(final String tenant) {
        Sensor fourTwoNineSensor = this.metrics.sensor(this.sensorNamePrefix + ":tenant" + tenant, null, SENSOR_EXPIRY_SECONDS, Sensor.RecordingLevel.INFO, (Sensor[])null);
        TreeMap<String, String> tenantMetricsTags = new TreeMap<String, String>(){
            {
                this.put("tenant", tenant);
            }
        };
        tenantMetricsTags.putAll(this.instanceMetricsTags);
        fourTwoNineSensor.add(this.getMetricName(this.metrics, "request-error-rate", "The average number of requests per second that resulted in 429 HTTP error responses in Jetty layer", (Map<String, String>)tenantMetricsTags), (MeasurableStat)new Rate());
        fourTwoNineSensor.add(this.getMetricName(this.metrics, "request-error-count", "A windowed count of requests that resulted in 429 HTTP error responses in Jetty layer", (Map<String, String>)tenantMetricsTags), (MeasurableStat)new WindowedCount());
        fourTwoNineSensor.add(this.getMetricName(this.metrics, "request-error-total", "A cumulative count of requests that resulted in 429 HTTP error responses in Jetty layer", (Map<String, String>)tenantMetricsTags), (MeasurableStat)new CumulativeCount());
        this.fourTwoNineSensors.put((Object)tenant, (Object)fourTwoNineSensor);
        return fourTwoNineSensor;
    }

    private MetricName getMetricName(Metrics metrics, String name, String doc, Map<String, String> metricsTags) {
        return metrics.metricInstance(new MetricNameTemplate(name, GROUP_NAME, doc, metricsTags.keySet()), metricsTags);
    }
}

