/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.BalancerManager;
import io.confluent.kafkarest.entities.Balancer;
import io.confluent.kafkarest.entities.BalancerAnyUnevenLoadStatus;
import io.confluent.kafkarest.entities.v3.BalancerAnyUnevenLoadStatusData;
import io.confluent.kafkarest.entities.v3.BalancerData;
import io.confluent.kafkarest.entities.v3.GetAnyUnevenLoadResponse;
import io.confluent.kafkarest.entities.v3.GetBalancerResponse;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;

@Path(value="/v3/clusters/{clusterId}/balancer")
@ResourceAccesslistFeature.ResourceName(value="api.v3.balancer.*")
public final class BalancerResource {
    private final Provider<BalancerManager> balancerManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public BalancerResource(Provider<BalancerManager> balancerManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.balancerManager = Objects.requireNonNull(balancerManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.balancer.get")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.balancer.get")
    public void getBalancer(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId) {
        CompletionStage response = ((CompletableFuture)((BalancerManager)this.balancerManager.get()).getBalancer(clusterId).thenApply(balancer -> (Balancer)balancer.orElseThrow(NotFoundException::new))).thenApply(balancer -> GetBalancerResponse.create(BalancerResource.toBalancerData(this.urlFactory, this.crnFactory, balancer)));
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)response);
    }

    @GET
    @Path(value="/any-uneven-load")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.balancer.any-uneven-load.get")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.balancer.any-uneven-load.get")
    public void getAnyUnevenLoad(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId) {
        CompletionStage response = ((CompletableFuture)((BalancerManager)this.balancerManager.get()).getAnyUnevenLoad(clusterId).thenApply(anyUnevenLoad -> (BalancerAnyUnevenLoadStatus)anyUnevenLoad.orElseThrow(NotFoundException::new))).thenApply(evenLoad -> GetAnyUnevenLoadResponse.create(BalancerResource.toAnyUnevenLoadData(this.urlFactory, this.crnFactory, evenLoad)));
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)response);
    }

    private static BalancerData toBalancerData(UrlFactory urlFactory, CrnFactory crnFactory, Balancer balancer) {
        return ((BalancerData.Builder)BalancerData.fromBalancer(balancer).setMetadata(Resource.Metadata.builder().setSelf(urlFactory.create(new String[]{"v3", "clusters", balancer.getClusterId(), "balancer"})).setResourceName(crnFactory.create(new String[]{"kafka", balancer.getClusterId(), "process", "balancer"})).build())).setAnyUnevenLoad(Resource.Relationship.create((String)urlFactory.create(new String[]{"v3", "clusters", balancer.getClusterId(), "balancer", "any-uneven-load"}))).setBrokerTasks(Resource.Relationship.create((String)urlFactory.create(new String[]{"v3", "clusters", balancer.getClusterId(), "brokers", "-", "tasks"}))).build();
    }

    private static BalancerAnyUnevenLoadStatusData toAnyUnevenLoadData(UrlFactory urlFactory, CrnFactory crnFactory, BalancerAnyUnevenLoadStatus balancerAnyUnevenLoadStatus) {
        return ((BalancerAnyUnevenLoadStatusData.Builder)BalancerAnyUnevenLoadStatusData.fromAnyUnevenLoad(balancerAnyUnevenLoadStatus).setMetadata(Resource.Metadata.builder().setSelf(urlFactory.create(new String[]{"v3", "clusters", balancerAnyUnevenLoadStatus.getClusterId(), "balancer", "any-uneven-load"})).setResourceName(crnFactory.create(new String[]{"kafka", balancerAnyUnevenLoadStatus.getClusterId(), "process", "balancer", "process", "any-uneven-load"})).build())).setBrokerTasks(Resource.Relationship.create((String)urlFactory.create(new String[]{"v3", "clusters", balancerAnyUnevenLoadStatus.getClusterId(), "brokers", "-", "tasks"}))).build();
    }
}

