/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.ConsumerGroupManager;
import io.confluent.kafkarest.controllers.ConsumerGroupOffsetsManager;
import io.confluent.kafkarest.entities.ConsumerGroup;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.rest.annotations.PerformanceMetric;
import io.confluent.rest.exceptions.RestNotFoundException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v3/clusters/{clusterId}/internal/consumer-groups/{consumerGroupId}/offsets")
@ResourceAccesslistFeature.ResourceName(value="api.v3.consumer-groups.offsets.*")
public final class ConsumerGroupOffsetsResource {
    private final Provider<ConsumerGroupOffsetsManager> consumerGroupOffsetsManager;
    private final Provider<ConsumerGroupManager> consumerGroupManager;
    private static final Logger logger = LoggerFactory.getLogger(ConsumerGroupOffsetsResource.class);

    @Inject
    public ConsumerGroupOffsetsResource(Provider<ConsumerGroupOffsetsManager> consumerGroupOffsetsManager, Provider<ConsumerGroupManager> consumerGroupManager) {
        this.consumerGroupOffsetsManager = Objects.requireNonNull(consumerGroupOffsetsManager);
        this.consumerGroupManager = Objects.requireNonNull(consumerGroupManager);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ResourceAccesslistFeature.ResourceName(value="api.v3.consumer-groups.offsets.get")
    @PerformanceMetric(value="api.v3.consumer-groups.offsets.get")
    public void getConsumerGroupOffsets(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="consumerGroupId") String consumerGroupId) {
        ConsumerGroupOffsetsManager manager = (ConsumerGroupOffsetsManager)this.consumerGroupOffsetsManager.get();
        CompletionStage responseFuture = this.checkConsumerGroupExists(clusterId, consumerGroupId).thenCompose(consumerGroup -> {
            if (consumerGroup == null) {
                asyncResponse.resume((Throwable)new RestNotFoundException("Consumer group id not found.", 40405));
                return CompletableFuture.completedFuture(null);
            }
            return manager.getConsumerGroupOffsets(consumerGroupId);
        });
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)responseFuture);
    }

    private CompletableFuture<ConsumerGroup> checkConsumerGroupExists(String clusterId, String consumerGroupId) {
        return ((ConsumerGroupManager)this.consumerGroupManager.get()).getConsumerGroup(clusterId, consumerGroupId).thenApply(consumerGroup -> {
            if (!consumerGroup.isPresent()) {
                logger.error("ConsumerGroupId not found: " + consumerGroupId);
                return null;
            }
            return (ConsumerGroup)consumerGroup.get();
        });
    }
}

