/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.LinkManager;
import io.confluent.kafkarest.entities.Link;
import io.confluent.kafkarest.entities.v3.CreateLinkRequest;
import io.confluent.kafkarest.entities.v3.GetLinkResponse;
import io.confluent.kafkarest.entities.v3.LinkData;
import io.confluent.kafkarest.entities.v3.LinkDataList;
import io.confluent.kafkarest.entities.v3.ListLinksResponse;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.exceptions.ClusterLinkNotFoundException;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v3/clusters/{clusterId}/links")
@ResourceAccesslistFeature.ResourceName(value="api.v3.links.*")
public final class LinkResource {
    private static final Logger log = LoggerFactory.getLogger(LinkResource.class);
    private final Provider<LinkManager> linkManager;
    private final UrlFactory urlFactory;

    @Inject
    public LinkResource(Provider<LinkManager> linkManager, UrlFactory urlFactory) {
        this.linkManager = Objects.requireNonNull(linkManager);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @DELETE
    @Path(value="/{linkName}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.links.delete")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.links.delete")
    public void deleteLink(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="linkName") String linkName, @QueryParam(value="force") @DefaultValue(value="false") boolean force, @QueryParam(value="validate_only") @DefaultValue(value="false") boolean validateOnly) {
        CompletableFuture<Void> response = ((LinkManager)this.linkManager.get()).deleteLink(clusterId, linkName, force, validateOnly);
        AsyncResponses.AsyncResponseBuilder.from((Response.ResponseBuilder)Response.status((Response.Status)Response.Status.NO_CONTENT)).entity(response).asyncResume(asyncResponse);
    }

    private List<LinkData> toLinkDataList(List<Link> links, String clusterId) {
        return links.stream().map(link -> ((LinkData.Builder)LinkData.fromLink(link).setMetadata(Resource.Metadata.builder().setSelf(this.urlFactory.create(new String[]{"v3", "clusters", clusterId, "links", link.getLinkName()})).build())).build()).collect(Collectors.toList());
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.links.list")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.links.list")
    public void listLinks(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId) {
        CompletionStage response = ((LinkManager)this.linkManager.get()).listLinks(clusterId).thenApply(links -> ListLinksResponse.create((LinkDataList)((LinkDataList.Builder)((LinkDataList.Builder)LinkDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create(new String[]{"v3", "clusters", clusterId, "links"})).build())).setData(this.toLinkDataList((List<Link>)links, clusterId))).build()));
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)response);
    }

    @GET
    @Path(value="/{linkName}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.links.get")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.links.get")
    public void getLink(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="linkName") String linkName) {
        CompletionStage response = ((CompletableFuture)((LinkManager)this.linkManager.get()).getLink(clusterId, linkName).thenApply(link -> (Link)link.orElseThrow(() -> new ClusterLinkNotFoundException(linkName)))).thenApply(link -> GetLinkResponse.create(((LinkData.Builder)LinkData.fromLink(link).setMetadata(Resource.Metadata.builder().setSelf(this.urlFactory.create(new String[]{"v3", "clusters", clusterId, "links", link.getLinkName()})).build())).build()));
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)response);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.links.create")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.links.create")
    public void createLink(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @NotNull(message="link_name is required") @QueryParam(value="link_name") @NotNull(message="link_name is required") String linkName, @QueryParam(value="validate_link") @DefaultValue(value="true") boolean validateLink, @QueryParam(value="validate_only") @DefaultValue(value="false") boolean validateOnly, @Valid CreateLinkRequest request) {
        Map<String, String> configs = request.getConfigs().stream().filter(entry -> entry.getValue().isPresent()).collect(Collectors.toMap(CreateLinkRequest.ConfigEntry::getName, entry -> entry.getValue().get()));
        CompletableFuture<Void> response = ((LinkManager)this.linkManager.get()).createLink(clusterId, request.getSourceClusterId(), request.getDestinationClusterId(), request.getRemoteClusterId(), request.getClusterLinkId(), linkName, configs, validateLink, validateOnly);
        AsyncResponses.AsyncResponseBuilder.from((Response.ResponseBuilder)Response.status((Response.Status)Response.Status.CREATED)).entity(response).asyncResume(asyncResponse);
    }
}

