/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.utils;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MultiTenantUtils {
    private static final Pattern CLUSTER_ID_PATTERN = Pattern.compile("^lkc-[a-z0-9]+");

    private MultiTenantUtils() {
    }

    public static Optional<String> extractClusterIdFromUriHost(String host) throws IllegalArgumentException {
        if (host == null) {
            throw new IllegalArgumentException("Host is null in request URI");
        }
        if (host.startsWith("lkc-")) {
            Matcher matcher = CLUSTER_ID_PATTERN.matcher(host);
            if (matcher.find()) {
                String clusterId = matcher.group();
                return Optional.of(clusterId);
            }
            throw new IllegalArgumentException("Invalid cluster id in host: " + host);
        }
        return Optional.empty();
    }
}

