/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.utils;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ReferenceCountingHolder<V extends AutoCloseable>
implements AutoCloseable {
    private final AtomicInteger referenceCount = new AtomicInteger(1);
    private final V resource;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public ReferenceCountingHolder(V resource) {
        this.resource = resource;
    }

    public V get() {
        if (this.referenceCount.get() == 0) {
            throw new IllegalStateException("resource does not exist");
        }
        return this.resource;
    }

    public void increment() {
        int count;
        do {
            count = this.referenceCount.get();
            if (this.referenceCount.get() != 0) continue;
            throw new IllegalStateException("resource already closed");
        } while (!this.referenceCount.compareAndSet(count, count + 1));
    }

    public void decrement() {
        if (this.referenceCount.decrementAndGet() == 0) {
            try {
                this.resource.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Exception closing resource", e);
            }
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.decrement();
        }
    }

    public int getCount() {
        return this.referenceCount.get();
    }
}

