/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rules.jsonata;

import com.api.jsonata4java.expressions.EvaluateException;
import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.Expressions;
import com.api.jsonata4java.expressions.ParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleKind;
import io.confluent.kafka.schemaregistry.rules.RuleContext;
import io.confluent.kafka.schemaregistry.rules.RuleException;
import io.confluent.kafka.schemaregistry.rules.RuleExecutor;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.apache.kafka.common.config.ConfigException;

public class JsonataExecutor
implements RuleExecutor {
    public static final String TYPE = "JSONATA";
    public static final String JSONATA_TIMEOUT_MS = "jsonata.timeout.ms";
    public static final String JSONATA_MAX_DEPTH = "jsonata.max.depth";
    @Deprecated
    public static final String TIMEOUT_MS = "timeout.ms";
    @Deprecated
    public static final String MAX_DEPTH = "max.depth";
    private long timeoutMs = 60000L;
    private int maxDepth = 1000;
    private static final int DEFAULT_CACHE_SIZE = 100;
    private final LoadingCache<String, Expressions> cache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<String, Expressions>(){

        public Expressions load(String expr) throws Exception {
            try {
                return Expressions.parse((String)expr);
            }
            catch (ParseException e) {
                throw new RuleException("Could not parse expression", (Throwable)e);
            }
            catch (EvaluateRuntimeException ere) {
                throw new RuleException("Could not evaluate expression", (Throwable)ere);
            }
            catch (JsonProcessingException e) {
                throw new RuleException("Could not parse message", (Throwable)e);
            }
            catch (IOException e) {
                throw new RuleException((Throwable)e);
            }
        }
    });

    public void configure(Map<String, ?> configs) {
        Long timeoutMsConfig = JsonataExecutor.parseConfig(configs, JSONATA_TIMEOUT_MS, Long::parseLong);
        if (timeoutMsConfig != null) {
            this.timeoutMs = timeoutMsConfig;
        } else {
            timeoutMsConfig = JsonataExecutor.parseConfig(configs, TIMEOUT_MS, Long::parseLong);
            if (timeoutMsConfig != null) {
                this.timeoutMs = timeoutMsConfig;
            }
        }
        Integer maxDepthConfig = JsonataExecutor.parseConfig(configs, JSONATA_MAX_DEPTH, Integer::parseInt);
        if (maxDepthConfig != null) {
            this.maxDepth = maxDepthConfig;
        } else {
            maxDepthConfig = JsonataExecutor.parseConfig(configs, MAX_DEPTH, Integer::parseInt);
            if (maxDepthConfig != null) {
                this.maxDepth = maxDepthConfig;
            }
        }
    }

    private static <T> T parseConfig(Map<String, ?> configs, String name, Function<String, T> function) throws ConfigException {
        Object config = configs.get(name);
        if (config != null) {
            try {
                return function.apply(config.toString());
            }
            catch (Exception e) {
                throw new ConfigException("Cannot parse " + name);
            }
        }
        return null;
    }

    public String type() {
        return TYPE;
    }

    public Object transform(RuleContext ctx, Object message) throws RuleException {
        Expressions expr;
        JsonNode jsonObj;
        if (message instanceof JsonNode) {
            jsonObj = (JsonNode)message;
        } else {
            try {
                jsonObj = ctx.target().toJson(message);
            }
            catch (IOException e) {
                throw new RuleException((Throwable)e);
            }
        }
        try {
            expr = (Expressions)this.cache.get((Object)ctx.rule().getExpr());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuleException) {
                throw (RuleException)e.getCause();
            }
            throw new RuleException("Could not get expression", e.getCause());
        }
        try {
            JsonNode result = expr.evaluate(jsonObj, this.timeoutMs, this.maxDepth);
            return ctx.rule().getKind() == RuleKind.CONDITION ? Boolean.valueOf(result.asBoolean(true)) : result;
        }
        catch (EvaluateException e) {
            throw new RuleException("Could not evaluate expression", (Throwable)e);
        }
    }
}

