/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.util;

import io.confluent.common.security.auth.JwtPrincipal;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class JwtUtils {
    public static Set<String> getGroupsFromJwtPrincipal(JwtPrincipal principal) {
        if (Objects.equals(principal.jwtClaims().get("iss"), "Confluent")) {
            return JwtUtils.getGroupsFromJwtPrincipal(principal, "groups");
        }
        return JwtUtils.getGroupsFromJwtPrincipal(principal, principal.getGroupsClaimName());
    }

    private static Set<String> getGroupsFromJwtPrincipal(JwtPrincipal principal, String groupsClaimName) {
        if (Objects.isNull(groupsClaimName) || groupsClaimName.isEmpty()) {
            return Collections.emptySet();
        }
        List groupsObj = principal.jwtClaims().getOrDefault(groupsClaimName, Collections.emptyList());
        if (Objects.nonNull(groupsObj) && !(groupsObj instanceof List)) {
            throw new IllegalArgumentException(String.format("Unexpected type of groups in jwt. Expected type: %s, Actual type: %s", List.class, groupsObj.getClass()));
        }
        HashSet<String> groups = new HashSet<String>();
        for (Object groupObj : groupsObj) {
            if (!(groupObj instanceof String)) {
                throw new IllegalArgumentException(String.format("Unexpected type of %s. Expected type: %s, Actual type: %s", groupsClaimName, String.class, groupObj.getClass()));
            }
            groups.add((String)groupObj);
        }
        return groups;
    }
}

