/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.utils;

import io.confluent.kafka.storage.checksum.ChecksumInfo;
import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class E2EChecksumUtils {
    private static final Logger LOG = LoggerFactory.getLogger(E2EChecksumUtils.class);

    private E2EChecksumUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String convertToBase64(long value) {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putLong(0, value);
        buf.position(4);
        byte[] bytes = new byte[4];
        buf.get(bytes);
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static Optional<String> getBase64CrcFromStore(E2EChecksumStore checksumStore, File file, Map<String, String> metadata) {
        String key = file.getAbsolutePath();
        Optional<ChecksumInfo> optCrc = checksumStore.store().get(key);
        if (!optCrc.isPresent()) {
            LOG.warn("E2E Checksum entry not found for {} :{}", (Object)key, metadata);
            checksumStore.store().metrics().recordEntryNotFound();
            return Optional.empty();
        }
        ChecksumInfo crc = optCrc.get();
        long fileSize = file.length();
        if (crc.sizeInBytes() > fileSize) {
            LOG.error("E2E Checksum entry {} : {} sizeInBytes > file size({}): {}", new Object[]{key, crc, fileSize, metadata});
            checksumStore.store().metrics().recordSizeInBytesValIsGreater();
        }
        if (crc.sizeInBytes() < fileSize) {
            LOG.error("E2E Checksum entry {} : {}  sizeInBytes < file size({}): {}", new Object[]{key, crc, fileSize, metadata});
            checksumStore.store().metrics().recordSizeInBytesValIsLesser();
        }
        return Optional.of(E2EChecksumUtils.convertToBase64(crc.checksum().getValue()));
    }
}

