/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage.generated;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class RemoteLogSegmentMetadataUpdateRecord
implements ApiMessage {
    RemoteLogSegmentIdEntry remoteLogSegmentId;
    int brokerId;
    long eventTimestampMs;
    byte[] customMetadata;
    byte remoteLogSegmentState;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("remote_log_segment_id", (Type)RemoteLogSegmentIdEntry.SCHEMA_0, "Unique representation of the remote log segment."), new Field("broker_id", (Type)Type.INT32, "Broker id from which this event is generated."), new Field("event_timestamp_ms", (Type)Type.INT64, "Epoch time in milli seconds at which this event is generated."), new Field("custom_metadata", (Type)Type.COMPACT_NULLABLE_BYTES, "Custom metadata."), new Field("remote_log_segment_state", (Type)Type.INT8, "State identifier of the remote log segment, which is RemoteLogSegmentState.id()."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public RemoteLogSegmentMetadataUpdateRecord(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public RemoteLogSegmentMetadataUpdateRecord(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public RemoteLogSegmentMetadataUpdateRecord() {
        this.remoteLogSegmentId = new RemoteLogSegmentIdEntry();
        this.brokerId = 0;
        this.eventTimestampMs = 0L;
        this.customMetadata = null;
        this.remoteLogSegmentState = 0;
    }

    public short apiKey() {
        return 1;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public final void read(Readable _readable, short _version, MessageContext _context) {
        this.remoteLogSegmentId = new RemoteLogSegmentIdEntry(_readable, _version, _context);
        this.brokerId = _readable.readInt();
        this.eventTimestampMs = _readable.readLong();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.customMetadata = null;
        } else {
            byte[] newBytes = _readable.readArray(length);
            this.customMetadata = newBytes;
        }
        this.remoteLogSegmentState = _readable.readByte();
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        this.remoteLogSegmentId.write(_writable, _cache, _version, _context);
        _writable.writeInt(this.brokerId);
        _writable.writeLong(this.eventTimestampMs);
        if (this.customMetadata == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.customMetadata.length + 1);
            _writable.writeByteArray(this.customMetadata);
        }
        _writable.writeByte(this.remoteLogSegmentState);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        this.remoteLogSegmentId.addSize(_size, _cache, _version, _context);
        _size.addBytes(4);
        _size.addBytes(8);
        if (this.customMetadata == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(this.customMetadata.length);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.customMetadata.length + 1)));
        }
        _size.addBytes(1);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RemoteLogSegmentMetadataUpdateRecord)) {
            return false;
        }
        RemoteLogSegmentMetadataUpdateRecord other = (RemoteLogSegmentMetadataUpdateRecord)obj;
        if (this.remoteLogSegmentId == null ? other.remoteLogSegmentId != null : !this.remoteLogSegmentId.equals(other.remoteLogSegmentId)) {
            return false;
        }
        if (this.brokerId != other.brokerId) {
            return false;
        }
        if (this.eventTimestampMs != other.eventTimestampMs) {
            return false;
        }
        if (!Arrays.equals(this.customMetadata, other.customMetadata)) {
            return false;
        }
        if (this.remoteLogSegmentState != other.remoteLogSegmentState) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.remoteLogSegmentId == null ? 0 : this.remoteLogSegmentId.hashCode());
        hashCode = 31 * hashCode + this.brokerId;
        hashCode = 31 * hashCode + ((int)(this.eventTimestampMs >> 32) ^ (int)this.eventTimestampMs);
        hashCode = 31 * hashCode + Arrays.hashCode(this.customMetadata);
        hashCode = 31 * hashCode + this.remoteLogSegmentState;
        return hashCode;
    }

    public RemoteLogSegmentMetadataUpdateRecord duplicate() {
        RemoteLogSegmentMetadataUpdateRecord _duplicate = new RemoteLogSegmentMetadataUpdateRecord();
        _duplicate.remoteLogSegmentId = this.remoteLogSegmentId.duplicate();
        _duplicate.brokerId = this.brokerId;
        _duplicate.eventTimestampMs = this.eventTimestampMs;
        _duplicate.customMetadata = (byte[])(this.customMetadata == null ? null : MessageUtil.duplicate((byte[])this.customMetadata));
        _duplicate.remoteLogSegmentState = this.remoteLogSegmentState;
        return _duplicate;
    }

    public String toString() {
        return "RemoteLogSegmentMetadataUpdateRecord(remoteLogSegmentId=" + this.remoteLogSegmentId.toString() + ", brokerId=" + this.brokerId + ", eventTimestampMs=" + this.eventTimestampMs + ", customMetadata=" + Arrays.toString(this.customMetadata) + ", remoteLogSegmentState=" + this.remoteLogSegmentState + ")";
    }

    public RemoteLogSegmentIdEntry remoteLogSegmentId() {
        return this.remoteLogSegmentId;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public long eventTimestampMs() {
        return this.eventTimestampMs;
    }

    public byte[] customMetadata() {
        return this.customMetadata;
    }

    public byte remoteLogSegmentState() {
        return this.remoteLogSegmentState;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public RemoteLogSegmentMetadataUpdateRecord setRemoteLogSegmentId(RemoteLogSegmentIdEntry v) {
        this.remoteLogSegmentId = v;
        return this;
    }

    public RemoteLogSegmentMetadataUpdateRecord setBrokerId(int v) {
        this.brokerId = v;
        return this;
    }

    public RemoteLogSegmentMetadataUpdateRecord setEventTimestampMs(long v) {
        this.eventTimestampMs = v;
        return this;
    }

    public RemoteLogSegmentMetadataUpdateRecord setCustomMetadata(byte[] v) {
        this.customMetadata = v;
        return this;
    }

    public RemoteLogSegmentMetadataUpdateRecord setRemoteLogSegmentState(byte v) {
        this.remoteLogSegmentState = v;
        return this;
    }

    public static class TopicIdPartitionEntry
    implements Message {
        String name;
        Uuid id;
        int partition;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.COMPACT_STRING, "Topic name."), new Field("id", (Type)Type.UUID, "Unique identifier of the topic."), new Field("partition", (Type)Type.INT32, "Partition number."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TopicIdPartitionEntry(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public TopicIdPartitionEntry() {
            this.name = "";
            this.id = Uuid.ZERO_UUID;
            this.partition = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicIdPartitionEntry");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.id = _readable.readUuid();
            this.partition = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.name);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeUuid(this.id);
            _writable.writeInt(this.partition);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicIdPartitionEntry");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _size.addBytes(16);
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicIdPartitionEntry)) {
                return false;
            }
            TopicIdPartitionEntry other = (TopicIdPartitionEntry)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (!this.id.equals((Object)other.id)) {
                return false;
            }
            if (this.partition != other.partition) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + this.id.hashCode();
            hashCode = 31 * hashCode + this.partition;
            return hashCode;
        }

        public TopicIdPartitionEntry duplicate() {
            TopicIdPartitionEntry _duplicate = new TopicIdPartitionEntry();
            _duplicate.name = this.name;
            _duplicate.id = this.id;
            _duplicate.partition = this.partition;
            return _duplicate;
        }

        public String toString() {
            return "TopicIdPartitionEntry(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", id=" + this.id.toString() + ", partition=" + this.partition + ")";
        }

        public String name() {
            return this.name;
        }

        public Uuid id() {
            return this.id;
        }

        public int partition() {
            return this.partition;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicIdPartitionEntry setName(String v) {
            this.name = v;
            return this;
        }

        public TopicIdPartitionEntry setId(Uuid v) {
            this.id = v;
            return this;
        }

        public TopicIdPartitionEntry setPartition(int v) {
            this.partition = v;
            return this;
        }
    }

    public static class RemoteLogSegmentIdEntry
    implements Message {
        TopicIdPartitionEntry topicIdPartition;
        Uuid id;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("topic_id_partition", (Type)TopicIdPartitionEntry.SCHEMA_0, "Represents unique topic partition."), new Field("id", (Type)Type.UUID, "Unique identifier of the remote log segment."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public RemoteLogSegmentIdEntry(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public RemoteLogSegmentIdEntry() {
            this.topicIdPartition = new TopicIdPartitionEntry();
            this.id = Uuid.ZERO_UUID;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of RemoteLogSegmentIdEntry");
            }
            this.topicIdPartition = new TopicIdPartitionEntry(_readable, _version, _context);
            this.id = _readable.readUuid();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            this.topicIdPartition.write(_writable, _cache, _version, _context);
            _writable.writeUuid(this.id);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of RemoteLogSegmentIdEntry");
            }
            this.topicIdPartition.addSize(_size, _cache, _version, _context);
            _size.addBytes(16);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RemoteLogSegmentIdEntry)) {
                return false;
            }
            RemoteLogSegmentIdEntry other = (RemoteLogSegmentIdEntry)obj;
            if (this.topicIdPartition == null ? other.topicIdPartition != null : !this.topicIdPartition.equals(other.topicIdPartition)) {
                return false;
            }
            if (!this.id.equals((Object)other.id)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicIdPartition == null ? 0 : this.topicIdPartition.hashCode());
            hashCode = 31 * hashCode + this.id.hashCode();
            return hashCode;
        }

        public RemoteLogSegmentIdEntry duplicate() {
            RemoteLogSegmentIdEntry _duplicate = new RemoteLogSegmentIdEntry();
            _duplicate.topicIdPartition = this.topicIdPartition.duplicate();
            _duplicate.id = this.id;
            return _duplicate;
        }

        public String toString() {
            return "RemoteLogSegmentIdEntry(topicIdPartition=" + this.topicIdPartition.toString() + ", id=" + this.id.toString() + ")";
        }

        public TopicIdPartitionEntry topicIdPartition() {
            return this.topicIdPartition;
        }

        public Uuid id() {
            return this.id;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public RemoteLogSegmentIdEntry setTopicIdPartition(TopicIdPartitionEntry v) {
            this.topicIdPartition = v;
            return this;
        }

        public RemoteLogSegmentIdEntry setId(Uuid v) {
            this.id = v;
            return this;
        }
    }
}

