/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql;

import java.util.Optional;

public final class SqlBooleans {
    private SqlBooleans() {
    }

    public static boolean parseBoolean(String value) {
        return SqlBooleans.booleanStringMatches(value, true);
    }

    public static Optional<Boolean> parseBooleanExact(String value) {
        if (SqlBooleans.booleanStringMatches(value, true)) {
            return Optional.of(true);
        }
        if (SqlBooleans.booleanStringMatches(value, false)) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    private static boolean booleanStringMatches(String str, boolean required) {
        if (str.isEmpty()) {
            return false;
        }
        String tf = required ? "true" : "false";
        String yn = required ? "yes" : "no";
        return str.equalsIgnoreCase(tf.substring(0, Math.min(str.length(), tf.length()))) || str.equalsIgnoreCase(yn.substring(0, Math.min(str.length(), yn.length())));
    }
}

