/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.kafka.common.utils.Time;

public class RateLimiter {
    private final long windowNs;
    private final int maxActionsPerWindow;
    private final Time time;
    private long windowStartNs;
    private int actionsPerformed;
    private int actionsDenied;

    private RateLimiter(int windowMs, int maxActionsPerWindow, Time time) {
        this.windowNs = TimeUnit.MILLISECONDS.toNanos(windowMs);
        this.maxActionsPerWindow = maxActionsPerWindow;
        this.time = time;
        this.windowStartNs = 0L;
        this.actionsPerformed = 0;
        this.actionsDenied = 0;
    }

    public void maybeRun(Consumer<Integer> action) {
        long nowNs = this.time.nanoseconds();
        int denied = this.findRunArgument(nowNs);
        if (denied >= 0) {
            action.accept(denied);
        }
    }

    public void maybeLog(Consumer<String> logAction) {
        long nowNs = this.time.nanoseconds();
        int denied = this.findRunArgument(nowNs);
        if (denied == 0) {
            logAction.accept("");
        } else if (denied > 0) {
            logAction.accept(String.format(" (Suppressed %d similar log messages in the last %d milliseconds.)", denied, TimeUnit.NANOSECONDS.toMillis(this.windowNs)));
        }
    }

    private synchronized int findRunArgument(long nowNs) {
        int denied = 0;
        if (this.windowStartNs > nowNs || nowNs - this.windowStartNs > this.windowNs) {
            this.windowStartNs = nowNs;
            denied = this.actionsDenied;
            this.actionsPerformed = 0;
            this.actionsDenied = 0;
        }
        if (this.actionsPerformed + 1 > this.maxActionsPerWindow) {
            ++this.actionsDenied;
            return -1;
        }
        ++this.actionsPerformed;
        return denied;
    }

    Time time() {
        return this.time;
    }

    public static class Builder {
        private int windowMs = 30000;
        private int maxActionsPerWindow = 100;
        private Time time = Time.SYSTEM;

        public Builder setWindowLength(int windowMs) {
            this.windowMs = windowMs;
            return this;
        }

        public Builder setMaxActionsPerWindow(int maxActionsPerWindow) {
            this.maxActionsPerWindow = maxActionsPerWindow;
            return this;
        }

        public Builder setTime(Time time) {
            this.time = time;
            return this;
        }

        public RateLimiter build() {
            return new RateLimiter(this.windowMs, this.maxActionsPerWindow, this.time);
        }
    }
}

