/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.clients.plugins.auth.oauth.OAuthBearerLoginCallbackHandler;
import io.confluent.kafka.multitenant.BasePhysicalClusterMetadata;
import io.confluent.kafka.multitenant.TopicBasedPhysicalClusterMetadata;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.integration.cluster.LogicalCluster;
import io.confluent.kafka.multitenant.integration.cluster.LogicalClusterUser;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.security.audit.event.ConfluentAuthenticationEvent;
import io.confluent.kafka.security.authorizer.MockAuditLogProvider;
import io.confluent.kafka.server.plugins.auth.oauth.OAuthUtils;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import io.confluent.security.authorizer.Scope;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.metadata.TopicPlacement;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.apache.kafka.server.audit.AuthenticationErrorInfo;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="integration")
public class OAuthValidatorIntegrationTest {
    private static final Logger log = LoggerFactory.getLogger(OAuthValidatorIntegrationTest.class);
    private static final String CONSUMER_OFFSET_PLACEMENT_CONSTRAINT = "{\"version\":1,\"replicas\":[{\"count\": 1, \"constraints\":{\"rack\":\"rack-1\"}}]}";
    private static final String VALID_ORG = Utils.LC_META_ABC.organizationId();
    private static final String INVALID_ORG = "org_2";
    private final String logicalClusterId = Utils.LC_META_ABC.logicalClusterId();
    private final Properties adminProperties = new Properties();
    private IntegrationTestHarness testHarness;
    private OAuthUtils.JwsContainer jwsContainer;
    private String brokerUUID;
    private final String testTopic = "abcd";
    private final List<NewTopic> sampleTopics;
    private LogicalClusterUser testUser;
    private TestInfo testInfo;
    private PhysicalCluster physicalCluster;
    private final String lkcMetadataTopic = "_confluent-logical_clusters";
    private final AtomicInteger sequenceId;
    long topicCreateTimeout;

    public OAuthValidatorIntegrationTest() {
        this.adminProperties.put("sasl.login.callback.handler.class", OAuthBearerLoginCallbackHandler.class.getName());
        this.testTopic = "abcd";
        this.sampleTopics = Collections.singletonList(new NewTopic("abcd", 3, 1));
        this.lkcMetadataTopic = "_confluent-logical_clusters";
        this.sequenceId = new AtomicInteger();
        this.topicCreateTimeout = 15000L;
    }

    @BeforeEach
    public void setUpTempDir(TestInfo testInfo) {
        this.testInfo = testInfo;
    }

    private void setUp() throws Exception {
        MockAuditLogProvider.reset();
        this.setUp(VALID_ORG);
    }

    private void setUp(String orgResourceId) throws Exception {
        this.setUp(null, orgResourceId);
    }

    private void setUp(String aud, String orgResourceId) throws Exception {
        this.testHarness = new IntegrationTestHarness(this.testInfo, 1, Collections.singletonList("rack-1"));
        boolean serviceUserId = true;
        String subject = "1";
        this.jwsContainer = new OAuthUtils.Builder(100000, "Confluent", subject, orgResourceId).audience(aud).build();
        this.physicalCluster = this.testHarness.startWithTopic("_confluent-logical_clusters", 1, 1, this.topicCreateTimeout, this.setUpMetadata(this.nodeProps()), this.nodeProps());
        int adminUserId = 100;
        LogicalCluster logicalCluster = this.physicalCluster.createLogicalCluster(this.logicalClusterId, VALID_ORG, "env-1", 100, 1);
        this.testUser = logicalCluster.user(1);
        this.loadLkcMetadata();
        this.addAdminAcls();
    }

    private void addAdminAcls() {
        this.testHarness.newAclCommand().addTopicAclArgs(this.testUser.prefixedKafkaPrincipal(), this.testUser.withPrefix("abcd"), AclOperation.ALL, PatternType.LITERAL).execute();
    }

    @AfterEach
    public void tearDown() throws Exception {
        try {
            this.testHarness.shutdown();
        }
        finally {
            KafkaTestUtils.verifyThreadCleanup();
        }
    }

    private Properties setUpMetadata(Properties brokerProps) throws IOException, InterruptedException {
        this.brokerUUID = "uuid";
        brokerProps.put("broker.session.uuid", this.brokerUUID);
        return brokerProps;
    }

    private Properties nodeProps() {
        Properties props = IntegrationTestHarness.defaultOAuthBrokerProps();
        props.put("listener.name.external.oauthbearer.sasl.jaas.config", "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required publicKeyPath=\"" + this.jwsContainer.getPublicKeyFile().toPath() + "\";");
        props.put(KafkaConfig.OffsetsTopicPlacementConstraintsProp(), CONSUMER_OFFSET_PLACEMENT_CONSTRAINT);
        props.put("confluent.cdc.lkc.metadata.topic", "_confluent-logical_clusters");
        props.put("multitenant.metadata.class", TopicBasedPhysicalClusterMetadata.class.getName());
        return props;
    }

    private String clientJaasConfig(String jwsToken, String allowedCluster) {
        return "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule Required token=\"" + jwsToken + "\" cluster=\"" + allowedCluster + "\";";
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCorrectConfigurationAuthenticatesSuccessfully(String quorum) throws Exception {
        this.setUp();
        AdminClient client = this.testHarness.createOAuthAdminClient(this.clientJaasConfig(this.jwsContainer.getJwsToken(), this.logicalClusterId), this.adminProperties);
        client.createTopics(this.sampleTopics).all().get();
        List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
        TestUtils.retryOnExceptionWithTimeout((long)30000L, () -> Assertions.assertTrue((boolean)((Set)client.listTopics().names().get()).containsAll(expectedTopics)));
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.getInstance(this.brokerUUID);
        ConfluentAuthenticationEvent authenticationEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        Assertions.assertEquals((Object)"User", (Object)((KafkaPrincipal)authenticationEvent.principal().get()).getPrincipalType());
        Assertions.assertEquals((Object)"1", (Object)((KafkaPrincipal)authenticationEvent.principal().get()).getName());
        Assertions.assertEquals((Object)AuditEventStatus.SUCCESS, (Object)authenticationEvent.status());
        Assertions.assertFalse((boolean)((KafkaPrincipal)authenticationEvent.principal().get()).toString().contains("tenantMetadata"));
        Scope scope = new Scope.Builder(new String[0]).addPath("organization=" + Utils.LC_META_ABC.organizationId()).addPath("environment=" + Utils.LC_META_ABC.environmentId()).addPath("cloud-cluster=" + Utils.LC_META_ABC.logicalClusterId()).withKafkaCluster(Utils.LC_META_ABC.logicalClusterId()).build();
        Assertions.assertEquals((Object)scope, (Object)authenticationEvent.getScope());
        SaslAuthenticationContext authenticationContext = (SaslAuthenticationContext)authenticationEvent.authenticationContext();
        Assertions.assertEquals((Object)"1", (Object)authenticationContext.server().getAuthorizationID());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testClusterInExtensionNotBelongToTokenOrgThrowsException(String quorum) throws Exception {
        this.setUp(INVALID_ORG);
        Class<SaslAuthenticationException> expectedException = SaslAuthenticationException.class;
        try {
            AdminClient client = this.testHarness.createOAuthAdminClient(this.clientJaasConfig(this.jwsContainer.getJwsToken(), this.logicalClusterId), this.adminProperties);
            client.createTopics(this.sampleTopics).all().get();
            Assertions.fail((String)String.format("Expected admin command to throw a %s", expectedException));
        }
        catch (Exception e) {
            if (e.getCause().getClass() != expectedException) {
                Assertions.fail((String)String.format("Expected admin command to throw a %s but it threw a %s", expectedException, e.getCause().getClass()));
            }
            log.info("Expected exception message: {}", (Object)e.getCause().getMessage());
        }
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.getInstance(this.brokerUUID);
        ConfluentAuthenticationEvent authenticationEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        Assertions.assertFalse((boolean)authenticationEvent.principal().isPresent());
        Assertions.assertEquals((Object)AuditEventStatus.UNAUTHENTICATED, (Object)authenticationEvent.status());
        Assertions.assertTrue((boolean)authenticationEvent.getScope().toString().contains("kafka-cluster=" + this.logicalClusterId));
        Assertions.assertTrue((boolean)authenticationEvent.authenticationException().isPresent());
        AuthenticationException authenticationException = (AuthenticationException)authenticationEvent.authenticationException().get();
        AuthenticationErrorInfo errorInfo = authenticationException.errorInfo();
        Assertions.assertTrue((boolean)errorInfo.errorMessage().contains("logical cluster " + this.logicalClusterId + " is not belong to the org"));
        Assertions.assertEquals((Object)"1", (Object)errorInfo.identifier());
        Assertions.assertEquals((Object)this.logicalClusterId, errorInfo.saslExtensions().get("logicalCluster"));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testAudClaimInTokenShouldWorkIfExpectedAudNotConfigured(String quorum) throws Exception {
        this.setUp("audcalim", VALID_ORG);
        try {
            AdminClient client = this.testHarness.createOAuthAdminClient(this.clientJaasConfig(this.jwsContainer.getJwsToken(), this.logicalClusterId), this.adminProperties);
            client.createTopics(this.sampleTopics).all().get();
        }
        catch (Exception e) {
            Assertions.fail((String)String.format("admin command threw a %s", e.getCause().getClass()));
        }
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.getInstance(this.brokerUUID);
        ConfluentAuthenticationEvent authenticationEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        Assertions.assertTrue((boolean)authenticationEvent.principal().isPresent());
        Assertions.assertEquals((Object)AuditEventStatus.SUCCESS, (Object)authenticationEvent.status());
        Assertions.assertFalse((boolean)authenticationEvent.authenticationException().isPresent());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testClusterInExtensionNotHostedOnBrokerThrowsException(String quorum) throws Exception {
        this.setUp(VALID_ORG);
        Class<SaslAuthenticationException> expectedException = SaslAuthenticationException.class;
        try {
            AdminClient client = this.testHarness.createOAuthAdminClient(this.clientJaasConfig(this.jwsContainer.getJwsToken(), "other-cluster"), this.adminProperties);
            client.createTopics(this.sampleTopics).all().get();
            Assertions.fail((String)String.format("Expected admin command to throw a %s", expectedException));
        }
        catch (Exception e) {
            if (e.getCause().getClass() != expectedException) {
                Assertions.fail((String)String.format("Expected admin command to throw a %s but it threw a %s", expectedException, e.getCause().getClass()));
            }
            log.info("Expected exception message: {}", (Object)e.getCause().getMessage());
        }
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.getInstance(this.brokerUUID);
        ConfluentAuthenticationEvent authenticationEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        Assertions.assertFalse((boolean)authenticationEvent.principal().isPresent());
        Assertions.assertEquals((Object)AuditEventStatus.UNAUTHENTICATED, (Object)authenticationEvent.status());
        Assertions.assertTrue((boolean)authenticationEvent.getScope().toString().contains("kafka-cluster=other-cluster"));
        Assertions.assertTrue((boolean)authenticationEvent.authenticationException().isPresent());
        AuthenticationException authenticationException = (AuthenticationException)authenticationEvent.authenticationException().get();
        AuthenticationErrorInfo errorInfo = authenticationException.errorInfo();
        Assertions.assertTrue((boolean)errorInfo.errorMessage().contains("cluster other-cluster is not hosted on this broker"));
        Assertions.assertEquals((Object)"1", (Object)errorInfo.identifier());
        Assertions.assertEquals((Object)"other-cluster", errorInfo.saslExtensions().get("logicalCluster"));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testIllegalStateExceptionOnBrokerMetadataThrowsException(String quorum) throws Exception {
        this.setUp();
        Class<SaslAuthenticationException> expectedException = SaslAuthenticationException.class;
        try {
            this.closeLkcMetadataCache();
            AdminClient client = this.testHarness.createOAuthAdminClient(this.clientJaasConfig(this.jwsContainer.getJwsToken(), this.logicalClusterId), this.adminProperties);
            client.createTopics(this.sampleTopics).all().get();
            Assertions.fail((String)String.format("Expected admin command to throw a %s", expectedException));
        }
        catch (Exception e) {
            if (e.getCause().getClass() != expectedException) {
                Assertions.fail((String)String.format("Expected admin command to throw a %s but it threw a %s", expectedException, e.getCause().getClass()));
            }
            log.info("Expected exception message: {}", (Object)e.getCause().getMessage());
        }
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.getInstance(this.brokerUUID);
        ConfluentAuthenticationEvent authenticationEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        Assertions.assertFalse((boolean)authenticationEvent.principal().isPresent());
        Assertions.assertEquals((Object)AuditEventStatus.UNAUTHENTICATED, (Object)authenticationEvent.status());
        Assertions.assertTrue((boolean)authenticationEvent.authenticationException().isPresent());
        AuthenticationException authenticationException = (AuthenticationException)authenticationEvent.authenticationException().get();
        AuthenticationErrorInfo errorInfo = authenticationException.errorInfo();
        Assertions.assertTrue((boolean)errorInfo.errorMessage().contains("Could not get cluster metadata to validate the token"));
        Assertions.assertEquals((Object)"1", (Object)errorInfo.identifier());
        Assertions.assertTrue((boolean)errorInfo.clusterId().isEmpty());
    }

    @Disabled(value="KSECURITY-1963")
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testPlacementConstraintForGroupCoordinators(String quorum) throws Throwable {
        this.setUp();
        String jaasConfig = this.clientJaasConfig(this.jwsContainer.getJwsToken(), this.logicalClusterId);
        String topic = "test-topic";
        String consumerGroup = "test-cg";
        try (KafkaProducer<String, String> producer = this.testHarness.createOAuthProducer(jaasConfig, this.adminProperties);){
            KafkaTestUtils.sendRecords(producer, topic, 0, 10);
        }
        var6_6 = null;
        try (KafkaConsumer<String, String> consumer = this.testHarness.createOAuthConsumer(consumerGroup, jaasConfig, this.adminProperties);){
            KafkaTestUtils.consumeRecords(consumer, topic, 0, 10);
            consumer.commitSync();
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        AdminClient adminClient = this.physicalCluster.superAdminClient();
        ConfigResource topicConfigResource = new ConfigResource(ConfigResource.Type.TOPIC, "__consumer_offsets");
        Set<ConfigResource> configsToDescribe = Collections.singleton(topicConfigResource);
        AtomicReference topicConfig = new AtomicReference();
        AtomicReference topicDescription = new AtomicReference();
        TestUtils.waitForCondition(() -> {
            DescribeConfigsResult describeConfigResult = adminClient.describeConfigs((Collection)configsToDescribe);
            topicConfig.set(describeConfigResult);
            DescribeTopicsResult describeTopicsResult = adminClient.describeTopics(Collections.singleton("__consumer_offsets"));
            topicDescription.set(describeTopicsResult);
            Map configResourceConfigMap = (Map)describeConfigResult.all().get(5L, TimeUnit.SECONDS);
            return configResourceConfigMap.size() == 1;
        }, (String)"Unable to find consumer offset topic.");
        Assertions.assertNotNull(topicConfig.get(), (String)"Unable to get consumer offset topic configuration.");
        Config config = (Config)((Map)((DescribeConfigsResult)topicConfig.get()).all().get()).get(topicConfigResource);
        Assertions.assertEquals((Object)TopicPlacement.parse((String)CONSUMER_OFFSET_PLACEMENT_CONSTRAINT), (Object)TopicPlacement.parse((String)config.get("confluent.placement.constraints").value()));
        Assertions.assertNotNull(topicDescription.get(), (String)"Unable to get consumer offset topic description.");
        TopicDescription offsetTopicDescription = (TopicDescription)((Map)((DescribeTopicsResult)topicDescription.get()).allTopicNames().get()).get("__consumer_offsets");
        List offsetTopicPartitions = offsetTopicDescription.partitions();
        offsetTopicPartitions.forEach(tpi -> Assertions.assertEquals((int)1, (int)tpi.replicas().size(), (String)"More than one replica found."));
    }

    public void loadLkcMetadata() {
        this.physicalCluster.kafkaCluster().produceLCMData("_confluent-logical_clusters", this.sequenceId.incrementAndGet(), this.logicalClusterId, Utils.LC_META_ABC);
    }

    public void closeLkcMetadataCache() {
        BasePhysicalClusterMetadata.getInstance((String)this.brokerUUID).close(this.brokerUUID);
    }
}

