/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.oauth.mockserver.server;

import io.confluent.security.auth.oauth.mockserver.server.CommonHttp;
import io.confluent.security.auth.oauth.mockserver.server.Endpoint;
import io.confluent.security.auth.oauth.mockserver.server.MockOAuthServer;
import io.confluent.security.auth.oauth.mockserver.server.Mode;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminServerRequestHandler
implements Handler<HttpServerRequest> {
    private static final Logger log = LoggerFactory.getLogger((String)"admin");
    private final MockOAuthServer verticle;

    public AdminServerRequestHandler(MockOAuthServer verticle) {
        this.verticle = verticle;
    }

    public void handle(HttpServerRequest req) {
        log.info("> " + req.method().name() + " " + req.path());
        CommonHttp.setContextLog(log);
        if (!CommonHttp.isOneOf(req.method(), HttpMethod.POST, HttpMethod.PUT, HttpMethod.GET)) {
            CommonHttp.sendResponse(req, HttpResponseStatus.METHOD_NOT_ALLOWED);
            return;
        }
        String[] path = req.path().split("/");
        if (path.length < 3 || !"admin".equals(path[1])) {
            CommonHttp.sendResponse(req, HttpResponseStatus.NOT_FOUND);
            return;
        }
        try {
            Endpoint endpoint = Endpoint.fromString(path[2]);
            if (endpoint == Endpoint.CLIENTS) {
                this.processClientsRequest(req, path);
                return;
            }
            if (req.method() == HttpMethod.GET) {
                CommonHttp.sendResponse(req, HttpResponseStatus.OK, "");
                return;
            }
            String mode = req.params().get("mode");
            if (mode == null) {
                CommonHttp.sendResponse(req, HttpResponseStatus.BAD_REQUEST, "Parameter 'mode' not set");
                return;
            }
            Mode m = Mode.fromString(mode);
            if (endpoint == Endpoint.SERVER) {
                this.verticle.startAuthServer();
            }
            CommonHttp.sendResponse(req, HttpResponseStatus.OK, m.name());
        }
        catch (Exception e) {
            CommonHttp.handleFailure(req, e, log);
        }
    }

    private void processClientsRequest(HttpServerRequest req, String[] path) {
        if (path.length > 3) {
            CommonHttp.sendResponse(req, HttpResponseStatus.NOT_FOUND);
            return;
        }
        if (req.method() == HttpMethod.GET) {
            CommonHttp.sendResponse(req, HttpResponseStatus.OK, this.getClientsAsJsonString());
            return;
        }
        if (CommonHttp.isOneOf(req.method(), HttpMethod.POST, HttpMethod.PUT)) {
            req.bodyHandler(buffer -> {
                try {
                    log.info(buffer.toString());
                    JsonObject json = buffer.toJsonObject();
                    String clientId = json.getString("clientId");
                    if (clientId == null) {
                        CommonHttp.sendResponse(req, HttpResponseStatus.BAD_REQUEST, "Required attribute 'clientId' is null or missing.");
                        return;
                    }
                    String secret = json.getString("secret");
                    if (secret == null) {
                        CommonHttp.sendResponse(req, HttpResponseStatus.BAD_REQUEST, "Required attribute 'secret' is null or missing.");
                        return;
                    }
                    this.verticle.createOrUpdateClient(clientId, secret);
                    CommonHttp.sendResponse(req, HttpResponseStatus.OK);
                }
                catch (Exception e) {
                    CommonHttp.handleFailure(req, e, log);
                }
            });
            return;
        }
        CommonHttp.sendResponse(req, HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    private String getClientsAsJsonString() {
        JsonArray result = new JsonArray();
        for (Map.Entry<String, String> ent : this.verticle.getClients().entrySet()) {
            JsonObject json = new JsonObject();
            json.put(ent.getKey(), (Object)ent.getValue());
            result.add((Object)json);
        }
        return result.toString();
    }
}

