/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.tinkkey;

import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.tinkkey.KeyAccess;
import com.google.crypto.tink.tinkkey.ProtoKey;
import com.google.crypto.tink.tinkkey.TinkKey;
import java.security.GeneralSecurityException;

public final class KeyHandle {
    private final TinkKey key;

    public static KeyHandle createFromKey(TinkKey key, KeyAccess access) throws GeneralSecurityException {
        KeyHandle result = new KeyHandle(key);
        result.checkAccess(access);
        return result;
    }

    public static KeyHandle createFromKey(KeyData keyData, KeyTemplate.OutputPrefixType opt) {
        return new KeyHandle(new ProtoKey(keyData, opt));
    }

    private KeyHandle(TinkKey key) {
        this.key = key;
    }

    public boolean hasSecret() {
        return this.key.hasSecret();
    }

    public TinkKey getKey(KeyAccess access) throws GeneralSecurityException {
        this.checkAccess(access);
        return this.key;
    }

    private void checkAccess(KeyAccess access) throws GeneralSecurityException {
        if (this.hasSecret() && !access.canAccessSecret()) {
            throw new GeneralSecurityException("No access");
        }
    }
}

