/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.validator;

import io.confluent.kafka.serializers.AbstractKafkaAvroSerDeConfig;
import io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.internals.ConfluentConfigs;

public class RecordSchemaValidatorConfig
extends AbstractConfig {
    public static final String SCHEMA_REGISTRY_URL_CONFIG = "confluent.schema.registry.url";
    public static final String SCHEMA_REGISTRY_URL_DOC = "Comma-separated list of URLs for schema registry instances that can be used to look up schemas.";
    public static final String KEY_SCHEMA_VALIDATION_CONFIG = "confluent.key.schema.validation";
    public static final String KEY_SCHEMA_VALIDATION_DOC = "True if schema validation at record key is enabled for this topic.";
    public static final String VALUE_SCHEMA_VALIDATION_CONFIG = "confluent.value.schema.validation";
    public static final String VALUE_SCHEMA_VALIDATION_DOC = "True if schema validation at record value is enabled for this topic.";
    public static final String KEY_SUBJECT_NAME_STRATEGY_CONFIG = "confluent.key.subject.name.strategy";
    public static final String KEY_SUBJECT_NAME_STRATEGY_DEFAULT = AbstractKafkaAvroSerDeConfig.KEY_SUBJECT_NAME_STRATEGY_DEFAULT;
    public static final String KEY_SUBJECT_NAME_STRATEGY_DOC = "Determines how to construct the subject name under which the key schema is registered with the schema registry. By default, TopicNameStrategy is used";
    public static final String VALUE_SUBJECT_NAME_STRATEGY_CONFIG = "confluent.value.subject.name.strategy";
    public static final String VALUE_SUBJECT_NAME_STRATEGY_DEFAULT = AbstractKafkaAvroSerDeConfig.VALUE_SUBJECT_NAME_STRATEGY_DEFAULT;
    public static final String VALUE_SUBJECT_NAME_STRATEGY_DOC = "Determines how to construct the subject name under which the value schema is registered with the schema registry. By default, TopicNameStrategy is used";
    public static final String MAX_CACHE_SIZE_CONFIG = "confluent.schema.registry.max.cache.size";
    public static final String MAX_CACHE_SIZE_DOC = "Maximum size of each LRU cache used to cache responses from the schema registry. There is one cache to hold the ID to schema mappings and another to hold the schemas that are registered to a subject.";
    public static final int MAX_CACHE_SIZE_DEFAULT = 10000;
    public static final String MAX_RETRIES_CONFIG = "confluent.schema.registry.max.retries";
    public static final String MAX_RETRIES_DOC = "Maximum number of times to retry schema registry read operations.";
    public static final int MAX_RETRIES_DEFAULT = 1;
    public static final String RETRIES_WAIT_MS_CONFIG = "confluent.schema.registry.retries.wait.ms";
    public static final String RETRIES_WAIT_MS_DOC = "Time in milliseconds to wait before each retry.";
    public static final int RETRIES_WAIT_MS_DEFAULT = 0;
    public static final String MISSING_ID_QUERY_RANGE_CONFIG = "confluent.missing.id.query.range";
    public static final String MISSING_ID_QUERY_RANGE_DOC = "The range above max schema ID to make calls to Schema Registry";
    public static final int MISSING_ID_QUERY_RANGE_DEFAULT = 200;
    public static final String MISSING_ID_CACHE_TTL_CONFIG = "confluent.missing.id.cache.ttl.sec";
    public static final String MISSING_ID_CACHE_TTL_DOC = "The TTL in seconds for caching missing schema IDs";
    public static final long MISSING_ID_CACHE_TTL_DEFAULT = 60L;
    public static final String MISSING_SUBJECT_CACHE_TTL_CONFIG = "confluent.missing.schema.cache.ttl.sec";
    public static final String MISSING_SCHEMA_CACHE_TTL_DOC = "The TTL in seconds for caching missing schemas";
    public static final long MISSING_SCHEMA_CACHE_TTL_DEFAULT = 60L;
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE_CONFIG = "confluent.basic.auth.credentials.source";
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE_DOC = "Specify how to pick the credentials for Basic Auth header. The supported values are URL, USER_INFO and SASL_INHERIT";
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE_DEFAULT = ConfluentConfigs.BASIC_AUTH_CREDENTIALS_SOURCE_DEFAULT;
    public static final String USER_INFO_CONFIG = "confluent.basic.auth.user.info";
    public static final String USER_INFO_DOC = "Specify the user info for Basic Auth in the form of {username}:{password}";
    public static final String USER_INFO_DEFAULT = ConfluentConfigs.USER_INFO_DEFAULT;
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE_CONFIG = "confluent.bearer.auth.credentials.source";
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE_DOC = "Specify how to pick the credentials for Bearer Auth header. ";
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE_DEFAULT = ConfluentConfigs.BEARER_AUTH_CREDENTIALS_SOURCE_DEFAULT;
    public static final String BEARER_AUTH_TOKEN_CONFIG = "confluent.bearer.auth.token";
    public static final String BEARER_AUTH_TOKEN_DOC = "Specify the Bearer token to be used for authentication";
    public static final String BEARER_AUTH_TOKEN_DEFAULT = ConfluentConfigs.BEARER_AUTH_TOKEN_DEFAULT;
    public static final String BEARER_AUTH_ISSUER_ENDPOINT_URL = "confluent.bearer.auth.issuer.endpoint.url";
    public static final String BEARER_AUTH_ISSUER_ENDPOINT_URL_DOC = "The HTTP(S)-based URL for the OAuth/OIDC identity provider which issues access token";
    public static final String BEARER_AUTH_CLIENT_ID = "confluent.bearer.auth.client.id";
    public static final String BEARER_AUTH_CLIENT_ID_DOC = "Client Id used to obtain Client Credentials Grant from OAuth/OIDC identity provider <a href=\"rfc-editor.org/rfc/rfc6749.html#section-4.4\"> ";
    public static final String BEARER_AUTH_CLIENT_SECRET = "confluent.bearer.auth.client.secret";
    public static final String BEARER_AUTH_CLIENT_SECRET_DOC = "Client secret used to obtain Client Credentials Grant from OAuth/OIDC identity provider <a href=\"rfc-editor.org/rfc/rfc6749.html#section-4.4\"> ";
    public static final String BEARER_AUTH_SCOPE = "confluent.bearer.auth.scope";
    public static final String BEARER_AUTH_SCOPE_DOC = "Access Token Scope used to obtain Client Credentials Grant OAuth/OIDC identity provider <a href=\"rfc-editor.org/rfc/rfc6749.html#section-3.3\"> ";
    public static final String BEARER_AUTH_SCOPE_CLAIM_NAME = "confluent.bearer.auth.scope.claim.name";
    public static final String BEARER_AUTH_SCOPE_CLAIM_NAME_DOC = "The OAuth claim for the scope is often named \"scope\", but this (optional) setting can provide a different name to use for the scope included in the JWT payload's claims if the OAuth/OIDC provider uses a different name for that claim.";
    public static final String DEFAULT_BEARER_AUTH_SCOPE_CLAIM_NAME = "scope";
    public static final String BEARER_AUTH_SUB_CLAIM_NAME = "confluent.bearer.auth.sub.claim.name";
    public static final String BEARER_AUTH_SUB_CLAIM_NAME_DOC = "The OAuth claim for the subject is often named \"sub\", but this (optional) setting can provide a different name to use for the subject included in the JWT payload's claims if the OAuth/OIDC provider uses a different name for that claim.";
    public static final String DEFAULT_BEARER_AUTH_SUB_CLAIM_NAME = "sub";
    public static final String BEARER_AUTH_LOGICAL_CLUSTER = "confluent.bearer.auth.logical.cluster";
    public static final String BEARER_AUTH_LOGICAL_CLUSTER_DOC = "Additional property which can added in Request header to Schema Registry";
    public static final String BEARER_AUTH_IDENTITY_POOL_ID = "confluent.bearer.auth.identity.pool.id";
    public static final String BEARER_AUTH_IDENTITY_POOL_ID_DOC = "Additional property which can added in Request header to Schema Registry. This maybe used as Principal Id for Authorization";
    public static final String BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS = "confluent.bearer.auth.cache.expiry.buffer.seconds";
    public static final Short BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS_DEFAULT = ConfluentConfigs.BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS_DEFAULT;
    public static final String BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS_DOC = "The amount of buffer time between expiration times of the OAuth Token and corresponding cache which hold the token. Ideally we would want to get a new token before the current one expires. Legal values are between 0 and 3600 (1 hour); a default value of  300 (5 minutes) is used if no value is specified. This value is ignored if it exceeds the remaining lifetime of a token from the moment it is retrieved into schema registry.";
    public static final String SSL_PROTOCOL_CONFIG = "confluent.ssl.protocol";
    public static final String SSL_PROTOCOL_DOC = "The SSL protocol used to generate the SSLContext. Default setting is TLSv1.2, which is fine for most cases. Allowed values in recent JVMs are TLSv1.2 and TLSv1.3. TLS, TLSv1.1, SSL, SSLv2 and SSLv3 may be supported in older JVMs, but their usage is discouraged due to known security vulnerabilities.";
    public static final String SSL_KEYSTORE_LOCATION_CONFIG = "confluent.ssl.keystore.location";
    public static final String SSL_KEYSTORE_LOCATION_DOC = "The location of the key store file. This is optional for client and can be used for two-way authentication for client.";
    public static final String SSL_KEYSTORE_TYPE_CONFIG = "confluent.ssl.keystore.type";
    public static final String SSL_KEYSTORE_TYPE_DOC = "The file format of the key store file. This is optional for client.";
    public static final String SSL_KEYSTORE_PASSWORD_CONFIG = "confluent.ssl.keystore.password";
    public static final String SSL_KEYSTORE_PASSWORD_DOC = "The store password for the key store file. This is optional for client and only needed if ssl.keystore.location is configured. ";
    public static final String SSL_KEY_PASSWORD_CONFIG = "confluent.ssl.key.password";
    public static final String SSL_KEY_PASSWORD_DOC = "The password of the private key in the key store file. This is optional for client.";
    public static final String SSL_TRUSTSTORE_TYPE_CONFIG = "confluent.ssl.truststore.type";
    public static final String SSL_TRUSTSTORE_TYPE_DOC = "The file format of the trust store file.";
    public static final String SSL_TRUSTSTORE_LOCATION_CONFIG = "confluent.ssl.truststore.location";
    public static final String SSL_TRUSTSTORE_LOCATION_DOC = "The location of the trust store file. ";
    public static final String SSL_TRUSTSTORE_PASSWORD_CONFIG = "confluent.ssl.truststore.password";
    public static final String SSL_TRUSTSTORE_PASSWORD_DOC = "The password for the trust store file. If a password is not set access to the truststore is still available, but integrity checking is disabled.";
    public static final String SAMPLES_PER_MIN_CONFIG = "confluent.schema.validator.samples.per.min";
    public static final String SAMPLES_PER_MIN_DOC = "Number of error samples that will be printed per minute during schema validation";

    public static ConfigDef baseRecordSchemaValidatorConfigDef() {
        ConfigDef configDef = new ConfigDef().define(SCHEMA_REGISTRY_URL_CONFIG, ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.HIGH, SCHEMA_REGISTRY_URL_DOC).define(KEY_SCHEMA_VALIDATION_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, KEY_SCHEMA_VALIDATION_DOC).define(VALUE_SCHEMA_VALIDATION_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, VALUE_SCHEMA_VALIDATION_DOC).define(KEY_SUBJECT_NAME_STRATEGY_CONFIG, ConfigDef.Type.CLASS, (Object)KEY_SUBJECT_NAME_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, KEY_SUBJECT_NAME_STRATEGY_DOC).define(VALUE_SUBJECT_NAME_STRATEGY_CONFIG, ConfigDef.Type.CLASS, (Object)VALUE_SUBJECT_NAME_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, VALUE_SUBJECT_NAME_STRATEGY_DOC).define(MAX_CACHE_SIZE_CONFIG, ConfigDef.Type.INT, (Object)10000, ConfigDef.Importance.MEDIUM, MAX_CACHE_SIZE_DOC).define(MAX_RETRIES_CONFIG, ConfigDef.Type.INT, (Object)1, ConfigDef.Importance.LOW, MAX_RETRIES_DOC).define(RETRIES_WAIT_MS_CONFIG, ConfigDef.Type.INT, (Object)0, ConfigDef.Importance.LOW, RETRIES_WAIT_MS_DOC).define(MISSING_ID_QUERY_RANGE_CONFIG, ConfigDef.Type.INT, (Object)200, ConfigDef.Importance.LOW, MISSING_ID_QUERY_RANGE_DOC).define(MISSING_ID_CACHE_TTL_CONFIG, ConfigDef.Type.LONG, (Object)60L, ConfigDef.Importance.LOW, MISSING_ID_CACHE_TTL_DOC).define(MISSING_SUBJECT_CACHE_TTL_CONFIG, ConfigDef.Type.LONG, (Object)60L, ConfigDef.Importance.LOW, MISSING_SCHEMA_CACHE_TTL_DOC).define(BASIC_AUTH_CREDENTIALS_SOURCE_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, BASIC_AUTH_CREDENTIALS_SOURCE_DOC).define(USER_INFO_CONFIG, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.LOW, USER_INFO_DOC).define(BEARER_AUTH_CREDENTIALS_SOURCE_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, BEARER_AUTH_CREDENTIALS_SOURCE_DOC).define(BEARER_AUTH_TOKEN_CONFIG, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.LOW, BEARER_AUTH_TOKEN_DOC).define(BEARER_AUTH_ISSUER_ENDPOINT_URL, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, BEARER_AUTH_ISSUER_ENDPOINT_URL_DOC).define(BEARER_AUTH_CLIENT_ID, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, BEARER_AUTH_CLIENT_ID_DOC).define(BEARER_AUTH_CLIENT_SECRET, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, BEARER_AUTH_CLIENT_SECRET_DOC).define(BEARER_AUTH_SCOPE, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, BEARER_AUTH_SCOPE_DOC).define(BEARER_AUTH_SCOPE_CLAIM_NAME, ConfigDef.Type.STRING, (Object)DEFAULT_BEARER_AUTH_SCOPE_CLAIM_NAME, ConfigDef.Importance.LOW, BEARER_AUTH_SCOPE_CLAIM_NAME_DOC).define(BEARER_AUTH_SUB_CLAIM_NAME, ConfigDef.Type.STRING, (Object)DEFAULT_BEARER_AUTH_SUB_CLAIM_NAME, ConfigDef.Importance.LOW, BEARER_AUTH_SUB_CLAIM_NAME_DOC).define(BEARER_AUTH_IDENTITY_POOL_ID, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, BEARER_AUTH_IDENTITY_POOL_ID_DOC).define(BEARER_AUTH_LOGICAL_CLUSTER, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, BEARER_AUTH_LOGICAL_CLUSTER_DOC).define(BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS, ConfigDef.Type.SHORT, (Object)BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS_DEFAULT, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)3600), ConfigDef.Importance.LOW, BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS_DOC).define(SAMPLES_PER_MIN_CONFIG, ConfigDef.Type.LONG, (Object)0, ConfigDef.Importance.LOW, SAMPLES_PER_MIN_DOC);
        return configDef;
    }

    public RecordSchemaValidatorConfig(Map<?, ?> props) {
        super(RecordSchemaValidatorConfig.baseRecordSchemaValidatorConfigDef(), props);
    }

    public long getSamplesPerMin() {
        return this.getLong(SAMPLES_PER_MIN_CONFIG);
    }

    public RecordSchemaValidatorConfig(ConfigDef configDef, Map<?, ?> props) {
        super(configDef, props);
    }

    public List<String> getSchemaRegistryUrls() {
        return this.getList(SCHEMA_REGISTRY_URL_CONFIG);
    }

    public SubjectNameStrategy keySubjectNameStrategy() {
        return (SubjectNameStrategy)this.getConfiguredInstance(KEY_SUBJECT_NAME_STRATEGY_CONFIG, SubjectNameStrategy.class);
    }

    public SubjectNameStrategy valueSubjectNameStrategy() {
        return (SubjectNameStrategy)this.getConfiguredInstance(VALUE_SUBJECT_NAME_STRATEGY_CONFIG, SubjectNameStrategy.class);
    }

    public boolean validateKey() {
        return this.getBoolean(KEY_SCHEMA_VALIDATION_CONFIG);
    }

    public boolean validateValue() {
        return this.getBoolean(VALUE_SCHEMA_VALIDATION_CONFIG);
    }

    public int getMaxCacheSize() {
        return this.getInt(MAX_CACHE_SIZE_CONFIG);
    }

    public int getMaxRetries() {
        return this.getInt(MAX_RETRIES_CONFIG);
    }

    public int getRetriesWaitMs() {
        return this.getInt(RETRIES_WAIT_MS_CONFIG);
    }

    public int getMaxIdQueryRange() {
        return this.getInt(MISSING_ID_QUERY_RANGE_CONFIG);
    }

    public long getBadIdCacheTtl() {
        return this.getLong(MISSING_ID_CACHE_TTL_CONFIG);
    }

    public long getBadSchemaCacheTtl() {
        return this.getLong(MISSING_SUBJECT_CACHE_TTL_CONFIG);
    }
}

