/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.confluent.kafka.link.ClusterLinkConfig;
import io.confluent.protobuf.events.catalog.v1.MetadataChange;
import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import io.confluent.protobuf.events.catalog.v1.MirrorTopicMetadata;
import io.confluent.telemetry.api.events.Event;
import io.confluent.telemetry.api.events.EventEmitter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import kafka.catalog.CatalogMetrics;
import kafka.catalog.KRaftMetadataEventProvider;
import kafka.catalog.MetadataEventUtils;
import kafka.common.TenantHelpers;
import kafka.server.KafkaConfig;
import kafka.server.link.ConnectionMode;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.PartitionReassignmentReplicas;
import org.apache.kafka.image.ClusterLinksDelta;
import org.apache.kafka.image.ConfigurationsDelta;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.ClusterLink;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.immutable.ImmutableMap;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.slf4j.Logger;

public class KRaftMetadataCollector
implements MetadataPublisher {
    private final Logger log;
    private final boolean fullConfigsEnable;
    private final int snapshotInitDelaySec;
    private final int snapshotIntervalSec;
    private final int maxBytesInSnapshot;
    private final String destTopic;
    private final String clusterId;
    private final int nodeId;
    private final KafkaConfig kafkaConfig;
    private final AtomicReference<MetadataImage> latestImage;
    private final AtomicBoolean isActive;
    private final AtomicInteger epoch;
    private final Time time;
    private final Metrics metrics;
    private final MetricName activeCollectorMetricName;
    private final AtomicReference<CatalogMetrics> catalogMetrics;
    private final AtomicReference<Scheduler> snapshotScheduler;

    public KRaftMetadataCollector(Metrics metrics, boolean fullConfigsEnable, int snapshotInitDelaySec, int snapshotIntervalSec, int maxBytesInSnapshot, String destTopic, int nodeId, KafkaConfig kafkaConfig, Time time, String clusterId) {
        this.metrics = metrics;
        this.fullConfigsEnable = fullConfigsEnable;
        this.snapshotInitDelaySec = snapshotInitDelaySec;
        this.snapshotIntervalSec = snapshotIntervalSec;
        this.maxBytesInSnapshot = maxBytesInSnapshot;
        this.destTopic = destTopic;
        this.nodeId = nodeId;
        this.clusterId = clusterId;
        this.kafkaConfig = kafkaConfig;
        this.latestImage = new AtomicReference<Object>(null);
        this.isActive = new AtomicBoolean(false);
        this.epoch = new AtomicInteger(-1);
        this.time = time;
        this.catalogMetrics = new AtomicReference<Object>(null);
        this.snapshotScheduler = new AtomicReference<Object>(null);
        this.activeCollectorMetricName = metrics.metricName("active-collector", "catalog-metrics", "Reports 1 if the catalog metadata collector is active, 0 otherwise.");
        this.registerMetric();
        this.log = new LogContext("[KRaftTopicMedataCollector id=" + nodeId + "]").logger(this.getClass());
        this.log.info("Constructed, snapshot init delay {}s, interval {}s", (Object)snapshotInitDelaySec, (Object)snapshotIntervalSec);
    }

    private Scheduler registerSnapshotTask(int snapshotInitDelaySec, int snapshotIntervalSec) {
        KafkaScheduler scheduler = new KafkaScheduler(1, true, "catalog-metadata-snapshot-", false);
        scheduler.startup();
        scheduler.schedule("MetadataSnapshotEmitter", this.emitMetadataSnapshot(), TimeUnit.SECONDS.toMillis(snapshotInitDelaySec), TimeUnit.SECONDS.toMillis(snapshotIntervalSec));
        return scheduler;
    }

    public String name() {
        return "KRaftMetadataCollector";
    }

    private void deregisterSnapshotTask(Scheduler scheduler) throws InterruptedException {
        if (scheduler == null) {
            return;
        }
        scheduler.shutdown();
    }

    public void start() {
        if (this.snapshotScheduler.get() != null) {
            throw new IllegalStateException("Cannot start a topic metadata collector multiple times");
        }
        this.snapshotScheduler.set(this.registerSnapshotTask(this.snapshotInitDelaySec, this.snapshotIntervalSec));
    }

    public void stop() throws InterruptedException {
        this.deregisterSnapshotTask(this.snapshotScheduler.get());
        this.removeMetric();
    }

    public boolean isActive() {
        return this.isActive.get();
    }

    EventEmitter eventEmitter() {
        return this.metrics.eventEmitter();
    }

    CatalogMetrics catalogMetrics() {
        return this.catalogMetrics.get();
    }

    public void onControllerChange(LeaderAndEpoch leader) {
        try {
            this.epoch.set(leader.epoch());
            if (leader.leaderId().equals(OptionalInt.of(this.nodeId))) {
                CatalogMetrics oldCatalogMetrics = this.catalogMetrics.getAndSet(null);
                if (oldCatalogMetrics != null) {
                    oldCatalogMetrics.removeCatalogMetrics();
                }
                this.catalogMetrics.set(new CatalogMetrics(this.metrics, () -> 0));
                this.isActive.set(true);
                this.log.info("MetadataCollector is active");
            } else if (this.isActive.compareAndSet(true, false)) {
                CatalogMetrics oldCatalogMetrics = this.catalogMetrics.getAndSet(null);
                if (oldCatalogMetrics != null) {
                    oldCatalogMetrics.removeCatalogMetrics();
                }
                this.log.info("MetadataCollector is no longer active");
            }
        }
        catch (Exception e) {
            this.log.error("Encountered exception when reacting to leadership change", (Throwable)e);
            this.logEventHandleError();
        }
    }

    public void onMetadataUpdate(MetadataDelta metadataDelta, MetadataImage newMetadataImage, LoaderManifest loaderManifest) {
        try {
            this.latestImage.set(newMetadataImage);
            if (this.isActive.get()) {
                this.processDeletedTopics(metadataDelta);
                this.processChangedTopics(metadataDelta, newMetadataImage);
                this.processClusterLinksDeletion(metadataDelta, newMetadataImage);
                this.processClusterLinksUpdate(metadataDelta, newMetadataImage);
            }
        }
        catch (Exception e) {
            this.log.error("Encountered exception when processing metadata image updates", (Throwable)e);
            this.logEventHandleError();
        }
    }

    public Runnable emitMetadataSnapshot() {
        return () -> {
            try {
                if (!this.isActive.get()) {
                    return;
                }
                MetadataImage curImage = this.latestImage.get();
                if (curImage != null && !curImage.isEmpty()) {
                    HashMap topicsByTenant = new HashMap();
                    HashMap clusterLinksByTenant = new HashMap();
                    HashSet tenants = new HashSet();
                    curImage.topics().topicsByName().forEach((topicName, topicImage) -> {
                        String tenant = TenantHelpers.extractTenantPrefix(topicName, false);
                        if (tenant == null || tenant.isEmpty()) {
                            return;
                        }
                        topicsByTenant.computeIfAbsent(tenant, t -> new TreeSet()).add(topicImage.id());
                        tenants.add(tenant);
                    });
                    curImage.clusterLinks().linksByName().forEach((linkName, linkImage) -> {
                        String tenant = TenantHelpers.extractTenantPrefix(linkName, false);
                        if (tenant == null || tenant.isEmpty()) {
                            return;
                        }
                        clusterLinksByTenant.computeIfAbsent(tenant, t -> new TreeSet()).add(linkImage.linkId());
                        tenants.add(tenant);
                    });
                    tenants.forEach(tenant -> this.sendSnapshot((String)tenant, topicsByTenant.getOrDefault(tenant, new TreeSet()), clusterLinksByTenant.getOrDefault(tenant, new TreeSet()), curImage));
                }
            }
            catch (Exception e) {
                this.log.error("Encountered exception when emitting snapshot events", (Throwable)e);
                this.logEventHandleError();
            }
        };
    }

    private void sendSnapshot(String tenant, Set<Uuid> topics, Set<Uuid> linkIds, MetadataImage metadataImage) {
        KRaftMetadataEventProvider provider = new KRaftMetadataEventProvider(this, topics, linkIds, metadataImage);
        MetadataEventUtils.buildAndEmitSnapshot(tenant, provider, this.maxBytesInSnapshot, this.epoch.get(), this.destTopic, this.eventEmitter(), this.catalogMetrics.get(), this.log);
    }

    private void processDeletedTopics(MetadataDelta metadataDelta) {
        TopicsDelta topicsDelta = metadataDelta.topicsDelta();
        if (topicsDelta == null) {
            return;
        }
        for (Uuid topicId : topicsDelta.deletedTopicIds()) {
            String topicName = topicsDelta.image().getTopic(topicId).name();
            String tenant = TenantHelpers.extractTenantPrefix(topicName, false);
            if (tenant == null || tenant.isEmpty()) continue;
            Timestamp now = Timestamps.fromMillis((long)this.time.milliseconds());
            MetadataEvent topicMetadataEvent = MetadataEventUtils.topicMetadataEventForDeletion(TenantHelpers.extractLogicalName(topicName), Optional.of(topicId.toString()), now);
            MetadataChange topicDeleteChange = MetadataEventUtils.entityDeleteEvent(tenant, topicMetadataEvent);
            Event toEmit = MetadataEventUtils.topicMetadataDeltaCloudEvent(topicDeleteChange, this.epoch.get(), this.destTopic);
            MetadataEventUtils.emitAndLogError(this.metrics.eventEmitter(), toEmit, this.catalogMetrics.get(), this.log);
        }
    }

    private void processChangedTopics(MetadataDelta metadataDelta, MetadataImage newMetadataImage) {
        Event toEmit;
        MetadataChange change;
        TopicsDelta topicsDelta = metadataDelta.topicsDelta();
        HashSet<Uuid> updatedIds = new HashSet<Uuid>();
        if (topicsDelta != null) {
            for (Uuid topicId : topicsDelta.changedTopics().keySet()) {
                TopicDelta topicDelta = (TopicDelta)topicsDelta.changedTopics().get(topicId);
                MirrorTopic updatedMirrorTopic = topicDelta.latestMirrorTopicState().orElse(null);
                if (topicsDelta.image().getTopic(topicId) == null) {
                    TopicImage topicImage = newMetadataImage.topics().getTopic(topicId);
                    String tenant = TenantHelpers.extractTenantPrefix(topicImage.name(), false);
                    if (tenant == null || tenant.isEmpty()) continue;
                    MetadataEvent metadataEvent = this.getMetadataUpdateEventFromTopicImage(newMetadataImage, topicImage, true, false, updatedMirrorTopic);
                    change = MetadataEventUtils.entityCreateEvent(tenant, metadataEvent);
                    toEmit = MetadataEventUtils.topicMetadataDeltaCloudEvent(change, this.epoch.get(), this.destTopic);
                    MetadataEventUtils.emitAndLogError(this.metrics.eventEmitter(), toEmit, this.catalogMetrics.get(), this.log);
                    continue;
                }
                updatedIds.add(topicId);
            }
        }
        if (metadataDelta.configsDelta() != null) {
            metadataDelta.configsDelta().changes().keySet().stream().filter(c -> c.type().equals((Object)ConfigResource.Type.TOPIC)).filter(c -> metadataDelta.image().topics().getTopic(c.name()) != null).map(c -> newMetadataImage.topics().getTopic(c.name())).filter(Objects::nonNull).forEach(image -> updatedIds.add(image.id()));
        }
        for (Uuid topicId : updatedIds) {
            TopicImage topicImage = newMetadataImage.topics().getTopic(topicId);
            String tenant = TenantHelpers.extractTenantPrefix(topicImage.name(), false);
            if (tenant == null || tenant.isEmpty()) continue;
            TopicImage oldTopicImage = metadataDelta.image().topics().getTopic(topicId);
            MetadataEvent metadataEvent = this.getMetadataUpdateEventFromTopicImage(newMetadataImage, topicImage, true, true, topicImage.mirrorTopic().orElse(null));
            MetadataEvent oldMetadataEvent = this.getMetadataUpdateEventFromTopicImage(metadataDelta.image(), oldTopicImage, true, true, oldTopicImage.mirrorTopic().orElse(null));
            if (!MetadataEventUtils.eventHasChanged(oldMetadataEvent, metadataEvent)) continue;
            change = MetadataEventUtils.entityUpdateEvent(tenant, metadataEvent);
            toEmit = MetadataEventUtils.topicMetadataDeltaCloudEvent(change, this.epoch.get(), this.destTopic);
            MetadataEventUtils.emitAndLogError(this.metrics.eventEmitter(), toEmit, this.catalogMetrics.get(), this.log);
        }
    }

    private void processClusterLinksDeletion(MetadataDelta metadataDelta, MetadataImage newMetadataImage) {
        ClusterLinksDelta clusterLinksDelta = metadataDelta.clusterLinksDelta();
        if (clusterLinksDelta == null) {
            return;
        }
        Set deletedClusterLinks = clusterLinksDelta.deletedClusterLinks();
        Map clusterLinksById = metadataDelta.image().clusterLinks().linksById();
        for (Uuid clusterLinkId : deletedClusterLinks) {
            ClusterLink clusterLink = (ClusterLink)clusterLinksById.get(clusterLinkId);
            String clusterLinkName = clusterLink.linkName();
            String tenant = TenantHelpers.extractTenantPrefix(clusterLinkName, false);
            if (tenant == null || tenant.isEmpty()) continue;
            Timestamp now = Timestamps.fromMillis((long)this.time.milliseconds());
            MetadataEvent clusterLinkMetadataDeletionEvent = MetadataEventUtils.clusterLinkMetadataEventForDeletion(TenantHelpers.extractLogicalName(clusterLinkName), Optional.of(clusterLinkId.toString()), now);
            MetadataChange change = MetadataEventUtils.entityDeleteEvent(tenant, clusterLinkMetadataDeletionEvent);
            Event toEmit = MetadataEventUtils.clusterLinkMetadataDeltaCloudEvent(change, this.epoch.get(), this.destTopic);
            MetadataEventUtils.emitAndLogError(this.metrics.eventEmitter(), toEmit, this.catalogMetrics.get(), this.log);
            ImmutableMap topicImages = metadataDelta.image().topics().topicsByLinkId(clusterLinkId);
            for (TopicImage topicImage : topicImages.values()) {
                MetadataEvent metadataEvent = this.getMetadataUpdateEventFromTopicImage(newMetadataImage, topicImage, true, true, null);
                MetadataChange resetMirrorTopicMetadataEvent = MetadataEventUtils.entityUpdateEvent(tenant, metadataEvent);
                Event toEmitMirrorTopicReset = MetadataEventUtils.topicMetadataDeltaCloudEvent(resetMirrorTopicMetadataEvent, this.epoch.get(), this.destTopic);
                MetadataEventUtils.emitAndLogError(this.metrics.eventEmitter(), toEmitMirrorTopicReset, this.catalogMetrics.get(), this.log);
            }
        }
    }

    private void processClusterLinksUpdate(MetadataDelta metadataDelta, MetadataImage newMetadataImage) {
        ClusterLinksDelta clusterLinksDelta = metadataDelta.clusterLinksDelta();
        ConfigurationsDelta configurationsDelta = metadataDelta.configsDelta();
        if (clusterLinksDelta == null && configurationsDelta == null) {
            return;
        }
        Map clusterLinksById = newMetadataImage.clusterLinks().linksById();
        if (clusterLinksDelta != null) {
            for (Uuid addedClusterLinkId : clusterLinksDelta.addedClusterLinks().keySet()) {
                ClusterLink clusterLink = (ClusterLink)clusterLinksById.get(addedClusterLinkId);
                String clusterLinkName = clusterLink.linkName();
                String tenant = TenantHelpers.extractTenantPrefix(clusterLinkName, false);
                if (tenant == null || tenant.isEmpty()) continue;
                MetadataEvent clusterLinkMetadataCreationEvent = this.getMetadataUpdateEventFromClusterLinkImage(newMetadataImage, clusterLink, true, false);
                MetadataChange change = MetadataEventUtils.entityCreateEvent(tenant, clusterLinkMetadataCreationEvent);
                Event toEmit = MetadataEventUtils.clusterLinkMetadataDeltaCloudEvent(change, this.epoch.get(), this.destTopic);
                MetadataEventUtils.emitAndLogError(this.metrics.eventEmitter(), toEmit, this.catalogMetrics.get(), this.log);
            }
        }
        if (configurationsDelta != null && metadataDelta.image().clusterLinks() != null) {
            Set configResources = configurationsDelta.changes().keySet();
            for (Uuid linkId : clusterLinksById.keySet()) {
                ClusterLink clusterLink;
                String clusterLinkName;
                String tenant;
                if (!configResources.contains(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkId.toString())) || (tenant = TenantHelpers.extractTenantPrefix(clusterLinkName = (clusterLink = (ClusterLink)clusterLinksById.get(linkId)).linkName(), false)) == null || tenant.isEmpty()) continue;
                MetadataEvent clusterLinkMetadataUpdateEvent = this.getMetadataUpdateEventFromClusterLinkImage(newMetadataImage, clusterLink, true, true);
                MetadataChange change = MetadataEventUtils.entityUpdateEvent(tenant, clusterLinkMetadataUpdateEvent);
                Event toEmit = MetadataEventUtils.clusterLinkMetadataDeltaCloudEvent(change, this.epoch.get(), this.destTopic);
                MetadataEventUtils.emitAndLogError(this.metrics.eventEmitter(), toEmit, this.catalogMetrics.get(), this.log);
            }
        }
    }

    private LogConfig extractLogConfigFromImage(MetadataImage metadataImage, String topicName) {
        Properties topicOverrides = metadataImage.configs().configProperties(new ConfigResource(ConfigResource.Type.TOPIC, topicName));
        return LogConfig.fromProps(this.kafkaConfig.extractLogConfigMap(), (Properties)topicOverrides);
    }

    public MetadataEvent getMetadataUpdateEventFromTopicImage(MetadataImage metadataImage, TopicImage topicImage, boolean isDelta, boolean isUpdate, @Nullable MirrorTopic mirrorInfo) {
        LogConfig topicProperties = this.extractLogConfigFromImage(metadataImage, topicImage.name());
        MirrorTopicMetadata mirrorTopicMetadata = null;
        if (mirrorInfo != null) {
            String linkName = mirrorInfo.linkName();
            String remoteClusterId = metadataImage.clusterLinks().clusterLink(linkName).map(ClusterLink::remoteClusterId).orElse("");
            mirrorTopicMetadata = MetadataEventUtils.mirrorTopicMetadata(mirrorInfo.linkId(), linkName, mirrorInfo.sourceTopicId(), mirrorInfo.sourceTopicName(), mirrorInfo.mirrorState().name(), remoteClusterId, Timestamps.fromMillis((long)mirrorInfo.timeMs()));
        }
        Timestamp now = Timestamps.fromMillis((long)this.time.milliseconds());
        Timestamp createTime = isDelta && !isUpdate ? now : null;
        Timestamp updateTime = isDelta && isUpdate ? now : null;
        PartitionRegistration partitionRegistration = (PartitionRegistration)topicImage.partitions().values().iterator().next();
        return MetadataEventUtils.topicMetadataEventFromLogConfig(topicProperties, TenantHelpers.extractLogicalName(topicImage.name()), topicImage.id(), topicImage.partitions().size(), PartitionReassignmentReplicas.targetReplicas((PartitionRegistration)partitionRegistration).size(), mirrorTopicMetadata, this.fullConfigsEnable, updateTime, createTime);
    }

    public MetadataEvent getMetadataUpdateEventFromClusterLinkImage(MetadataImage metadataImage, ClusterLink clusterLinkImage, boolean isDelta, boolean isUpdate) {
        ConfigurationsImage newConfigurationsImage = metadataImage.configs();
        Timestamp now = Timestamps.fromMillis((long)this.time.milliseconds());
        Timestamp createTime = isDelta && !isUpdate ? now : null;
        Timestamp updateTime = isDelta && isUpdate ? now : null;
        String clusterLinkName = clusterLinkImage.linkName();
        Uuid clusterLinkId = clusterLinkImage.linkId();
        String remoteClusterId = clusterLinkImage.remoteClusterId();
        String destinationClusterId = this.clusterId;
        ClusterLinkConfig.LinkMode linkMode = clusterLinkImage.linkMode();
        ConnectionMode connectionMode = MetadataEventUtils.getOrDefaultClusterLinkConnectionMode(newConfigurationsImage, linkMode, clusterLinkId.toString(), this.log);
        return MetadataEventUtils.clusterLinkMetadataEvent(TenantHelpers.extractLogicalName(clusterLinkName), clusterLinkId, linkMode, connectionMode, remoteClusterId, destinationClusterId, createTime, updateTime);
    }

    private void registerMetric() {
        this.metrics.addMetric(this.activeCollectorMetricName, (config, now) -> this.isActive() ? 1.0 : 0.0);
    }

    private void removeMetric() {
        this.metrics.removeMetric(this.activeCollectorMetricName);
    }

    private void logEventHandleError() {
        if (this.catalogMetrics.get() != null) {
            this.catalogMetrics.get().collectorEventHandleErrorSensor.record();
        }
    }
}

