/*
 * Decompiled with CFR 0.152.
 */
package kafka.migration;

import java.util.Map;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.api.PartitionLinkState;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.zk.ConfluentAssignmentMigration$;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.PartitionRegistration;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;

public final class MigrationControllerChannelContext$ {
    public static final MigrationControllerChannelContext$ MODULE$ = new MigrationControllerChannelContext$();

    public boolean isReplicaOnline(MetadataImage image, int brokerId, Set<Object> replicaAssignment) {
        return image.cluster().containsBroker(brokerId) && replicaAssignment.contains((Object)BoxesRunTime.boxToInteger((int)brokerId));
    }

    public Seq<Object> partitionReplicaAssignment(MetadataImage image, TopicPartition tp) {
        Option option = CollectionConverters$.MODULE$.MapHasAsScala((Map)image.topics().topicsByName()).asScala().get((Object)tp.topic());
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            Option option2 = CollectionConverters$.MODULE$.MapHasAsScala(topic.partitions()).asScala().get((Object)Predef$.MODULE$.int2Integer(tp.partition()));
            if (option2 instanceof Some) {
                PartitionRegistration partition = (PartitionRegistration)((Some)option2).value();
                return ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps(partition.replicas));
            }
            if (None$.MODULE$.equals(option2)) {
                return (Seq)Seq$.MODULE$.empty();
            }
            throw new MatchError((Object)option2);
        }
        if (None$.MODULE$.equals(option)) {
            return (Seq)Seq$.MODULE$.empty();
        }
        throw new MatchError((Object)option);
    }

    public Seq<Object> partitionEffectiveObserverAssignment(MetadataImage image, TopicPartition tp) {
        Option option = CollectionConverters$.MODULE$.MapHasAsScala((Map)image.topics().topicsByName()).asScala().get((Object)tp.topic());
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            Option option2 = CollectionConverters$.MODULE$.MapHasAsScala(topic.partitions()).asScala().get((Object)Predef$.MODULE$.int2Integer(tp.partition()));
            if (option2 instanceof Some) {
                PartitionRegistration partition = (PartitionRegistration)((Some)option2).value();
                return ConfluentAssignmentMigration$.MODULE$.fromKRaftToZkAssignment(partition).effectiveObservers();
            }
            if (None$.MODULE$.equals(option2)) {
                return (Seq)Seq$.MODULE$.empty();
            }
            throw new MatchError((Object)option2);
        }
        if (None$.MODULE$.equals(option)) {
            return (Seq)Seq$.MODULE$.empty();
        }
        throw new MatchError((Object)option);
    }

    public Option<LeaderIsrAndControllerEpoch> partitionLeadershipInfo(MetadataImage image, TopicPartition topicPartition) {
        Option option = CollectionConverters$.MODULE$.MapHasAsScala((Map)image.topics().topicsByName()).asScala().get((Object)topicPartition.topic());
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            Option option2 = CollectionConverters$.MODULE$.MapHasAsScala(topic.partitions()).asScala().get((Object)Predef$.MODULE$.int2Integer(topicPartition.partition()));
            if (option2 instanceof Some) {
                None$ none$;
                PartitionRegistration partition = (PartitionRegistration)((Some)option2).value();
                PartitionRegistration.LinkState linkState = partition.linkState;
                PartitionRegistration.LinkState linkState2 = PartitionRegistration.LinkState.NOT_MIRROR;
                if (!(linkState != null ? !linkState.equals(linkState2) : linkState2 != null)) {
                    none$ = None$.MODULE$;
                } else {
                    PartitionRegistration.LinkState linkState3 = partition.linkState;
                    PartitionRegistration.LinkState linkState4 = PartitionRegistration.LinkState.FAILED;
                    boolean bl = !(linkState3 != null ? !linkState3.equals(linkState4) : linkState4 != null);
                    none$ = new Some((Object)new PartitionLinkState(partition.linkedLeaderEpoch, bl, MirrorTopicError.NOT_SET));
                }
                None$ clusterLinkState = none$;
                LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(partition.leader, partition.leaderEpoch, (List<Object>)Predef$.MODULE$.wrapIntArray(partition.isr).toList(), partition.leaderRecoveryState, partition.partitionEpoch, (Option<PartitionLinkState>)clusterLinkState);
                return new Some((Object)new LeaderIsrAndControllerEpoch(leaderAndIsr, image.highestOffsetAndEpoch().epoch()));
            }
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            throw new MatchError((Object)option2);
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    private MigrationControllerChannelContext$() {
    }
}

