/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.concurrent.DefaultEventExecutor;
import io.confluent.kafka.concurrent.EventExecutor;
import io.confluent.kafka.raft.CompositeRaftTracer;
import io.confluent.kafka.raft.RaftTracer;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import kafka.durability.audit.manager.KRaftDurabilityAuditor$;
import kafka.log.LocalLog$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaRaftManager$;
import kafka.raft.MetadataLogConfig$;
import kafka.raft.RaftManager;
import kafka.raft.TimingWheelExpirationService;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer;
import kafka.server.KafkaRaftServer$;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.server.MetaProperties;
import kafka.tier.raft.KRaftSnapshotManager;
import kafka.tier.raft.KRaftSnapshotMetrics;
import kafka.tier.store.TierObjectStore;
import kafka.utils.CoreUtils$;
import kafka.utils.FileLock;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.ExpirationService;
import org.apache.kafka.raft.FileBasedStateStore;
import org.apache.kafka.raft.KafkaNetworkChannel;
import org.apache.kafka.raft.KafkaRaftClient;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.NetworkChannel;
import org.apache.kafka.raft.QuorumStateStore;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.raft.RaftRequest;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.server.util.ShutdownableThread;
import org.apache.kafka.server.util.timer.SystemTimer;
import org.apache.kafka.server.util.timer.Timer;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rEv!B$I\u0011\u0003ie!B(I\u0011\u0003\u0001\u0006\"B,\u0002\t\u0003Af\u0001B-\u0002\u0001iC\u0001B\\\u0002\u0003\u0002\u0003\u0006Ia\u001c\u0005\u000b\u0003\u0003\u0019!\u0011!Q\u0001\n\u0005\r\u0001BCA\r\u0007\t\u0005\t\u0015!\u0003\u0002\u001c!1qk\u0001C\u0001\u0003OAq!a\u000f\u0004\t\u0003\ni\u0004C\u0004\u0002F\r!\t%a\u0012\t\u000f\u0005=3\u0001\"\u0011\u0002H!9\u0011\u0011K\u0001\u0005\n\u0005M\u0003bBA7\u0003\u0011%\u0011q\u000e\u0004\u0006\u001f\"\u0003\u00111\u0010\u0005\u000b\u0003\u0017k!Q1A\u0005\u0002\u00055\u0005BCAM\u001b\t\u0005\t\u0015!\u0003\u0002\u0010\"Q\u00111T\u0007\u0003\u0002\u0003\u0006I!!(\t\u0015\u0005\rVB!A!\u0002\u0013\t)\u000b\u0003\u0006\u000266\u0011\t\u0011)A\u0005\u0003oC!\"!1\u000e\u0005\u0003\u0005\u000b\u0011BAb\u0011)\tI-\u0004B\u0001B\u0003%\u00111\u001a\u0005\u000b\u0003+l!\u0011!Q\u0001\n\u0005]\u0007BCAq\u001b\t\u0005\t\u0015!\u0003\u0002d\"Q\u0011\u0011^\u0007\u0003\u0006\u0004%\t!a;\t\u0015\t5RB!A!\u0002\u0013\ti\u000f\u0003\u0006\u0002\u001a5\u0011\t\u0011)A\u0005\u00037A!Ba\f\u000e\u0005\u0003\u0005\u000b\u0011\u0002B\u0019\u0011\u00199V\u0002\"\u0001\u0003H!I!\u0011M\u0007C\u0002\u0013%!1\r\u0005\t\u0005cj\u0001\u0015!\u0003\u0003f!I!1O\u0007C\u0002\u0013\u0005!Q\u000f\u0005\t\u0005\u0007k\u0001\u0015!\u0003\u0003x!I!QQ\u0007C\u0002\u0013%!q\u0011\u0005\t\u0005\u001fk\u0001\u0015!\u0003\u0003\n\"I\u0011\u0011A\u0007C\u0002\u0013%!\u0011\u0013\u0005\t\u0005'k\u0001\u0015!\u0003\u0002\u0004!I!QS\u0007C\u0002\u0013%!q\u0013\u0005\t\u0005?k\u0001\u0015!\u0003\u0003\u001a\"I!\u0011U\u0007C\u0002\u0013%!1\u0015\u0005\t\u0005Wk\u0001\u0015!\u0003\u0003&\"I\u0011\u0011P\u0007C\u0002\u0013%!Q\u0016\u0005\t\u0005_k\u0001\u0015!\u0003\u0002V!I!\u0011W\u0007C\u0002\u0013%!1\u0017\u0005\t\u0005ok\u0001\u0015!\u0003\u00036\"I!\u0011X\u0007C\u0002\u0013\u0005#1\u0018\u0005\t\u0005\u0007l\u0001\u0015!\u0003\u0003>\"I!QY\u0007C\u0002\u0013%!q\u0019\u0005\t\u0005\u001fl\u0001\u0015!\u0003\u0003J\"I!\u0011[\u0007C\u0002\u0013%!1\u001b\u0005\t\u0005Cl\u0001\u0015!\u0003\u0003V\"I!1]\u0007C\u0002\u0013%!Q\u001d\u0005\t\u0005[l\u0001\u0015!\u0003\u0003h\"Aa.\u0004b\u0001\n\u0003\u0012y\u000f\u0003\u0005\u0003t6\u0001\u000b\u0011\u0002By\u0011%\u0011)0\u0004b\u0001\n\u0013\u00119\u0010\u0003\u0005\u0004\u00065\u0001\u000b\u0011\u0002B}\u0011%\u00199!\u0004a\u0001\n\u0013\u0019I\u0001C\u0005\u0004 5\u0001\r\u0011\"\u0003\u0004\"!A1qE\u0007!B\u0013\u0019Y\u0001C\u0004\u0004*5!\t!!\u0010\t\u000f\r-R\u0002\"\u0001\u0002>!91QF\u0007\u0005B\r=\u0002bBB\"\u001b\u0011\u00053Q\t\u0005\b\u0007gjA\u0011BB;\u0011\u001d\u0019\u0019)\u0004C\u0005\u0007\u000bCqaa\"\u000e\t\u0013\u0019I\tC\u0004\u0004\f6!Ia!$\t\u000f\r=U\u0002\"\u0003\u0004\u0012\"91\u0011T\u0007\u0005\n\rm\u0005bBBR\u001b\u0011\u00053Q\u0015\u0005\b\u0007[kA\u0011IBX\u0003AY\u0015MZ6b%\u00064G/T1oC\u001e,'O\u0003\u0002J\u0015\u0006!!/\u00194u\u0015\u0005Y\u0015!B6bM.\f7\u0001\u0001\t\u0003\u001d\u0006i\u0011\u0001\u0013\u0002\u0011\u0017\u000647.\u0019*bMRl\u0015M\\1hKJ\u001c\"!A)\u0011\u0005I+V\"A*\u000b\u0003Q\u000bQa]2bY\u0006L!AV*\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQJ\u0001\u0007SC\u001a$\u0018j\u001c+ie\u0016\fGmE\u0002\u00047\"\u0004\"\u0001\u00184\u000e\u0003uS!AX0\u0002\tU$\u0018\u000e\u001c\u0006\u0003A\u0006\faa]3sm\u0016\u0014(BA&c\u0015\t\u0019G-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0006\u0019qN]4\n\u0005\u001dl&AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012\u0004\"!\u001b7\u000e\u0003)T!a\u001b&\u0002\u000bU$\u0018\u000e\\:\n\u00055T'a\u0002'pO\u001eLgnZ\u0001\u0007G2LWM\u001c;1\u0005A<\bcA9tk6\t!O\u0003\u0002JC&\u0011AO\u001d\u0002\u0010\u0017\u000647.\u0019*bMR\u001cE.[3oiB\u0011ao\u001e\u0007\u0001\t%AH!!A\u0001\u0002\u000b\u0005\u0011PA\u0002`IE\n\"A_?\u0011\u0005I[\u0018B\u0001?T\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\u0015@\n\u0005}\u001c&aA!os\u0006\u0001B\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\t\u0005\u0003\u000b\t\u0019B\u0004\u0003\u0002\b\u0005=\u0001cAA\u0005'6\u0011\u00111\u0002\u0006\u0004\u0003\u001ba\u0015A\u0002\u001fs_>$h(C\u0002\u0002\u0012M\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u000b\u0003/\u0011aa\u0015;sS:<'bAA\t'\u0006\tb-\u0019;bY\u001a\u000bW\u000f\u001c;IC:$G.\u001a:\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\t`\u0003\u00151\u0017-\u001e7u\u0013\u0011\t)#a\b\u0003\u0019\u0019\u000bW\u000f\u001c;IC:$G.\u001a:\u0015\u0011\u0005%\u0012QFA\u001c\u0003s\u00012!a\u000b\u0004\u001b\u0005\t\u0001B\u00028\b\u0001\u0004\ty\u0003\r\u0003\u00022\u0005U\u0002\u0003B9t\u0003g\u00012A^A\u001b\t)A\u0018QFA\u0001\u0002\u0003\u0015\t!\u001f\u0005\b\u0003\u00039\u0001\u0019AA\u0002\u0011\u001d\tIb\u0002a\u0001\u00037\ta\u0001Z8X_J\\GCAA !\r\u0011\u0016\u0011I\u0005\u0004\u0003\u0007\u001a&\u0001B+oSR\f\u0001#\u001b8ji&\fG/Z*ikR$wn\u001e8\u0015\u0005\u0005%\u0003c\u0001*\u0002L%\u0019\u0011QJ*\u0003\u000f\t{w\u000e\\3b]\u0006I\u0011n\u001d*v]:LgnZ\u0001\u0013GJ,\u0017\r^3M_\u001e$\u0015N]3di>\u0014\u0018\u0010\u0006\u0004\u0002V\u0005\u0015\u0014\u0011\u000e\t\u0005\u0003/\n\t'\u0004\u0002\u0002Z)!\u00111LA/\u0003\tIwN\u0003\u0002\u0002`\u0005!!.\u0019<b\u0013\u0011\t\u0019'!\u0017\u0003\t\u0019KG.\u001a\u0005\b\u0003OZ\u0001\u0019AA+\u0003\u0019awn\u001a#je\"9\u00111N\u0006A\u0002\u0005\r\u0011A\u00037pO\u0012K'OT1nK\u0006YAn\\2l\t\u0006$\u0018\rR5s)\u0011\t\t(a\u001e\u0011\u0007%\f\u0019(C\u0002\u0002v)\u0014\u0001BR5mK2{7m\u001b\u0005\b\u0003sb\u0001\u0019AA+\u0003\u001d!\u0017\r^1ESJ,B!! \u0002\bN)Q\"UA@QB)a*!!\u0002\u0006&\u0019\u00111\u0011%\u0003\u0017I\u000bg\r^'b]\u0006<WM\u001d\t\u0004m\u0006\u001dEABAE\u001b\t\u0007\u0011PA\u0001U\u00039iW\r^1Qe>\u0004XM\u001d;jKN,\"!a$\u0011\t\u0005E\u0015QS\u0007\u0003\u0003'S!\u0001\u0019&\n\t\u0005]\u00151\u0013\u0002\u000f\u001b\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3t\u0003=iW\r^1Qe>\u0004XM\u001d;jKN\u0004\u0013AB2p]\u001aLw\r\u0005\u0003\u0002\u0012\u0006}\u0015\u0002BAQ\u0003'\u00131bS1gW\u0006\u001cuN\u001c4jO\u0006)1/\u001a:eKB1\u0011qUAY\u0003\u000bk!!!+\u000b\t\u0005-\u0016QV\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0007\u0005=v,\u0001\u0004d_6lwN\\\u0005\u0005\u0003g\u000bIKA\u0006SK\u000e|'\u000fZ*fe\u0012,\u0017A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0005\u0003s\u000bi,\u0004\u0002\u0002<*\u0019\u0011qV1\n\t\u0005}\u00161\u0018\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003\u001d!x\u000e]5d\u0013\u0012\u0004B!!/\u0002F&!\u0011qYA^\u0005\u0011)V/\u001b3\u0002\tQLW.\u001a\t\u0005\u0003\u001b\f\t.\u0004\u0002\u0002P*\u00191.a/\n\t\u0005M\u0017q\u001a\u0002\u0005)&lW-A\u0004nKR\u0014\u0018nY:\u0011\t\u0005e\u0017Q\\\u0007\u0003\u00037TA!!6\u0002<&!\u0011q\\An\u0005\u001diU\r\u001e:jGN\f1\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=PaR\u0004RAUAs\u0003\u0007I1!a:T\u0005\u0019y\u0005\u000f^5p]\u0006a2m\u001c8ue>dG.\u001a:Rk>\u0014X/\u001c,pi\u0016\u00148OR;ukJ,WCAAw!\u0019\ty/a>\u0002|6\u0011\u0011\u0011\u001f\u0006\u0005\u0003g\f)0\u0001\u0006d_:\u001cWO\u001d:f]RT1AXA/\u0013\u0011\tI0!=\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\r\u0005\u0005\u0002~\u0006}(1\u0001B\b\u001b\t\t)0\u0003\u0003\u0003\u0002\u0005U(aA'baB!!Q\u0001B\u0006\u001b\t\u00119A\u0003\u0003\u0003\n\u0005u\u0013\u0001\u00027b]\u001eLAA!\u0004\u0003\b\t9\u0011J\u001c;fO\u0016\u0014\b\u0003\u0002B\t\u0005OqAAa\u0005\u0003$9!!Q\u0003B\u0011\u001d\u0011\u00119Ba\b\u000f\t\te!Q\u0004\b\u0005\u0003\u0013\u0011Y\"C\u0001f\u0013\t\u0019G-\u0003\u0002LE&\u0011\u0011*Y\u0005\u0004\u0005K\u0011\u0018A\u0003*bMR\u001cuN\u001c4jO&!!\u0011\u0006B\u0016\u0005-\tE\r\u001a:fgN\u001c\u0006/Z2\u000b\u0007\t\u0015\"/A\u000fd_:$(o\u001c7mKJ\fVo\u001c:v[Z{G/\u001a:t\rV$XO]3!\u0003I!\u0018.\u001a:PE*,7\r^*u_J,w\n\u001d;\u0011\r\u0005u(1\u0007B\u001c\u0013\u0011\u0011)$!>\u0003\u0011=\u0003H/[8oC2\u0004BA!\u000f\u0003D5\u0011!1\b\u0006\u0005\u0005{\u0011y$A\u0003ti>\u0014XMC\u0002\u0003B)\u000bA\u0001^5fe&!!Q\tB\u001e\u0005=!\u0016.\u001a:PE*,7\r^*u_J,G\u0003\u0007B%\u0005\u0017\u0012iEa\u0014\u0003R\tM#Q\u000bB,\u00053\u0012YF!\u0018\u0003`A!a*DAC\u0011\u001d\tYi\u0007a\u0001\u0003\u001fCq!a'\u001c\u0001\u0004\ti\nC\u0004\u0002$n\u0001\r!!*\t\u000f\u0005U6\u00041\u0001\u00028\"9\u0011\u0011Y\u000eA\u0002\u0005\r\u0007bBAe7\u0001\u0007\u00111\u001a\u0005\b\u0003+\\\u0002\u0019AAl\u0011\u001d\t\to\u0007a\u0001\u0003GDq!!;\u001c\u0001\u0004\ti\u000fC\u0004\u0002\u001am\u0001\r!a\u0007\t\u000f\t=2\u00041\u0001\u00032\u000511\r\\8tK\u0012,\"A!\u001a\u0011\t\t\u001d$QN\u0007\u0003\u0005SRAAa\u001b\u0002r\u00061\u0011\r^8nS\u000eLAAa\u001c\u0003j\ti\u0011\t^8nS\u000e\u0014un\u001c7fC:\fqa\u00197pg\u0016$\u0007%A\u0006ba&4VM]:j_:\u001cXC\u0001B<!\u0011\u0011IHa \u000e\u0005\tm$b\u0001B?C\u000691\r\\5f]R\u001c\u0018\u0002\u0002BA\u0005w\u00121\"\u00119j-\u0016\u00148/[8og\u0006a\u0011\r]5WKJ\u001c\u0018n\u001c8tA\u0005Q!/\u00194u\u0007>tg-[4\u0016\u0005\t%\u0005cA9\u0003\f&\u0019!Q\u0012:\u0003\u0015I\u000bg\r^\"p]\u001aLw-A\u0006sC\u001a$8i\u001c8gS\u001e\u0004SCAA\u0002\u0003E!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007\u0010I\u0001\u000bY><7i\u001c8uKb$XC\u0001BM!\u0011\tiMa'\n\t\tu\u0015q\u001a\u0002\u000b\u0019><7i\u001c8uKb$\u0018a\u00037pO\u000e{g\u000e^3yi\u0002\n\u0011b]2iK\u0012,H.\u001a:\u0016\u0005\t\u0015\u0006c\u0001/\u0003(&\u0019!\u0011V/\u0003\u001d-\u000bgm[1TG\",G-\u001e7fe\u0006Q1o\u00195fIVdWM\u001d\u0011\u0016\u0005\u0005U\u0013\u0001\u00033bi\u0006$\u0015N\u001d\u0011\u0002\u0017\u0011\fG/\u0019#je2{7m[\u000b\u0003\u0005k\u0003RAUAs\u0003c\nA\u0002Z1uC\u0012K'\u000fT8dW\u0002\nQB]3qY&\u001c\u0017\r^3e\u0019><WC\u0001B_!\r\t(qX\u0005\u0004\u0005\u0003\u0014(!\u0004*fa2L7-\u0019;fI2{w-\u0001\bsKBd\u0017nY1uK\u0012dun\u001a\u0011\u0002\u00159,Go\u00115b]:,G.\u0006\u0002\u0003JB\u0019\u0011Oa3\n\u0007\t5'OA\nLC\u001a\\\u0017MT3uo>\u00148n\u00115b]:,G.A\u0006oKR\u001c\u0005.\u00198oK2\u0004\u0013aD3ya&\u0014\u0018\r^5p]RKW.\u001a:\u0016\u0005\tU\u0007\u0003\u0002Bl\u0005;l!A!7\u000b\u0007\tmW,A\u0003uS6,'/\u0003\u0003\u0003`\ne'aC*zgR,W\u000eV5nKJ\f\u0001#\u001a=qSJ\fG/[8o)&lWM\u001d\u0011\u0002#\u0015D\b/\u001b:bi&|gnU3sm&\u001cW-\u0006\u0002\u0003hB\u0019aJ!;\n\u0007\t-\bJ\u0001\u000fUS6LgnZ,iK\u0016dW\t\u001f9je\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0002%\u0015D\b/\u001b:bi&|gnU3sm&\u001cW\rI\u000b\u0003\u0005c\u0004B!]:\u0002\u0006\u000691\r\\5f]R\u0004\u0013\u0001\u0004:bMRLu\u000e\u00165sK\u0006$WC\u0001B}!\r\u0011Yp\u0001\b\u0004\u0005{\u0004a\u0002\u0002B\u0000\u0007\u0007qA!!\u0003\u0004\u0002%\t1*\u0003\u0002J\u0015\u0006i!/\u00194u\u0013>$\u0006N]3bI\u0002\n\u0001\"\u001a=fGV$xN]\u000b\u0003\u0007\u0017\u0001RAUAs\u0007\u001b\u0001Baa\u0004\u0004\u001c5\u00111\u0011\u0003\u0006\u0005\u0003g\u001c\u0019BC\u0002L\u0007+QAaa\u0006\u0004\u001a\u0005I1m\u001c8gYV,g\u000e\u001e\u0006\u0003\u00037JAa!\b\u0004\u0012\tiQI^3oi\u0016CXmY;u_J\fA\"\u001a=fGV$xN]0%KF$B!a\u0010\u0004$!I1QE\u001d\u0002\u0002\u0003\u000711B\u0001\u0004q\u0012\n\u0014!C3yK\u000e,Ho\u001c:!\u0003\u001d\u0019H/\u0019:ukB\f\u0001b\u001d5vi\u0012|wO\\\u0001\te\u0016<\u0017n\u001d;feR!\u0011qHB\u0019\u0011\u001d\u0019\u0019$\u0010a\u0001\u0007k\t\u0001\u0002\\5ti\u0016tWM\u001d\t\u0007\u0007o\u0019i$!\"\u000f\u0007E\u001cI$C\u0002\u0004<I\f!BU1gi\u000ec\u0017.\u001a8u\u0013\u0011\u0019yd!\u0011\u0003\u00111K7\u000f^3oKJT1aa\u000fs\u00035A\u0017M\u001c3mKJ+\u0017/^3tiRA1qIB+\u0007K\u001aI\u0007\u0005\u0004\u0002p\u0006]8\u0011\n\t\u0005\u0007\u0017\u001a\t&\u0004\u0002\u0004N)!1qJA^\u0003!\u0001(o\u001c;pG>d\u0017\u0002BB*\u0007\u001b\u0012!\"\u00119j\u001b\u0016\u001c8/Y4f\u0011\u001d\u00199F\u0010a\u0001\u00073\na\u0001[3bI\u0016\u0014\b\u0003BB.\u0007Cj!a!\u0018\u000b\t\r}\u00131X\u0001\te\u0016\fX/Z:ug&!11MB/\u00055\u0011V-];fgRDU-\u00193fe\"91q\r A\u0002\r%\u0013a\u0002:fcV,7\u000f\u001e\u0005\b\u0007Wr\u0004\u0019AB7\u00035\u0019'/Z1uK\u0012$\u0016.\\3NgB\u0019!ka\u001c\n\u0007\rE4K\u0001\u0003M_:<\u0017!H7bs\n,')^5mIJ\u000bg\r^*oCB\u001c\bn\u001c;NC:\fw-\u001a:\u0015\u0005\r]\u0004#\u0002*\u0002f\u000ee\u0004\u0003BB>\u0007\u007fj!a! \u000b\u0007%\u0013y$\u0003\u0003\u0004\u0002\u000eu$\u0001F&SC\u001a$8K\\1qg\"|G/T1oC\u001e,'/A\bck&dGMU1gi\u000ec\u0017.\u001a8u)\t\u0011\t0A\nck&dGMT3uo>\u00148n\u00115b]:,G\u000e\u0006\u0002\u0003J\u0006i1M]3bi\u0016$\u0015\r^1ESJ$\"!!\u0016\u0002!\t,\u0018\u000e\u001c3NKR\fG-\u0019;b\u0019><GCABJ!\rq5QS\u0005\u0004\u0007/C%\u0001E&bM.\fW*\u001a;bI\u0006$\u0018\rT8h\u0003I\u0011W/\u001b7e\u001d\u0016$xo\u001c:l\u00072LWM\u001c;\u0015\u0005\ru\u0005\u0003\u0002B=\u0007?KAa!)\u0003|\tia*\u001a;x_J\\7\t\\5f]R\fa\u0002\\3bI\u0016\u0014\u0018I\u001c3Fa>\u001c\u0007.\u0006\u0002\u0004(B\u0019\u0011o!+\n\u0007\r-&O\u0001\bMK\u0006$WM]!oI\u0016\u0003xn\u00195\u0002\u0017I,7m\u001c:e'\u0016\u0014H-Z\u000b\u0003\u0003K\u0003")
public class KafkaRaftManager<T>
implements RaftManager<T>,
Logging {
    private final MetaProperties metaProperties;
    private final KafkaConfig config;
    private final RecordSerde<T> serde;
    private final TopicPartition topicPartition;
    private final Uuid topicId;
    private final Time time;
    private final Metrics metrics;
    private final CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final Optional<TierObjectStore> tierObjectStoreOpt;
    private final AtomicBoolean closed;
    private final ApiVersions apiVersions;
    private final RaftConfig raftConfig;
    private final String threadNamePrefix;
    private final LogContext logContext;
    private final KafkaScheduler scheduler;
    private final File dataDir;
    private final Option<FileLock> dataDirLock;
    private final ReplicatedLog replicatedLog;
    private final KafkaNetworkChannel netChannel;
    private final SystemTimer expirationTimer;
    private final TimingWheelExpirationService expirationService;
    private final KafkaRaftClient<T> client;
    private final RaftIoThread raftIoThread;
    private Option<EventExecutor> executor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public MetaProperties metaProperties() {
        return this.metaProperties;
    }

    public CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    private AtomicBoolean closed() {
        return this.closed;
    }

    public ApiVersions apiVersions() {
        return this.apiVersions;
    }

    private RaftConfig raftConfig() {
        return this.raftConfig;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File dataDir() {
        return this.dataDir;
    }

    private Option<FileLock> dataDirLock() {
        return this.dataDirLock;
    }

    @Override
    public ReplicatedLog replicatedLog() {
        return this.replicatedLog;
    }

    private KafkaNetworkChannel netChannel() {
        return this.netChannel;
    }

    private SystemTimer expirationTimer() {
        return this.expirationTimer;
    }

    private TimingWheelExpirationService expirationService() {
        return this.expirationService;
    }

    @Override
    public KafkaRaftClient<T> client() {
        return this.client;
    }

    private RaftIoThread raftIoThread() {
        return this.raftIoThread;
    }

    private Option<EventExecutor> executor() {
        return this.executor;
    }

    private void executor_$eq(Option<EventExecutor> x$1) {
        this.executor = x$1;
    }

    public void startup() {
        java.util.Map<Integer, RaftConfig.AddressSpec> voterAddresses = this.controllerQuorumVotersFuture().get();
        CollectionConverters$.MODULE$.SetHasAsScala(voterAddresses.entrySet()).asScala().foreach((Function1 & Serializable)voterAddressEntry -> {
            KafkaRaftManager.$anonfun$startup$1(this, voterAddressEntry);
            return BoxedUnit.UNIT;
        });
        this.netChannel().start();
        this.raftIoThread().start();
    }

    public void shutdown() {
        if (!this.closed().getAndSet(true)) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.expirationService().shutdown(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.expirationTimer().close(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.raftIoThread().shutdown(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.client().close(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.scheduler().shutdown(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.netChannel().close(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.replicatedLog().close(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.dataDirLock().foreach((Function1 & Serializable)x$3 -> {
                x$3.destroy();
                return BoxedUnit.UNIT;
            }), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.executor().foreach((Function1 & Serializable)x$4 -> x$4.shutdown()), this, Level.WARN);
            return;
        }
    }

    @Override
    public void register(RaftClient.Listener<T> listener) {
        this.client().register(listener);
    }

    @Override
    public CompletableFuture<ApiMessage> handleRequest(RequestHeader header, ApiMessage request, long createdTimeMs) {
        RaftRequest.Inbound inboundRequest = new RaftRequest.Inbound(header.correlationId(), request, createdTimeMs);
        this.client().handle(inboundRequest);
        return inboundRequest.completion.thenApply(response -> response.data());
    }

    private Option<KRaftSnapshotManager> maybeBuildRaftSnapshotManager() {
        if (!Predef$.MODULE$.Boolean2boolean(this.config.confluentConfig().clusterMetadataSnapshotTierUploadEnableFlag())) {
            return None$.MODULE$;
        }
        if (!this.config.processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$)) {
            return None$.MODULE$;
        }
        if (!this.tierObjectStoreOpt.isPresent()) {
            throw new ConfigException(new StringBuilder(45).append("tier.enable is set to ").append(this.config.confluentConfig().tierEnable()).append(", should be set to true").toString());
        }
        Function<TopicIdPartition, Optional<Path>> topicIdPath = tpId -> {
            TopicIdPartition topicIdPartition = tpId;
            TopicIdPartition topicIdPartition2 = new TopicIdPartition(KafkaRaftServer$.MODULE$.MetadataTopicId(), KafkaRaftServer$.MODULE$.MetadataPartition());
            if (topicIdPartition != null && topicIdPartition.equals(topicIdPartition2)) {
                TopicPartition logDirName_topicPartition = $this.topicPartition;
                Object var3_3 = null;
                return Optional.of(new File($this.config.metadataLogDir(), LocalLog$.MODULE$.logDirName(logDirName_topicPartition)).toPath());
            }
            return Optional.empty();
        };
        int pendingTasksCapacity = 1024;
        this.executor_$eq((Option<EventExecutor>)new Some((Object)new DefaultEventExecutor(Executors.defaultThreadFactory(), pendingTasksCapacity)));
        return new Some((Object)KRaftSnapshotManager.create((EventExecutor)this.executor().get(), this.tierObjectStoreOpt.get(), new KRaftSnapshotMetrics(this.metrics), this.logContext(), topicIdPath, this.metaProperties().clusterId(), this.metaProperties().nodeId(), () -> $this.config.confluentConfig().clusterMetadataSnapshotTierDeleteEnableFlag(), () -> $this.config.confluentConfig().clusterMetadataSnapshotTierDeleteRetentionMs(), this.time));
    }

    private KafkaRaftClient<T> buildRaftClient() {
        FileBasedStateStore quorumStateStore = new FileBasedStateStore(new File(this.dataDir(), "quorum-state"));
        OptionalInt nodeId = OptionalInt.of(this.config.nodeId());
        ObjectRef tracers = ObjectRef.create((Object)new .colon.colon((Object)KRaftDurabilityAuditor$.MODULE$, (List)Nil$.MODULE$));
        this.maybeBuildRaftSnapshotManager().foreach((Function1 & Serializable)snapshotTracer -> {
            tracers.elem = ((List)tracers.elem).$colon$colon((Object)snapshotTracer);
            return BoxedUnit.UNIT;
        });
        KafkaRaftClient client = new KafkaRaftClient(this.recordSerde(), (NetworkChannel)this.netChannel(), this.replicatedLog(), (QuorumStateStore)quorumStateStore, this.time, this.metrics, (ExpirationService)this.expirationService(), this.logContext(), this.metaProperties().clusterId(), nodeId, this.raftConfig(), (RaftTracer)new CompositeRaftTracer(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)tracers.elem)).asJava(), this.logContext()));
        client.initialize();
        return client;
    }

    private KafkaNetworkChannel buildNetworkChannel() {
        NetworkClient netClient = this.buildNetworkClient();
        return new KafkaNetworkChannel(this.time, (KafkaClient)netClient, Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), this.threadNamePrefix());
    }

    private File createDataDir() {
        TopicPartition logDirName_topicPartition = this.topicPartition;
        Object var2_1 = null;
        String logDirName = LocalLog$.MODULE$.logDirName(logDirName_topicPartition);
        return KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$createLogDirectory(new File(this.config.metadataLogDir()), logDirName);
    }

    private KafkaMetadataLog buildMetadataLog() {
        return KafkaMetadataLog$.MODULE$.apply(this.topicPartition, this.topicId, this.dataDir(), this.time, this.metrics, (Scheduler)this.scheduler(), MetadataLogConfig$.MODULE$.apply(this.config, 0x800000, 0x800000), x$5 -> this.client().traceLogStartOffsetChange(), x$6 -> this.client().traceLogSnapshotGeneration());
    }

    /*
     * WARNING - void declaration
     */
    private NetworkClient buildNetworkClient() {
        void clientChannelBuilder_logContext;
        void clientChannelBuilder_saslHandshakeRequestEnable;
        void clientChannelBuilder_time;
        void clientChannelBuilder_clientSaslMechanism;
        void clientChannelBuilder_config;
        ListenerName controllerListenerName = new ListenerName((String)this.config.controllerListenerNames().head());
        SecurityProtocol controllerSecurityProtocol = (SecurityProtocol)this.config.effectiveListenerSecurityProtocolMap().getOrElse((Object)controllerListenerName, (Function0 & Serializable)() -> SecurityProtocol.forName((String)controllerListenerName.value()));
        LogContext logContext = this.logContext();
        boolean bl = this.config.saslInterBrokerHandshakeRequestEnable();
        Time time = this.time;
        String string = this.config.saslMechanismControllerProtocol();
        KafkaConfig kafkaConfig = this.config;
        JaasContext.Type clientChannelBuilder_contextType = JaasContext.Type.SERVER;
        Object var12_8 = null;
        kafkaConfig = null;
        string = null;
        time = null;
        logContext = null;
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)controllerSecurityProtocol, (JaasContext.Type)clientChannelBuilder_contextType, (AbstractConfig)clientChannelBuilder_config, (ListenerName)controllerListenerName, (String)clientChannelBuilder_clientSaslMechanism, (Time)clientChannelBuilder_time, (boolean)clientChannelBuilder_saslHandshakeRequestEnable, (LogContext)clientChannelBuilder_logContext, null, null);
        String metricGroupPrefix = "raft-channel";
        boolean collectPerConnectionMetrics = false;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), this.metrics, this.time, metricGroupPrefix, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava(), collectPerConnectionMetrics, channelBuilder, this.logContext());
        String clientId = new StringBuilder(12).append("raft-client-").append(this.config.nodeId()).toString();
        int maxInflightRequestsPerConnection = 1;
        int reconnectBackoffMs = 50;
        int reconnectBackoffMsMs = 500;
        boolean discoverBrokerVersions = true;
        return new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, maxInflightRequestsPerConnection, Int$.MODULE$.int2long(reconnectBackoffMs), Int$.MODULE$.int2long(reconnectBackoffMsMs), -1, Predef$.MODULE$.Integer2int(this.config.socketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, discoverBrokerVersions, this.apiVersions(), this.logContext());
    }

    @Override
    public LeaderAndEpoch leaderAndEpoch() {
        return this.client().leaderAndEpoch();
    }

    @Override
    public RecordSerde<T> recordSerde() {
        return this.serde;
    }

    public static final /* synthetic */ void $anonfun$startup$1(KafkaRaftManager $this, Map.Entry voterAddressEntry) {
        RaftConfig.AddressSpec addressSpec = (RaftConfig.AddressSpec)voterAddressEntry.getValue();
        if (addressSpec instanceof RaftConfig.InetAddressSpec) {
            RaftConfig.InetAddressSpec inetAddressSpec = (RaftConfig.InetAddressSpec)addressSpec;
            $this.netChannel().updateEndpoint(Predef$.MODULE$.Integer2int((Integer)voterAddressEntry.getKey()), inetAddressSpec);
            return;
        }
        if (addressSpec instanceof RaftConfig.UnknownAddressSpec) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(79).append("Skipping channel update for destination ID: ").append(voterAddressEntry.getKey()).append(" ").append("because of non-routable endpoint: ").append(RaftConfig.NON_ROUTABLE_ADDRESS.toString()).toString());
            return;
        }
        if (addressSpec != null) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(72).append("Unexpected address spec (type: ").append(addressSpec.getClass()).append(") for channel update for ").append("destination ID: ").append(voterAddressEntry.getKey()).toString());
            return;
        }
        throw new MatchError(null);
    }

    public KafkaRaftManager(MetaProperties metaProperties, KafkaConfig config, RecordSerde<T> serde, TopicPartition topicPartition, Uuid topicId, Time time, Metrics metrics, Option<String> threadNamePrefixOpt, CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture, FaultHandler fatalFaultHandler, Optional<TierObjectStore> tierObjectStoreOpt) {
        this.metaProperties = metaProperties;
        this.config = config;
        this.serde = serde;
        this.topicPartition = topicPartition;
        this.topicId = topicId;
        this.time = time;
        this.metrics = metrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.tierObjectStoreOpt = tierObjectStoreOpt;
        this.closed = new AtomicBoolean(false);
        this.apiVersions = new ApiVersions();
        this.raftConfig = new RaftConfig((AbstractConfig)config);
        this.threadNamePrefix = (String)threadNamePrefixOpt.getOrElse((Function0 & Serializable)() -> "kafka-raft");
        this.logContext = new LogContext(new StringBuilder(18).append("[RaftManager id=").append(config.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.scheduler = new KafkaScheduler(1, true, new StringBuilder(10).append(this.threadNamePrefix()).append("-scheduler").toString(), false);
        this.scheduler().startup();
        this.dataDir = this.createDataDir();
        boolean differentMetadataLogDir = !((SeqOps)config.logDirs().map((Function1 & Serializable)x$2 -> Paths.get(x$2, new String[0]).toAbsolutePath())).contains((Object)Paths.get(config.metadataLogDir(), new String[0]).toAbsolutePath());
        Set<KafkaRaftServer.ProcessRole> set = config.processRoles();
        Object object = Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer$ControllerRole$[]{KafkaRaftServer$ControllerRole$.MODULE$}));
        boolean isOnlyController = !(set != null ? !set.equals(object) : object != null);
        this.dataDirLock = differentMetadataLogDir || isOnlyController ? new Some((Object)KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$lockDataDir(new File(config.metadataLogDir()))) : None$.MODULE$;
        this.replicatedLog = this.buildMetadataLog();
        this.netChannel = this.buildNetworkChannel();
        this.expirationTimer = new SystemTimer("raft-expiration-executor");
        this.expirationService = new TimingWheelExpirationService((Timer)this.expirationTimer());
        this.client = this.buildRaftClient();
        this.raftIoThread = new RaftIoThread(this.client(), this.threadNamePrefix(), fatalFaultHandler);
        this.executor = None$.MODULE$;
    }

    public static class RaftIoThread
    extends ShutdownableThread
    implements Logging {
        private final KafkaRaftClient<?> client;
        private final FaultHandler fatalFaultHandler;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return Logging.loggerName$(this);
        }

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        public void doWork() {
            try {
                this.client.poll();
                return;
            }
            catch (Throwable t) {
                throw this.fatalFaultHandler.handleFault("Unexpected error in raft IO thread", t);
            }
        }

        public boolean initiateShutdown() {
            if (super.initiateShutdown()) {
                this.client.shutdown(5000).whenComplete((x$1, exception) -> {
                    if (exception != null) {
                        this.error((Function0<String>)(Function0 & Serializable)() -> "Graceful shutdown of RaftClient failed", (Function0<Throwable>)(Function0 & Serializable)() -> exception);
                        return;
                    }
                    this.info((Function0<String>)(Function0 & Serializable)() -> "Completed graceful shutdown of RaftClient");
                });
                return true;
            }
            return false;
        }

        public boolean isRunning() {
            return this.client.isRunning() && !this.isThreadFailed();
        }

        public RaftIoThread(KafkaRaftClient<?> client, String threadNamePrefix, FaultHandler fatalFaultHandler) {
            this.client = client;
            this.fatalFaultHandler = fatalFaultHandler;
            super(new StringBuilder(10).append(threadNamePrefix).append("-io-thread").toString(), false);
            this.logIdent_$eq(this.logPrefix);
        }
    }
}

