/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.server.AbstractQuotaChannelManager;
import kafka.server.ActiveTenantsManager;
import kafka.server.AllRequests$;
import kafka.server.BrokerBackpressureConfig$;
import kafka.server.BrokerBackpressureMetrics$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientRequestQuotaManager$;
import kafka.server.ClientSensors;
import kafka.server.ExemptRequest$;
import kafka.server.NonExemptRequest$;
import kafka.server.QueueSizePercentiles;
import kafka.server.QuotaType$Request$;
import kafka.server.RequestQueueSizePercentiles$;
import kafka.server.RequestType;
import kafka.server.ThreadUsageMetrics$;
import kafka.server.ThreadUsageSensors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t-r!B\u00193\u0011\u00039d!B\u001d3\u0011\u0003Q\u0004\"B!\u0002\t\u0003\u0011\u0005bB\"\u0002\u0005\u0004%\t\u0001\u0012\u0005\u0007\u0011\u0006\u0001\u000b\u0011B#\t\u000f%\u000b!\u0019!C\u0001\t\"1!*\u0001Q\u0001\n\u0015CqaS\u0001C\u0002\u0013\u0005A\n\u0003\u0004Q\u0003\u0001\u0006I!\u0014\u0005\b#\u0006\u0011\r\u0011\"\u0003S\u0011\u0019Y\u0016\u0001)A\u0005'\"1A,\u0001C\u0001eu3A!\u000f\u001a\u0001A\"AA\r\u0004BC\u0002\u0013%Q\r\u0003\u0005j\u0019\t\u0005\t\u0015!\u0003g\u0011!QGB!b\u0001\n\u0013Y\u0007\u0002\u0003=\r\u0005\u0003\u0005\u000b\u0011\u00027\t\u0015ed!\u0011!Q\u0001\ni\f\t\u0001\u0003\u0006\u0002\u00041\u0011)\u0019!C\u0005\u0003\u000bA!\"a\u0007\r\u0005\u0003\u0005\u000b\u0011BA\u0004\u0011)\ti\u0002\u0004BC\u0002\u0013%\u0011q\u0004\u0005\u000b\u0003ka!\u0011!Q\u0001\n\u0005\u0005\u0002BCA\u001c\u0019\t\u0005\t\u0015!\u0003\u0002:!1\u0011\t\u0004C\u0001\u0003\u0003B\u0011\"!\u0015\r\u0005\u0004%I!a\u0015\t\u0011\u0005mC\u0002)A\u0005\u0003+B\u0001\"!\u0018\r\u0001\u0004%I\u0001\u0012\u0005\n\u0003?b\u0001\u0019!C\u0005\u0003CBq!!\u001c\rA\u0003&Q\tC\u0005\u0002p1\u0011\r\u0011\"\u0003\u0002r!A\u00111\u0010\u0007!\u0002\u0013\t\u0019\bC\u0005\u0002~1\u0011\r\u0011\"\u0001\u0002\u0000!A\u0011q\u0011\u0007!\u0002\u0013\t\t\tC\u0004\u0002\n2!\t!a \t\u000f\u0005-E\u0002\"\u0003\u0002\u000e\"9\u00111\u0014\u0007\u0005\n\u0005u\u0005bBAR\u0019\u0011\u0005\u0011Q\u0015\u0005\b\u0003ScA\u0011AAV\u0011\u001d\ty\u000b\u0004C\u0001\u0003cCq!a5\r\t\u0003\t)\u000eC\u0004\u0002Z2!\t%a7\t\u000f\u0005\rH\u0002\"\u0015\u0002f\"1\u0011\u0011\u001f\u0007\u0005B\u0011Cq!a=\r\t\u0013\t)\u0010C\u0004\u0003\u00061!IAa\u0002\t\u0011\tEA\u0002\"\u00153\u0005'AqAa\u0006\r\t\u0003\u0011I\u0002C\u0004\u0003$1!\tE!\n\t\u001d\t\u001dB\u0002%A\u0002\u0002\u0003%IA!\u000b\u0002\u0002\u0005I2\t\\5f]R\u0014V-];fgR\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0015\t\u0019D'\u0001\u0004tKJ4XM\u001d\u0006\u0002k\u0005)1.\u00194lC\u000e\u0001\u0001C\u0001\u001d\u0002\u001b\u0005\u0011$!G\"mS\u0016tGOU3rk\u0016\u001cH/U;pi\u0006l\u0015M\\1hKJ\u001c\"!A\u001e\u0011\u0005qzT\"A\u001f\u000b\u0003y\nQa]2bY\u0006L!\u0001Q\u001f\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq'\u0001\u000eRk>$\u0018MU3rk\u0016\u001cH\u000fU3sG\u0016tG\u000fR3gCVdG/F\u0001F!\tad)\u0003\u0002H{\t1Ai\\;cY\u0016\f1$U;pi\u0006\u0014V-];fgR\u0004VM]2f]R$UMZ1vYR\u0004\u0013A\u0007(b]>\u001cHk\u001c)fe\u000e,g\u000e^1hKB+'oU3d_:$\u0017a\u0007(b]>\u001cHk\u001c)fe\u000e,g\u000e^1hKB+'oU3d_:$\u0007%\u0001\u0019EK\u001a\fW\u000f\u001c;J]\u0006\u001cG/\u001b<f\u000bb,W\u000e\u001d;TK:\u001cxN]#ya&\u0014\u0018\r^5p]RKW.Z*fG>tGm]\u000b\u0002\u001bB\u0011AHT\u0005\u0003\u001fv\u0012A\u0001T8oO\u0006\tD)\u001a4bk2$\u0018J\\1di&4X-\u0012=f[B$8+\u001a8t_J,\u0005\u0010]5sCRLwN\u001c+j[\u0016\u001cVmY8oIN\u0004\u0013\u0001E#yK6\u0004HoU3og>\u0014h*Y7f+\u0005\u0019\u0006C\u0001+Z\u001b\u0005)&B\u0001,X\u0003\u0011a\u0017M\\4\u000b\u0003a\u000bAA[1wC&\u0011!,\u0016\u0002\u0007'R\u0014\u0018N\\4\u0002#\u0015CX-\u001c9u'\u0016t7o\u001c:OC6,\u0007%A\toC:|7\u000fV8QKJ\u001cWM\u001c;bO\u0016$\"!\u00120\t\u000b}[\u0001\u0019A'\u0002\u000b9\fgn\\:\u0014\u00051\t\u0007C\u0001\u001dc\u0013\t\u0019'G\u0001\nDY&,g\u000e^)v_R\fW*\u00198bO\u0016\u0014\u0018AB2p]\u001aLw-F\u0001g!\tAt-\u0003\u0002ie\tA2\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u00059Q.\u001a;sS\u000e\u001cX#\u00017\u0011\u000554X\"\u00018\u000b\u0005)|'B\u00019r\u0003\u0019\u0019w.\\7p]*\u0011QG\u001d\u0006\u0003gR\fa!\u00199bG\",'\"A;\u0002\u0007=\u0014x-\u0003\u0002x]\n9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\tQLW.\u001a\t\u0003wzl\u0011\u0001 \u0006\u0003{>\fQ!\u001e;jYNL!a ?\u0003\tQKW.Z\u0005\u0003s\n\f\u0001\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=\u0016\u0005\u0005\u001d\u0001\u0003BA\u0005\u0003/qA!a\u0003\u0002\u0014A\u0019\u0011QB\u001f\u000e\u0005\u0005=!bAA\tm\u00051AH]8pizJ1!!\u0006>\u0003\u0019\u0001&/\u001a3fM&\u0019!,!\u0007\u000b\u0007\u0005UQ(A\tuQJ,\u0017\r\u001a(b[\u0016\u0004&/\u001a4jq\u0002\n1c\u00197jK:$\u0018+^8uC\u000e\u000bG\u000e\u001c2bG.,\"!!\t\u0011\u000bq\n\u0019#a\n\n\u0007\u0005\u0015RH\u0001\u0004PaRLwN\u001c\t\u0005\u0003S\t\t$\u0004\u0002\u0002,)!\u0011QFA\u0018\u0003\u0015\tXo\u001c;b\u0015\t\u0019\u0014/\u0003\u0003\u00024\u0005-\"aE\"mS\u0016tG/U;pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0017\u0001F2mS\u0016tG/U;pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0007%\u0001\u000bbGRLg/\u001a+f]\u0006tGo]'b]\u0006<WM\u001d\t\u0006y\u0005\r\u00121\b\t\u0004q\u0005u\u0012bAA e\t!\u0012i\u0019;jm\u0016$VM\\1oiNl\u0015M\\1hKJ$b\"a\u0011\u0002F\u0005\u001d\u0013\u0011JA&\u0003\u001b\ny\u0005\u0005\u00029\u0019!)Am\u0006a\u0001M\")!n\u0006a\u0001Y\")\u0011p\u0006a\u0001u\"9\u00111A\fA\u0002\u0005\u001d\u0001bBA\u000f/\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003o9\u0002\u0019AA\u001d\u0003I!\bN]3bIV\u001b\u0018mZ3TK:\u001cxN]:\u0016\u0005\u0005U\u0003c\u0001\u001d\u0002X%\u0019\u0011\u0011\f\u001a\u0003%QC'/Z1e+N\fw-Z*f]N|'o]\u0001\u0014i\"\u0014X-\u00193Vg\u0006<WmU3og>\u00148\u000fI\u0001\u0014Y\u0006\u001cH\u000fT5nSR\u001cuN\u001d:fGRLwN\\\u0001\u0018Y\u0006\u001cH\u000fT5nSR\u001cuN\u001d:fGRLwN\\0%KF$B!a\u0019\u0002jA\u0019A(!\u001a\n\u0007\u0005\u001dTH\u0001\u0003V]&$\b\u0002CA67\u0005\u0005\t\u0019A#\u0002\u0007a$\u0013'\u0001\u000bmCN$H*[7ji\u000e{'O]3di&|g\u000eI\u0001\u0011Kb,W\u000e\u001d;NKR\u0014\u0018n\u0019(b[\u0016,\"!a\u001d\u0011\t\u0005U\u0014qO\u0007\u0002_&\u0019\u0011\u0011P8\u0003\u00155+GO]5d\u001d\u0006lW-A\tfq\u0016l\u0007\u000f^'fiJL7MT1nK\u0002\nA\"\u001a=f[B$8+\u001a8t_J,\"!!!\u0011\u00075\f\u0019)C\u0002\u0002\u0006:\u0014aaU3og>\u0014\u0018!D3yK6\u0004HoU3og>\u0014\b%A\fo_:,\u00050Z7qi\u000e\u000b\u0007/Y2jif\u001cVM\\:pe\u0006I\"/Z2pe\u0012,\u00050Z7qi:+Go^8sWRC'/Z1e)!\t\u0019'a$\u0002\u0014\u0006]\u0005BBAIE\u0001\u0007Q)A\u0003wC2,X\rC\u0004\u0002\u0016\n\u0002\r!a\u0002\u0002\u00191L7\u000f^3oKJt\u0015-\\3\t\r\u0005e%\u00051\u0001N\u0003\u0019!\u0018.\\3Ng\u0006!\"/Z2pe\u0012,\u00050Z7qi&{G\u000b\u001b:fC\u0012$b!a\u0019\u0002 \u0006\u0005\u0006BBAIG\u0001\u0007Q\t\u0003\u0004\u0002\u001a\u000e\u0002\r!T\u0001\u0013C\u0012$G*[:uK:,'/T3ue&\u001c7\u000f\u0006\u0003\u0002d\u0005\u001d\u0006bBAKI\u0001\u0007\u0011qA\u0001\u0016e\u0016lwN^3MSN$XM\\3s\u001b\u0016$(/[2t)\u0011\t\u0019'!,\t\u000f\u0005UU\u00051\u0001\u0002\b\u0005yR.Y=cKJ+7m\u001c:e\u0003:$w)\u001a;UQJ|G\u000f\u001e7f)&lW-T:\u0015\r\u0005M\u0016\u0011XAi!\ra\u0014QW\u0005\u0004\u0003ok$aA%oi\"9\u00111\u0018\u0014A\u0002\u0005u\u0016a\u0002:fcV,7\u000f\u001e\t\u0005\u0003\u007f\u000bYM\u0004\u0003\u0002B\u0006\u001dWBAAb\u0015\r\t)\rN\u0001\b]\u0016$xo\u001c:l\u0013\u0011\tI-a1\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&!\u0011QZAh\u0005\u001d\u0011V-];fgRTA!!3\u0002D\"1\u0011\u0011\u0014\u0014A\u00025\u000b\u0011#\\1zE\u0016\u0014VmY8sI\u0016CX-\u001c9u)\u0011\t\u0019'a6\t\u000f\u0005mv\u00051\u0001\u0002>\u0006\u0019\"-Y2laJ,7o];sK\u0016s\u0017M\u00197fIV\u0011\u0011Q\u001c\t\u0004y\u0005}\u0017bAAq{\t9!i\\8mK\u0006t\u0017\u0001F2mS\u0016tGOU1uK6+GO]5d\u001d\u0006lW\r\u0006\u0003\u0002t\u0005\u001d\bbBAuS\u0001\u0007\u00111^\u0001\u0010cV|G/Y'fiJL7\rV1hgBA\u0011\u0011BAw\u0003\u000f\t9!\u0003\u0003\u0002p\u0006e!aA'ba\u0006\u0019r-\u001a;Ce>\\WM])v_R\fG*[7ji\u0006\u0019\"/Z2pe\u0012Lu\u000e\u00165sK\u0006$Wk]1hKRA\u00111MA|\u0003s\u0014\u0019\u0001\u0003\u0004\u0002\u0012.\u0002\r!\u0012\u0005\b\u0003w\\\u0003\u0019AA\u007f\u0003-\u0011X-];fgR$\u0016\u0010]3\u0011\u0007a\ny0C\u0002\u0003\u0002I\u00121BU3rk\u0016\u001cH\u000fV=qK\"1\u0011\u0011T\u0016A\u00025\u000b!C]3d_J$g*\u001a;x_J\\Wk]1hKRQ\u00111\rB\u0005\u0005\u0017\u0011iAa\u0004\t\r\u0005EE\u00061\u0001F\u0011\u001d\t)\n\fa\u0001\u0003\u000fAq!a?-\u0001\u0004\ti\u0010\u0003\u0004\u0002\u001a2\u0002\r!T\u0001\u0017kB$\u0017\r^3Ce>\\WM])v_R\fG*[7jiR!\u00111\rB\u000b\u0011\u0019\tI*\fa\u0001\u001b\u00061R\u000f\u001d3bi\u0016\fEM[;ti\u0016$7)\u00199bG&$\u0018\u0010F\u0003F\u00057\u0011y\u0002\u0003\u0004\u0003\u001e9\u0002\r!R\u0001\u0013EJ|7.\u001a:SKF,Xm\u001d;MS6LG\u000f\u0003\u0004\u0003\"9\u0002\r!R\u0001\u001a]>tW\t_3naR$v\u000e^1m)\"\u0014X-\u00193MS6LG/\u0001\u0005tQV$Hm\\<o)\t\t\u0019'\u0001\u0006tkB,'\u000f\n;j[\u0016,\u0012A\u001f")
public class ClientRequestQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final String threadNamePrefix;
    private final Option<ClientQuotaCallback> clientQuotaCallback;
    private final ThreadUsageSensors threadUsageSensors;
    private double lastLimitCorrection;
    private final MetricName exemptMetricName;
    private final Sensor exemptSensor;

    public static long DefaultInactiveExemptSensorExpirationTimeSeconds() {
        return ClientRequestQuotaManager$.MODULE$.DefaultInactiveExemptSensorExpirationTimeSeconds();
    }

    public static double NanosToPercentagePerSecond() {
        return ClientRequestQuotaManager$.MODULE$.NanosToPercentagePerSecond();
    }

    public static double QuotaRequestPercentDefault() {
        return ClientRequestQuotaManager$.MODULE$.QuotaRequestPercentDefault();
    }

    private /* synthetic */ Time super$time() {
        return super.time();
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private Option<ClientQuotaCallback> clientQuotaCallback() {
        return this.clientQuotaCallback;
    }

    private ThreadUsageSensors threadUsageSensors() {
        return this.threadUsageSensors;
    }

    private double lastLimitCorrection() {
        return this.lastLimitCorrection;
    }

    private void lastLimitCorrection_$eq(double x$1) {
        this.lastLimitCorrection = x$1;
    }

    private MetricName exemptMetricName() {
        return this.exemptMetricName;
    }

    public Sensor exemptSensor() {
        return this.exemptSensor;
    }

    public Sensor nonExemptCapacitySensor() {
        return this.getOrCreateValueSensor("non-exempt-capacity", BrokerBackpressureMetrics$.MODULE$.nonExemptRequestCapacityMetricName(this.metrics()));
    }

    private void recordExemptNetworkThread(double value, String listenerName, long timeMs) {
        this.exemptSensor().record(value, timeMs, false);
        this.recordNetworkUsage(value, listenerName, ExemptRequest$.MODULE$, timeMs);
    }

    private void recordExemptIoThread(double value, long timeMs) {
        this.exemptSensor().record(value, timeMs, false);
        this.recordIoThreadUsage(value, ExemptRequest$.MODULE$, timeMs);
    }

    public void addListenerMetrics(String listenerName) {
        this.threadUsageSensors().addListenerMetrics(listenerName);
    }

    public void removeListenerMetrics(String listenerName) {
        this.threadUsageSensors().removeListenerMetrics(listenerName);
    }

    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request, long timeMs) {
        double reqIoThreadPercentage = (double)request.requestThreadTimeNanos() * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
        String listenerName = request.context().listenerName.value();
        this.recordIoThreadUsage(reqIoThreadPercentage, NonExemptRequest$.MODULE$, timeMs);
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(request.session(), request.header().clientId());
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable)timeNanos -> {
                long timeMs = this.super$time().milliseconds();
                this.recordNoThrottle(clientSensors, (double)timeNanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond(), timeMs);
                this.recordNetworkUsage((double)timeNanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond(), listenerName, NonExemptRequest$.MODULE$, timeMs);
            }));
            return this.recordAndGetThrottleTimeMs(clientSensors, reqIoThreadPercentage, timeMs);
        }
        request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable)timeNanos -> this.recordNetworkUsage((double)timeNanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond(), listenerName, NonExemptRequest$.MODULE$, this.super$time().milliseconds())));
        return 0;
    }

    public void maybeRecordExempt(RequestChannel.Request request) {
        long currentTimeMs = super.time().milliseconds();
        double reqIoThreadPercentage = (double)request.requestThreadTimeNanos() * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
        String listenerName = request.context().listenerName.value();
        if (this.quotasEnabled()) {
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable)timeNanos -> this.recordExemptNetworkThread((double)timeNanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond(), listenerName, this.super$time().milliseconds())));
            this.recordExemptIoThread(reqIoThreadPercentage, currentTimeMs);
            return;
        }
        request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable)timeNanos -> this.recordNetworkUsage((double)timeNanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond(), listenerName, ExemptRequest$.MODULE$, this.super$time().milliseconds())));
        this.recordIoThreadUsage(reqIoThreadPercentage, ExemptRequest$.MODULE$, currentTimeMs);
    }

    @Override
    public boolean backpressureEnabled() {
        return this.dynamicBackpressureConfig().backpressureEnabledInConfig() && this.dynamicBackpressureConfig().tenantEndpointListenerNames().nonEmpty();
    }

    @Override
    public MetricName clientRateMetricName(scala.collection.immutable.Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("request-time", "Request", "Tracking request-time per user/client-id", CollectionConverters$.MODULE$.MapHasAsJava(quotaMetricTags).asJava());
    }

    @Override
    public double getBrokerQuotaLimit() {
        Option metricOpt = Option$.MODULE$.apply((Object)this.metrics().metric(BrokerBackpressureMetrics$.MODULE$.nonExemptRequestCapacityMetricName(this.metrics())));
        if (metricOpt instanceof Some) {
            return BoxesRunTime.unboxToDouble((Object)((KafkaMetric)((Some)metricOpt).value()).metricValue());
        }
        return Double.MAX_VALUE;
    }

    private void recordIoThreadUsage(double value, RequestType requestType, long timeMs) {
        if (this.quotasEnabled()) {
            this.threadUsageSensors().recordIoThreadUsage(value, timeMs, requestType);
            return;
        }
        this.threadUsageSensors().recordIoThreadUsage(value, timeMs, AllRequests$.MODULE$);
    }

    private void recordNetworkUsage(double value, String listenerName, RequestType requestType, long timeMs) {
        if (this.quotasEnabled()) {
            this.threadUsageSensors().recordNetworkThreadUsage(value, timeMs, listenerName, requestType);
            return;
        }
        this.threadUsageSensors().recordNetworkThreadUsage(value, timeMs, listenerName, AllRequests$.MODULE$);
    }

    @Override
    public void updateBrokerQuotaLimit(long timeMs) {
        Seq<String> tenantEndpointsListenerNames = this.dynamicBackpressureConfig().tenantEndpointListenerNames();
        if (this.quotasEnabled() && tenantEndpointsListenerNames.nonEmpty()) {
            double nonExemptIoThreadUsage = ThreadUsageMetrics$.MODULE$.ioThreadsUsage(this.metrics(), NonExemptRequest$.MODULE$);
            double ioThreadUsage = ThreadUsageMetrics$.MODULE$.ioThreadsUsage(this.metrics(), AllRequests$.MODULE$);
            double nonExemptNetworkThreadUsage = ThreadUsageMetrics$.MODULE$.networkThreadsUsage(this.metrics(), tenantEndpointsListenerNames, NonExemptRequest$.MODULE$);
            double networkThreadUsage = ThreadUsageMetrics$.MODULE$.networkThreadsUsage(this.metrics(), tenantEndpointsListenerNames, AllRequests$.MODULE$);
            double nonExemptIoThreadLimit = ClientRequestQuotaManager.nonExemptThreadUsageLimit$1(nonExemptIoThreadUsage, ioThreadUsage, ThreadUsageMetrics$.MODULE$.ioThreadsCapacity(this.metrics()));
            double nonExemptNetworkThreadLimit = ClientRequestQuotaManager.nonExemptThreadUsageLimit$1(nonExemptNetworkThreadUsage, networkThreadUsage, ThreadUsageMetrics$.MODULE$.networkThreadsCapacity(this.metrics(), tenantEndpointsListenerNames));
            double nonExemptTotalThreadLimit = nonExemptIoThreadLimit + nonExemptNetworkThreadLimit;
            double brokerRequestQuotaLimit = ioThreadUsage >= nonExemptIoThreadLimit && networkThreadUsage >= nonExemptNetworkThreadLimit || ioThreadUsage < nonExemptIoThreadLimit && networkThreadUsage < nonExemptNetworkThreadLimit ? nonExemptTotalThreadLimit : package$.MODULE$.min(networkThreadUsage, nonExemptNetworkThreadLimit) + package$.MODULE$.min(ioThreadUsage, nonExemptIoThreadLimit);
            double correctedLimit = this.updateAdjustedCapacity(brokerRequestQuotaLimit, nonExemptTotalThreadLimit);
            this.nonExemptCapacitySensor().record(correctedLimit);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public double updateAdjustedCapacity(double brokerRequestLimit, double nonExemptTotalThreadLimit) {
        double d;
        void dataPlaneQueueSize_tags;
        void dataPlaneQueueSize_percentileSuffix;
        void dataPlaneQueueSize_metrics;
        Map map = (Map)Map$.MODULE$.empty();
        String string = this.dynamicBackpressureConfig().queueSizePercentile();
        Metrics metrics = this.metrics();
        RequestQueueSizePercentiles$ dataPlaneQueueSize_this = RequestQueueSizePercentiles$.MODULE$;
        Object var17_6 = null;
        metrics = null;
        string = null;
        map = null;
        double queueSize = QueueSizePercentiles.dataPlaneQueueSize$(dataPlaneQueueSize_this, (Metrics)dataPlaneQueueSize_metrics, (String)dataPlaneQueueSize_percentileSuffix, (Map)dataPlaneQueueSize_tags);
        double minAdjustment = BrokerBackpressureConfig$.MODULE$.RequestQuotaMinAdjustment();
        double increaseAdjustment = package$.MODULE$.max(minAdjustment, nonExemptTotalThreadLimit * BrokerBackpressureConfig$.MODULE$.DefaultRequestQuotaIncreasePercentFactor());
        double decreaseAdjustment = package$.MODULE$.max(minAdjustment, nonExemptTotalThreadLimit * BrokerBackpressureConfig$.MODULE$.DefaultRequestQuotaDecreasePercentFactor());
        double minCap = this.dynamicBackpressureConfig().minBrokerRequestQuota();
        if (queueSize >= this.dynamicBackpressureConfig().queueSizeCap()) {
            double maxAdjustmentLimit = package$.MODULE$.max(brokerRequestLimit - minCap, 0.0);
            d = package$.MODULE$.min(maxAdjustmentLimit, this.lastLimitCorrection() + decreaseAdjustment);
        } else {
            d = package$.MODULE$.max(0.0, this.lastLimitCorrection() - increaseAdjustment);
        }
        this.lastLimitCorrection_$eq(d);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("queueSize(p95)=").append(queueSize).append(",  lastLimitCorrection=").append(this.lastLimitCorrection()).toString());
        return package$.MODULE$.max(brokerRequestLimit - this.lastLimitCorrection(), minCap);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.threadUsageSensors().close();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$exemptSensor$1(ClientRequestQuotaManager $this, Sensor sensor) {
        void add_stat;
        void add_metricName;
        Rate rate = new Rate();
        MetricName metricName = $this.exemptMetricName();
        if (sensor == null) {
            throw null;
        }
        sensor.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
    }

    private static final double nonExemptThreadUsageLimit$1(double nonExemptUsage, double totalUsage, double totalCapacity) {
        double exemptUsage = totalUsage - nonExemptUsage;
        double nonExemptCapacity = totalCapacity * BrokerBackpressureConfig$.MODULE$.DefaultMaxResourceUtilization() - exemptUsage;
        double minNonExemptCapacity = totalCapacity * BrokerBackpressureConfig$.MODULE$.DefaultMinNonExemptRequestUtilization();
        return package$.MODULE$.max(nonExemptCapacity, minNonExemptCapacity);
    }

    public ClientRequestQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> clientQuotaCallback, Option<ActiveTenantsManager> activeTenantsManager) {
        this.config = config;
        this.metrics = metrics;
        this.threadNamePrefix = threadNamePrefix;
        this.clientQuotaCallback = clientQuotaCallback;
        super(config, metrics, QuotaType$Request$.MODULE$, time, threadNamePrefix, clientQuotaCallback, activeTenantsManager, (Option<AbstractQuotaChannelManager>)None$.MODULE$);
        this.threadUsageSensors = new ThreadUsageSensors(metrics);
        this.lastLimitCorrection = 0.0;
        super.updateClientQuotaMaxThrottleTimeMs(TimeUnit.SECONDS.toMillis(config.quotaWindowSizeSeconds()));
        this.exemptMetricName = metrics.metricName("exempt-request-time", "Request", "Tracking exempt-request-time utilization percentage");
        this.exemptSensor = this.getOrCreateSensor(ClientRequestQuotaManager$.MODULE$.kafka$server$ClientRequestQuotaManager$$ExemptSensorName(), ClientRequestQuotaManager$.MODULE$.DefaultInactiveExemptSensorExpirationTimeSeconds(), (Function1<Sensor, BoxedUnit>)(Function1 & Serializable)sensor -> {
            ClientRequestQuotaManager.$anonfun$exemptSensor$1(this, sensor);
            return BoxedUnit.UNIT;
        });
    }
}

