/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.server.AbstractFetcherThread;
import kafka.server.FullPartitionFetchMetadata;
import kafka.server.KafkaConfig;
import kafka.server.LeaderEndPoint;
import kafka.server.PartitionFetchMetadata;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory$UnboundedQuota$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.TierOffsetInfo;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.FetchParams;
import org.apache.kafka.storage.internals.log.FetchPartitionData;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\t\u0005b\u0001B\u0010!\u0001\u0015B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u001d\u0001\u0006A1A\u0005\nECa!\u0016\u0001!\u0002\u0013\u0011\u0006b\u0002,\u0001\u0005\u0004%Ia\u0016\u0005\u0007A\u0002\u0001\u000b\u0011\u0002-\t\u000f\u0005\u0004!\u0019!C\u0005/\"1!\r\u0001Q\u0001\naCqa\u0019\u0001A\u0002\u0013%A\rC\u0004t\u0001\u0001\u0007I\u0011\u0002;\t\ri\u0004\u0001\u0015)\u0003f\u0011\u0015Y\b\u0001\"\u0011}\u0011\u001d\t\t\u0001\u0001C!\u0003\u0007Aq!!\u0002\u0001\t\u0003\n\u0019\u0001C\u0004\u0002\b\u0001!\t%!\u0003\t\u000f\u0005-\u0001\u0001\"\u0011\u0002\u000e!9\u00111\b\u0001\u0005B\u0005u\u0002bBA*\u0001\u0011\u0005\u0013Q\u000b\u0005\b\u0003G\u0002A\u0011IA3\u0011\u001d\tY\u0007\u0001C!\u0003[Bq!a\u001d\u0001\t\u0003\n)\bC\u0004\u00022\u0002!\t%a-\t\u000f\u0005U\u0007\u0001\"\u0003\u0002X\"9\u0011Q\u001d\u0001\u0005\n\u0005\u001d\bb\u0002B\u0001\u0001\u0011%!1\u0001\u0005\b\u0005\u000f\u0001A\u0011\tB\u0005\u0011\u001d\u0011i\u0001\u0001C!\u0005\u001f\u00111\u0003T8dC2dU-\u00193fe\u0016sG\rU8j]RT!!\t\u0012\u0002\rM,'O^3s\u0015\u0005\u0019\u0013!B6bM.\f7\u0001A\n\u0005\u0001\u0019b\u0003\u0007\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003F\u0001\u0004B]f\u0014VM\u001a\t\u0003[9j\u0011\u0001I\u0005\u0003_\u0001\u0012a\u0002T3bI\u0016\u0014XI\u001c3Q_&tG\u000f\u0005\u00022i5\t!G\u0003\u00024E\u0005)Q\u000f^5mg&\u0011QG\r\u0002\b\u0019><w-\u001b8h\u00031\u0019x.\u001e:dK\n\u0013xn[3s!\tA4(D\u0001:\u0015\tQ$%A\u0004dYV\u001cH/\u001a:\n\u0005qJ$A\u0004\"s_.,'/\u00128e!>Lg\u000e^\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003[}J!\u0001\u0011\u0011\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\ti3)\u0003\u0002EA\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018!B9v_R\f\u0007CA\u0017H\u0013\tA\u0005E\u0001\u0007SKBd\u0017nY1Rk>$\u0018-\u0001\u0004=S:LGO\u0010\u000b\u0006\u00172kej\u0014\t\u0003[\u0001AQAN\u0003A\u0002]BQ!P\u0003A\u0002yBQ!Q\u0003A\u0002\tCQ!R\u0003A\u0002\u0019\u000b\u0011B]3qY&\u001c\u0017-\u00133\u0016\u0003I\u0003\"aJ*\n\u0005QC#aA%oi\u0006Q!/\u001a9mS\u000e\f\u0017\n\u001a\u0011\u0002\u00115\f\u0007PQ=uKN,\u0012\u0001\u0017\t\u00033zk\u0011A\u0017\u0006\u00037r\u000bA\u0001\\1oO*\tQ,\u0001\u0003kCZ\f\u0017BA0[\u0005\u001dIe\u000e^3hKJ\f\u0011\"\\1y\u0005f$Xm\u001d\u0011\u0002\u0013\u0019,Go\u00195TSj,\u0017A\u00034fi\u000eD7+\u001b>fA\u0005\u0019\u0012N\u001c)s_\u001e\u0014Xm]:QCJ$\u0018\u000e^5p]V\tQ\rE\u0002(M\"L!a\u001a\u0015\u0003\r=\u0003H/[8o!\tI\u0017/D\u0001k\u0015\tYG.\u0001\u0004d_6lwN\u001c\u0006\u0003G5T!A\\8\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0018aA8sO&\u0011!O\u001b\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003]Ig\u000e\u0015:pOJ,7o\u001d)beRLG/[8o?\u0012*\u0017\u000f\u0006\u0002vqB\u0011qE^\u0005\u0003o\"\u0012A!\u00168ji\"9\u00110DA\u0001\u0002\u0004)\u0017a\u0001=%c\u0005!\u0012N\u001c)s_\u001e\u0014Xm]:QCJ$\u0018\u000e^5p]\u0002\nA$[:UeVt7-\u0019;j_:|eNR3uG\"\u001cV\u000f\u001d9peR,G-F\u0001~!\t9c0\u0003\u0002\u0000Q\t9!i\\8mK\u0006t\u0017!D5oSRL\u0017\r^3DY>\u001cX\rF\u0001v\u0003\u0015\u0019Gn\\:f\u00039\u0011'o\\6fe\u0016sG\rU8j]R$\u0012aN\u0001\u0006M\u0016$8\r\u001b\u000b\u0005\u0003\u001f\t\u0019\u0003E\u0004\u0002\u0012\u0005]\u0001.a\u0007\u000e\u0005\u0005M!bAA\u000bQ\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u00111\u0003\u0002\u0004\u001b\u0006\u0004\b\u0003BA\u000f\u0003?i\u0011\u0001A\u0005\u0004\u0003Cq#!\u0003$fi\u000eDG)\u0019;b\u0011\u001d\t)c\u0005a\u0001\u0003O\tABZ3uG\"\u0014V-];fgR\u0004B!!\u000b\u000269!\u00111FA\u0019\u001b\t\tiCC\u0002\u00020)\f\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003g\ti#\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0003\u0003\u00028\u0005e\"a\u0002\"vS2$WM\u001d\u0006\u0005\u0003g\ti#A\ngKR\u001c\u0007.R1sY&,7\u000f^(gMN,G\u000f\u0006\u0004\u0002@\u0005-\u0013q\n\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u00191.!\u0012\u000b\u0005\u0005b\u0017\u0002BA%\u0003\u0007\u0012ab\u00144gg\u0016$\u0018I\u001c3Fa>\u001c\u0007\u000e\u0003\u0004\u0002NQ\u0001\r\u0001[\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\t\t\u0006\u0006a\u0001%\u0006\u00112-\u001e:sK:$H*Z1eKJ,\u0005o\\2i\u0003y1W\r^2i)&,'/T1uKJL\u0017\r\\5{CRLwN\u001c+be\u001e,G\u000f\u0006\u0004\u0002X\u0005u\u0013q\f\t\u0004[\u0005e\u0013bAA.A\tqA+[3s\u001f\u001a47/\u001a;J]\u001a|\u0007BBA'+\u0001\u0007\u0001\u000e\u0003\u0004\u0002bU\u0001\rAU\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007.A\tgKR\u001c\u0007\u000eT1uKN$xJ\u001a4tKR$b!a\u0010\u0002h\u0005%\u0004BBA'-\u0001\u0007\u0001\u000e\u0003\u0004\u0002RY\u0001\rAU\u0001\u0019M\u0016$8\r[#be2LWm\u001d;M_\u000e\fGn\u00144gg\u0016$HCBA \u0003_\n\t\b\u0003\u0004\u0002N]\u0001\r\u0001\u001b\u0005\u0007\u0003#:\u0002\u0019\u0001*\u0002)\u0019,Go\u00195Fa>\u001c\u0007.\u00128e\u001f\u001a47/\u001a;t)\u0011\t9(!*\u0011\u000f\u0005E\u0011q\u00035\u0002zA!\u00111PAP\u001d\u0011\ti(!'\u000f\t\u0005}\u0014Q\u0013\b\u0005\u0003\u0003\u000b\u0019J\u0004\u0003\u0002\u0004\u0006Ee\u0002BAC\u0003\u001fsA!a\"\u0002\u000e6\u0011\u0011\u0011\u0012\u0006\u0004\u0003\u0017#\u0013A\u0002\u001fs_>$h(C\u0001q\u0013\tqw.\u0003\u0002$[&\u00111\u000e\\\u0005\u0004\u0003/S\u0017aB7fgN\fw-Z\u0005\u0005\u00037\u000bi*\u0001\u0011PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r\u001b*fgB|gn]3ECR\f'bAALU&!\u0011\u0011UAR\u00059)\u0005o\\2i\u000b:$wJ\u001a4tKRTA!a'\u0002\u001e\"9\u0011q\u0015\rA\u0002\u0005%\u0016A\u00039beRLG/[8ogB9\u0011\u0011CA\fQ\u0006-\u0006\u0003BA\u000f\u0003[K1!a,/\u0005%)\u0005o\\2i\t\u0006$\u0018-\u0001\u0006ck&dGMR3uG\"$B!!.\u0002LB1\u0011qWA_\u0003\u0007t1!LA]\u0013\r\tY\fI\u0001\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0013\u0011\ty,!1\u0003)I+7/\u001e7u/&$\b\u000eU1si&$\u0018n\u001c8t\u0015\r\tY\f\t\t\u0005O\u0019\f)\r\u0005\u0003\u00028\u0006\u001d\u0017\u0002BAe\u0003\u0003\u0014ABU3qY&\u001c\u0017MR3uG\"Dq!a*\u001a\u0001\u0004\ti\rE\u0004\u0002\u0012\u0005]\u0001.a4\u0011\u00075\n\t.C\u0002\u0002T\u0002\u00121\u0003U1si&$\u0018n\u001c8GKR\u001c\u0007n\u0015;bi\u0016\fac]3mK\u000e$\b+\u0019:uSRLwN\u001c+p\r\u0016$8\r\u001b\u000b\u0005\u00033\f\t\u000f\u0005\u0003(M\u0006m\u0007CB\u0014\u0002^\"\fy-C\u0002\u0002`\"\u0012a\u0001V;qY\u0016\u0014\u0004bBAr5\u0001\u0007\u0011QZ\u0001\ra\u0006\u0014H/\u001b;j_:l\u0015\r]\u0001\u0017EVLG\u000e\u001a$fi\u000eDgi\u001c:QCJ$\u0018\u000e^5p]R1\u0011\u0011^A}\u0003{\u0004b!a;\u0002>\u0006Uh\u0002BAw\u0003ssA!a<\u0002t:!\u0011qQAy\u0013\u0005\u0019\u0013BA\u0011#!\u00119c-a>\u0011\t\u0005-\u0018q\u0019\u0005\u0007\u0003w\\\u0002\u0019\u00015\u0002\u0005Q\u0004\bbBA\u00007\u0001\u0007\u0011qZ\u0001\u000bM\u0016$8\r[*uCR,\u0017A\u00058fqR\u0014V-\u00193z!\u0006\u0014H/\u001b;j_:$B!!7\u0003\u0006!9\u00111\u001d\u000fA\u0002\u00055\u0017aD5t%\u0016\fG-\u001f$pe\u001a+Go\u00195\u0015\u0007u\u0014Y\u0001\u0003\u0004\u0002|v\u0001\r\u0001[\u0001\ti>\u001cFO]5oOR\u0011!\u0011\u0003\t\u0005\u0005'\u0011YB\u0004\u0003\u0003\u0016\t]\u0001cAADQ%\u0019!\u0011\u0004\u0015\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011iBa\b\u0003\rM#(/\u001b8h\u0015\r\u0011I\u0002\u000b")
public class LocalLeaderEndPoint
implements LeaderEndPoint,
Logging {
    private final BrokerEndPoint sourceBroker;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private final int replicaId;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private Option<TopicPartition> inProgressPartition;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int replicaId() {
        return this.replicaId;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    private Option<TopicPartition> inProgressPartition() {
        return this.inProgressPartition;
    }

    private void inProgressPartition_$eq(Option<TopicPartition> x$1) {
        this.inProgressPartition = x$1;
    }

    @Override
    public boolean isTruncationOnFetchSupported() {
        return false;
    }

    @Override
    public void initiateClose() {
    }

    @Override
    public void close() {
    }

    @Override
    public BrokerEndPoint brokerEndPoint() {
        return this.sourceBroker;
    }

    @Override
    public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
        ObjectRef partitionData = ObjectRef.create(null);
        FetchRequest request = (FetchRequest)fetchRequest.build();
        HashMap topicNames = new HashMap();
        request.data().topics().forEach(topic -> topicNames.put((Object)topic.topicId(), (Object)topic.topic()));
        ArrayBuffer partitions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        request.data().topics().forEach(topic -> {
            String name = request.version() < 13 ? topic.topic() : (String)topicNames.apply((Object)topic.topicId());
            topic.partitions().forEach(partition -> partitions.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition(topic.topicId(), partition.partition(), name)), (Object)new FullPartitionFetchMetadata(topic.topicId(), partition.fetchOffset(), partition.logStartOffset(), partition.partitionMaxBytes(), RequestUtils.getLeaderEpoch((int)partition.currentLeaderEpoch()), RequestUtils.getLeaderEpoch((int)partition.lastFetchedEpoch()), -1L))));
        });
        FetchParams fetchParams = new FetchParams(request.version(), -3, -1L, 0L, request.minBytes(), request.maxBytes(), FetchIsolation.LOG_END, Optional.empty());
        this.replicaManager.fetchMessages(fetchParams, (Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>>)partitions, QuotaFactory$UnboundedQuota$.MODULE$, (Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>)(Function1 & Serializable)responsePartitionData -> {
            LocalLeaderEndPoint.processResponseCallback$1(responsePartitionData, partitionData);
            return BoxedUnit.UNIT;
        }, false);
        if ((Seq)partitionData.elem == null) {
            throw new IllegalStateException(new StringBuilder(36).append("Failed to fetch data for partitions ").append(((IterableOnceOps)partitions.map((Function1 & Serializable)x$1 -> (TopicIdPartition)x$1._1())).mkString(",")).toString());
        }
        return ((Seq)partitionData.elem).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public OffsetAndEpoch fetchEarliestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        Partition partition = this.replicaManager.getPartitionOrException(topicPartition);
        long logStartOffset = partition.localLogOrException().logStartOffset();
        OptionalInt epoch = ((LeaderEpochFileCache)partition.localLogOrException().leaderEpochCache().get()).epochForOffset(logStartOffset);
        return new OffsetAndEpoch(logStartOffset, epoch.orElseGet(() -> 0));
    }

    @Override
    public TierOffsetInfo fetchTierMaterializationTarget(TopicPartition topicPartition, int leaderEpoch) {
        throw new UnsupportedOperationException("Local leader endpoint does not support tiered partitions");
    }

    @Override
    public OffsetAndEpoch fetchLatestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        Partition partition = this.replicaManager.getPartitionOrException(topicPartition);
        long logEndOffset = partition.localLogOrException().logEndOffset();
        OptionalInt epoch = ((LeaderEpochFileCache)partition.localLogOrException().leaderEpochCache().get()).epochForOffset(logEndOffset);
        return new OffsetAndEpoch(logEndOffset, epoch.orElseGet(() -> 0));
    }

    @Override
    public OffsetAndEpoch fetchEarliestLocalOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        throw new UnsupportedOperationException("Fetching earliest local offset is not supported in Local Leader Endpoint.");
    }

    @Override
    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        return (Map)partitions.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData = (OffsetForLeaderEpochRequestData.OffsetForLeaderPartition)x0$1._2();
                try {
                    OffsetForLeaderEpochResponseData.EpochEndOffset endOffset = epochData.leaderEpoch() == -1 ? new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(Errors.NONE.code()) : $this.replicaManager.getPartitionOrException(tp).lastOffsetForLeaderEpoch(RequestUtils.getLeaderEpoch((int)epochData.currentLeaderEpoch()), epochData.leaderEpoch(), false);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)endOffset);
                }
                catch (Throwable t) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Error when getting EpochEndOffset for ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(Errors.forException((Throwable)t).code()));
                }
            }
            throw new MatchError(null);
        });
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitions) {
        Tuple2 tuple2;
        if (this.quota.isQuotaExceeded()) {
            return new AbstractFetcherThread.ResultWithPartitions<None$>(None$.MODULE$, (Map<TopicPartition, Errors>)((Map)scala.collection.Map$.MODULE$.empty()));
        }
        Option<Tuple2<TopicPartition, PartitionFetchState>> option = this.selectPartitionToFetch(partitions);
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
            return this.buildFetchForPartition(tp, fetchState);
        }
        if (None$.MODULE$.equals(option)) {
            return new AbstractFetcherThread.ResultWithPartitions<None$>(None$.MODULE$, (Map<TopicPartition, Errors>)((Map)scala.collection.Map$.MODULE$.empty()));
        }
        throw new MatchError(option);
    }

    /*
     * WARNING - void declaration
     */
    private Option<Tuple2<TopicPartition, PartitionFetchState>> selectPartitionToFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        Object object = new Object();
        try {
            void var3_3;
            this.inProgressPartition().foreach((Function1 & Serializable)tp -> {
                LocalLeaderEndPoint.$anonfun$selectPartitionToFetch$1(partitionMap, object, tp);
                return BoxedUnit.UNIT;
            });
            this.inProgressPartition_$eq((Option<TopicPartition>)None$.MODULE$);
            Option<Tuple2<TopicPartition, PartitionFetchState>> nextPartitionOpt = this.nextReadyPartition(partitionMap);
            nextPartitionOpt.foreach((Function1 & Serializable)x0$1 -> {
                LocalLeaderEndPoint.$anonfun$selectPartitionToFetch$4(this, partitionMap, x0$1);
                return BoxedUnit.UNIT;
            });
            return var3_3;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (Option)ex.value();
            }
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetchForPartition(TopicPartition tp, PartitionFetchState fetchState) {
        None$ none$;
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        scala.collection.mutable.Map partitionsWithError = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        try {
            long logStartOffset = this.replicaManager.futureLocalLogOrException(tp).logStartOffset();
            Optional lastFetchedEpoch = this.isTruncationOnFetchSupported() ? OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(fetchState.lastFetchedEpoch().map((Function1 & Serializable)x$3 -> LocalLeaderEndPoint.$anonfun$buildFetchForPartition$1(BoxesRunTime.unboxToInt((Object)x$3))))) : Optional.empty();
            Uuid topicId = (Uuid)fetchState.topicId().getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID);
            requestMap.put(tp, new FetchRequest.PartitionData(topicId, fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(fetchState.replicationSessionId().map((Function1 & Serializable)x$4 -> LocalLeaderEndPoint.$anonfun$buildFetchForPartition$3(BoxesRunTime.unboxToLong((Object)x$4))))), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch())), lastFetchedEpoch));
        }
        catch (KafkaStorageException e) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("Failed to build fetch for ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            partitionsWithError.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Errors.KAFKA_STORAGE_ERROR));
        }
        if (requestMap.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            void forReplica_minBytes;
            void forReplica_maxWait;
            void forReplica_replicaEpoch;
            short version = fetchState.topicId().isEmpty() ? (short)12 : (short)ApiKeys.FETCH.latestVersion();
            boolean bl = false;
            boolean bl2 = false;
            long l = -1L;
            int forReplica_replicaId = this.replicaId();
            FetchRequest.Builder requestBuilder = new FetchRequest.Builder(version, version, forReplica_replicaId, (long)forReplica_replicaEpoch, (int)forReplica_maxWait, (int)forReplica_minBytes, requestMap).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes()));
            none$ = new Some((Object)new AbstractFetcherThread.ReplicaFetch(requestMap, requestBuilder));
        }
        None$ fetchRequestOpt = none$;
        return new AbstractFetcherThread.ResultWithPartitions<None$>(fetchRequestOpt, (Map<TopicPartition, Errors>)partitionsWithError);
    }

    private Option<Tuple2<TopicPartition, PartitionFetchState>> nextReadyPartition(Map<TopicPartition, PartitionFetchState> partitionMap) {
        return ((IterableOnceOps)partitionMap.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LocalLeaderEndPoint.$anonfun$nextReadyPartition$1(x0$1)))).reduceLeftOption((Function2 & Serializable)(left, right) -> {
            block3: {
                block2: {
                    if (StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(((TopicPartition)left._1()).topic()), ((TopicPartition)right._1()).topic())) break block2;
                    String string = ((TopicPartition)left._1()).topic();
                    String string2 = ((TopicPartition)right._1()).topic();
                    if ((string != null ? !string.equals(string2) : string2 != null) || ((TopicPartition)left._1()).partition() >= ((TopicPartition)right._1()).partition()) break block3;
                }
                return left;
            }
            return right;
        });
    }

    @Override
    public boolean isReadyForFetch(TopicPartition tp) {
        return true;
    }

    public String toString() {
        return "LocalLeaderEndPoint";
    }

    private static final void processResponseCallback$1(Seq responsePartitionData, ObjectRef partitionData$1) {
        partitionData$1.elem = (Seq)responsePartitionData.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicIdPartition tp = (TopicIdPartition)x0$1._1();
                FetchPartitionData data = (FetchPartitionData)x0$1._2();
                List abortedTransactions = data.abortedTransactions.orElse(null);
                long lastStableOffset = data.lastStableOffset.orElse(-1L);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topicPartition()), (Object)new FetchResponseData.PartitionData().setPartitionIndex(tp.topicPartition().partition()).setErrorCode(data.error.code()).setHighWatermark(data.highWatermark).setLastStableOffset(lastStableOffset).setLogStartOffset(data.logStartOffset).setAbortedTransactions(abortedTransactions).setRecords((BaseRecords)data.records));
            }
            throw new MatchError(null);
        });
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$1(Map partitionMap$1, Object nonLocalReturnKey1$1, TopicPartition tp) {
        partitionMap$1.get((Object)tp).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isReadyForFetch())).foreach((Function1 & Serializable)fetchState -> {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new Tuple2((Object)tp, fetchState)));
        });
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$4(LocalLeaderEndPoint $this, Map partitionMap$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            PartitionFetchState fetchState = (PartitionFetchState)x0$1._2();
            $this.inProgressPartition_$eq((Option<TopicPartition>)new Some((Object)tp));
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(133).append("Beginning/resuming copy of partition ").append(tp).append(" from offset ").append(fetchState.fetchOffset()).append(". ").append("Including this partition, there are ").append(partitionMap$1.size()).append(" remaining partitions to copy by this thread.").toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Integer $anonfun$buildFetchForPartition$1(int x$3) {
        return BoxesRunTime.boxToInteger((int)x$3);
    }

    public static final /* synthetic */ Long $anonfun$buildFetchForPartition$3(long x$4) {
        return BoxesRunTime.boxToLong((long)x$4);
    }

    public static final /* synthetic */ boolean $anonfun$nextReadyPartition$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((PartitionFetchState)x0$1._2()).isReadyForFetch();
        }
        throw new MatchError(null);
    }

    public LocalLeaderEndPoint(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, ReplicaManager replicaManager, ReplicaQuota quota) {
        this.sourceBroker = sourceBroker;
        this.replicaManager = replicaManager;
        this.quota = quota;
        this.replicaId = brokerConfig.brokerId();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.inProgressPartition = None$.MODULE$;
    }
}

