/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.IOException;
import java.io.Serializable;
import kafka.server.link.ClusterLinkFilter;
import kafka.server.link.ClusterLinkFilterJson;
import kafka.server.link.ClusterLinkGroupFilterJsonValidator;
import kafka.server.link.ClusterLinkTopicFilterJsonValidator;
import kafka.server.link.FilterType$;
import kafka.server.link.GroupClusterLinkFilter;
import kafka.server.link.GroupFilterJson;
import kafka.server.link.TopicFilterJson;
import kafka.server.link.TopicType$;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.utils.SecurityUtils;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;

public final class ClusterLinkFilterJson$ {
    public static final ClusterLinkFilterJson$ MODULE$ = new ClusterLinkFilterJson$();
    private static final ClusterLinkTopicFilterJsonValidator TOPIC_VALIDATOR = new ClusterLinkTopicFilterJsonValidator();
    private static final ClusterLinkGroupFilterJsonValidator GROUP_VALIDATOR = new ClusterLinkGroupFilterJsonValidator();
    private static final ObjectMapper JSON_SERDE = new ObjectMapper();

    static {
        MODULE$.JSON_SERDE().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        MODULE$.JSON_SERDE().registerModule((Module)DefaultScalaModule$.MODULE$);
    }

    public ClusterLinkTopicFilterJsonValidator TOPIC_VALIDATOR() {
        return TOPIC_VALIDATOR;
    }

    public ClusterLinkGroupFilterJsonValidator GROUP_VALIDATOR() {
        return GROUP_VALIDATOR;
    }

    public ObjectMapper JSON_SERDE() {
        return JSON_SERDE;
    }

    public Option<TopicFilterJson> parseTopic(String value) {
        Option<TopicFilterJson> parsed = this.parse(value, TopicFilterJson.class);
        parsed.foreach((Function1 & Serializable)x$2 -> {
            ClusterLinkFilterJson$.MODULE$.validate(x$2);
            return BoxedUnit.UNIT;
        });
        return parsed;
    }

    public Option<GroupFilterJson> parseGroup(String value) {
        Option<GroupFilterJson> parsed = this.parse(value, GroupFilterJson.class);
        parsed.foreach((Function1 & Serializable)groupFilters -> {
            ClusterLinkFilterJson$.$anonfun$parseGroup$1(groupFilters);
            return BoxedUnit.UNIT;
        });
        return parsed;
    }

    private <T extends ClusterLinkFilterJson> Option<T> parse(String value, Class<T> c) {
        if (value == null || value.trim().isEmpty()) {
            return Option$.MODULE$.empty();
        }
        try {
            ObjectMapper JSON_SERDE = new ObjectMapper();
            JSON_SERDE.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
            JSON_SERDE.registerModule((Module)DefaultScalaModule$.MODULE$);
            ClusterLinkFilterJson filterJson = (ClusterLinkFilterJson)JSON_SERDE.readValue(value, c);
            return new Some((Object)filterJson);
        }
        catch (Throwable throwable) {
            if (throwable instanceof IOException ? true : (throwable instanceof JsonMappingException ? true : throwable instanceof JsonParseException)) {
                throw new IllegalArgumentException(new StringBuilder(37).append("Exception while parsing filter JSON: ").append(throwable).toString());
            }
            throw throwable;
        }
    }

    private void validate(ClusterLinkFilterJson filterJson) {
        if (filterJson.filters() == null) {
            throw new IllegalArgumentException("ClusterLinkFilters cannot be the JSON null");
        }
        filterJson.filters().foreach((Function1 & Serializable)filter -> {
            ClusterLinkFilterJson$.$anonfun$validate$1(filter);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$parseGroup$3(String topicType) {
        if (TopicType$.MODULE$.fromString(topicType).isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(20).append("Unknown topic type: ").append(topicType).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$parseGroup$2(GroupClusterLinkFilter filter) {
        if (filter.topicTypes() != null) {
            Seq<String> topicTypes = filter.topicTypes();
            if (topicTypes.isEmpty()) {
                throw new IllegalArgumentException("topicTypes cannot be empty");
            }
            topicTypes.foreach((Function1 & Serializable)topicType -> {
                ClusterLinkFilterJson$.$anonfun$parseGroup$3(topicType);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$parseGroup$1(GroupFilterJson groupFilters) {
        MODULE$.validate(groupFilters);
        groupFilters.filters().foreach((Function1 & Serializable)filter -> {
            ClusterLinkFilterJson$.$anonfun$parseGroup$2(filter);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$validate$1(ClusterLinkFilter filter) {
        block11: {
            String patternType;
            block10: {
                PatternType patternType2;
                PatternType patternType3;
                block9: {
                    String filterType = filter.filterType();
                    if (filterType == null) {
                        throw new IllegalArgumentException("filterType field may not be null.");
                    }
                    if (FilterType$.MODULE$.fromString(filterType).isEmpty()) {
                        throw new IllegalArgumentException(new StringBuilder(20).append("Unknown filterType: ").append(filterType).toString());
                    }
                    patternType = filter.patternType();
                    if (patternType == null) {
                        throw new IllegalArgumentException("patternType field may not be null.");
                    }
                    if (patternType.isEmpty()) {
                        throw new IllegalArgumentException("patternType field may not be empty.");
                    }
                    patternType3 = SecurityUtils.patternType((String)patternType);
                    patternType2 = PatternType.UNKNOWN;
                    if (patternType3 != null) break block9;
                    if (patternType2 != null) {
                        return;
                    }
                    break block10;
                }
                if (!patternType3.equals(patternType2)) break block11;
            }
            throw new IllegalArgumentException(new StringBuilder(21).append("Unknown patternType: ").append(patternType).toString());
        }
    }

    private ClusterLinkFilterJson$() {
    }
}

