/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.NodeToControllerChannelManager;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkControllerRequestCompletionHandler;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.AlterMirrorTopicsRequestData;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterMirrorTopicsRequest;
import org.apache.kafka.common.requests.AlterMirrorTopicsResponse;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.ClusterLink;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.immutable.ImmutableMap;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u0005g\u0001B\u0015+\u0001EB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!Iq\b\u0001B\u0001B\u0003%\u0001I\u0012\u0005\n\u000f\u0002\u0011\t\u0011)A\u0005\u0011.C\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\tA\u0002\u0011\t\u0011)A\u0005C\")\u0001\u000e\u0001C\u0001S\")\u0011\u000f\u0001C!e\"9\u0011\u0011\u0003\u0001\u0005\n\u0005M\u0001bBA\t\u0001\u0011%\u00111\u0007\u0005\b\u0003\u000b\u0002A\u0011IA$\u0011\u001d\ti\u0005\u0001C!\u0003\u001fBq!!\u0014\u0001\t\u0003\n\u0019\u0006C\u0004\u0002N\u0001!\t%a\u0016\t\u000f\u0005e\u0003\u0001\"\u0011\u0002\\!9\u0011\u0011\f\u0001\u0005B\u0005}\u0003bBA-\u0001\u0011\u0005\u0013q\u000b\u0005\b\u0003G\u0002A\u0011IA3\u0011\u001d\t9\u0007\u0001C!\u0003SBq!a\u001d\u0001\t\u0003\n)\bC\u0004\u0002\u0000\u0001!\t%!!\t\u000f\u0005\u0015\u0005\u0001\"\u0011\u0002\b\"9\u0011Q\u0011\u0001\u0005\u0002\u0005e\u0005bBAP\u0001\u0011\u0005\u0013\u0011\u0015\u0005\b\u0003k\u0003A\u0011IA\\\u0011\u001d\tY\f\u0001C!\u0003{Cq!!5\u0001\t\u0003\n\u0019\u000eC\u0004\u0002b\u0002!\t%a9\t\u000f\u00055\b\u0001\"\u0011\u0002p\"9\u00111\u001f\u0001\u0005B\u0005U\b\"\u0003B\u000b\u0001E\u0005I\u0011\u0001B\f\u0011%\u0011i\u0003AI\u0001\n\u0003\u00119\u0002C\u0005\u00030\u0001\t\n\u0011\"\u0001\u00032!I!Q\u0007\u0001\u0012\u0002\u0013\u0005!q\u0007\u0005\b\u0005w\u0001A\u0011\tB\u001f\u0011\u001d\u0011\t\u0005\u0001C\u0005\u0005\u0007BqA!\u0019\u0001\t\u0013\u0011\u0019\u0007C\u0004\u0003\u001e\u0002!\tEa(\t\u000f\tM\u0006\u0001\"\u0011\u00036\"i!q\u0017\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0003:\u001a\u0013!f\u00117vgR,'\u000fT5oW6+G/\u00193bi\u0006l\u0015M\\1hKJ<\u0016\u000e\u001e5L%\u00064GoU;qa>\u0014HO\u0003\u0002,Y\u0005!A.\u001b8l\u0015\tic&\u0001\u0004tKJ4XM\u001d\u0006\u0002_\u0005)1.\u00194lC\u000e\u00011C\u0001\u00013!\t\u0019D'D\u0001+\u0013\t)$F\u0001\u000eDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0001\u0007ce>\\WM]\"p]\u001aLw\r\u0005\u00029s5\tA&\u0003\u0002;Y\tY1*\u00194lC\u000e{gNZ5h\u0003%\u00198\r[3ek2,'\u000f\u0005\u00024{%\u0011aH\u000b\u0002\u0015\u00072,8\u000f^3s\u0019&t7nU2iK\u0012,H.\u001a:\u0002\u001b5,G/\u00193bi\u0006\u001c\u0015m\u00195f!\t\tE)D\u0001C\u0015\t\u0019E&\u0001\u0005nKR\fG-\u0019;b\u0013\t)%I\u0001\nL%\u00064G/T3uC\u0012\fG/Y\"bG\",\u0017BA 5\u0003a\u0019wN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM\u001d\t\u0003q%K!A\u0013\u0017\u0003=9{G-\u001a+p\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\u0018BA$5\u0003EawnY1m\u0003\u0012l\u0017N\u001c$bGR|'/\u001f\t\u0004\u001dF\u001bV\"A(\u000b\u0003A\u000bQa]2bY\u0006L!AU(\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004C\u0001+_\u001b\u0005)&B\u0001,X\u0003\u0015\tG-\\5o\u0015\tA\u0016,A\u0004dY&,g\u000e^:\u000b\u0005=R&BA.]\u0003\u0019\t\u0007/Y2iK*\tQ,A\u0002pe\u001eL!aX+\u0003\u000b\u0005#W.\u001b8\u0002\u0015M,'O^3s\u0013:4w\u000e\u0005\u0002cM6\t1M\u0003\u0002eK\u0006Q\u0011-\u001e;i_JL'0\u001a:\u000b\u00055J\u0016BA4d\u0005Q\tU\u000f\u001e5pe&TXM]*feZ,'/\u00138g_\u00061A(\u001b8jiz\"rA[6m[:|\u0007\u000f\u0005\u00024\u0001!)ag\u0002a\u0001o!)1h\u0002a\u0001y!)qh\u0002a\u0001\u0001\")qi\u0002a\u0001\u0011\")Aj\u0002a\u0001\u001b\")\u0001m\u0002a\u0001C\u0006YQ.\u001b:s_J$v\u000e]5d)\t\u00198\u0010E\u0002OiZL!!^(\u0003\r=\u0003H/[8o!\t9\u00180D\u0001y\u0015\t\u0019\u0015,\u0003\u0002{q\nYQ*\u001b:s_J$v\u000e]5d\u0011\u0015a\b\u00021\u0001~\u0003\u0015!x\u000e]5d!\rq\u00181\u0002\b\u0004\u007f\u0006\u001d\u0001cAA\u0001\u001f6\u0011\u00111\u0001\u0006\u0004\u0003\u000b\u0001\u0014A\u0002\u001fs_>$h(C\u0002\u0002\n=\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0007\u0003\u001f\u0011aa\u0015;sS:<'bAA\u0005\u001f\u0006\tR.\u001b:s_J$v\u000e]5d'R\fG/Z:\u0015\t\u0005U\u0011q\u0005\t\b\u0003/\ti\"`A\u0011\u001b\t\tIBC\u0002\u0002\u001c=\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty\"!\u0007\u0003\u00075\u000b\u0007\u000fE\u00024\u0003GI1!!\n+\u0005U\u0019E.^:uKJd\u0015N\\6U_BL7m\u0015;bi\u0016Dq!!\u000b\n\u0001\u0004\tY#A\u0005u_BL7m](qiB!a\n^A\u0017!\u0011q\u0018qF?\n\t\u0005E\u0012q\u0002\u0002\u0004'\u0016$H\u0003BA\u000b\u0003kAq!a\u000e\u000b\u0001\u0004\tI$\u0001\u0004mS:\\\u0017\n\u001a\t\u0005\u0003w\t\t%\u0004\u0002\u0002>)\u0019\u0011qH-\u0002\r\r|W.\\8o\u0013\u0011\t\u0019%!\u0010\u0003\tU+\u0018\u000eZ\u0001#[&\u0014(o\u001c:U_BL7m\u0015;bi\u0016\u001chI]8n\u001b\u0016$\u0018\rZ1uCN#xN]3\u0015\t\u0005U\u0011\u0011\n\u0005\b\u0003\u0017Z\u0001\u0019AA\u0017\u0003\u0019!x\u000e]5dg\u0006\u0011S.\u001b:s_J$v\u000e]5d'R\fG/Z:Ge>lW*\u001a;bI\u0006$\u0018mQ1dQ\u0016$B!!\u0006\u0002R!9\u0011q\u0007\u0007A\u0002\u0005eB\u0003BA\u000b\u0003+Bq!a\u0013\u000e\u0001\u0004\ti\u0003\u0006\u0002\u0002\u0016\u00051S.\u001b:s_J$v\u000e]5d'R\fG/Z:Ge>l7i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0015\t\u0005U\u0011Q\f\u0005\b\u0003oy\u0001\u0019AA\u001d)\u0011\t)\"!\u0019\t\u000f\u0005-\u0003\u00031\u0001\u0002.\u0005)r-\u001a;BY2$v\u000e]5dg&s7\t\\;ti\u0016\u0014HCAA\u0017\u0003iI7\u000fV8qS\u000e\fV/Z;fIV\u0003hi\u001c:EK2,G/[8o)\u0011\tY'!\u001d\u0011\u00079\u000bi'C\u0002\u0002p=\u0013qAQ8pY\u0016\fg\u000eC\u0003}'\u0001\u0007Q0A\ff]N,(/Z\"mkN$XM\u001d'j].,\u00050[:ugR!\u0011qOA?!\rq\u0015\u0011P\u0005\u0004\u0003wz%\u0001B+oSRDq!a\u000e\u0015\u0001\u0004\tI$A\tdYV\u001cH/\u001a:MS:\\W\t_5tiN$B!a\u001b\u0002\u0004\"9\u0011qG\u000bA\u0002\u0005e\u0012AE4fi\u000ecWo\u001d;fe2Kgn\u001b#bi\u0006$B!!#\u0002\u0018B!a\n^AF!\u0011\ti)a%\u000e\u0005\u0005=%bAAI]\u0005\u0011!p[\u0005\u0005\u0003+\u000byIA\bDYV\u001cH/\u001a:MS:\\G)\u0019;b\u0011\u001d\t9D\u0006a\u0001\u0003s!B!!#\u0002\u001c\"1\u0011QT\fA\u0002u\f\u0001\u0002\\5oW:\u000bW.Z\u0001\u001aO\u0016$8\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4Qe>\u00048\u000f\u0006\u0003\u0002$\u0006M\u0006\u0003BAS\u0003_k!!a*\u000b\t\u0005%\u00161V\u0001\u0005kRLGN\u0003\u0002\u0002.\u0006!!.\u0019<b\u0013\u0011\t\t,a*\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0004\u00028a\u0001\r!!\u000f\u0002\u001d\u001d,G\u000fV8qS\u000e\u001cuN\u001c4jOR!\u00111UA]\u0011\u0015a\u0018\u00041\u0001~\u0003m\tG\u000e^3s\u00072,8\u000f^3s\u0019&t7nQ8oM&<'LT8eKRQ\u0011qOA`\u0003\u0003\f\u0019-a2\t\u000f\u0005]\"\u00041\u0001\u0002:!1\u0011Q\u0014\u000eA\u0002uDq!!2\u001b\u0001\u0004\t\u0019+A\bqKJ\u001c\u0018n\u001d;f]R\u0004&o\u001c9t\u0011\u001d\tIM\u0007a\u0001\u0003\u0017\f!\u0002\\5oW\u000e{gNZ5h!\r\u0019\u0014QZ\u0005\u0004\u0003\u001fT#!E\"mkN$XM\u001d'j].\u001cuN\u001c4jO\u0006\u0001S.Y=cKJ+WM\\2ssB$8\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4t)\u0011\t9(!6\t\u000f\u0005]7\u00041\u0001\u0002Z\u0006\t2m\u001c8gS\u001e$&/\u00198tM>\u0014X.\u001a:\u0011\u000f9\u000bY.a)\u0002`&\u0019\u0011Q\\(\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003\u0002(u\u0003G\u000bac\u0019:fCR,7\t\\;ti\u0016\u0014H*\u001b8l5:{G-\u001a\u000b\u0007\u0003o\n)/!;\t\u000f\u0005\u001dH\u00041\u0001\u0002\f\u0006y1\r\\;ti\u0016\u0014H*\u001b8l\t\u0006$\u0018\rC\u0004\u0002lr\u0001\r!a)\u0002\u000bA\u0014x\u000e]:\u0002'M,Go\u00117vgR,'\u000fT5oWjsu\u000eZ3\u0015\t\u0005]\u0014\u0011\u001f\u0005\b\u0003Ol\u0002\u0019AAF\u0003U\tG\u000e^3s\u001b&\u0014(o\u001c:U_BL7m\u0015;bi\u0016$\u0002#a\u001e\u0002x\u0006e(\u0011\u0001B\u0003\u0005\u0013\u0011iA!\u0005\t\u000bqt\u0002\u0019A?\t\u000f\u0005mh\u00041\u0001\u0002~\u0006a1\u000f^1uKV\u0003H-\u0019;feB9a*a7\u0002\"\u0005}\b\u0003\u0002(u\u0003CAqAa\u0001\u001f\u0001\u0004\tY'\u0001\u0007wC2LG-\u0019;f\u001f:d\u0017\u0010C\u0005\u0003\by\u0001\n\u00111\u0001\u0002l\u0005ya-Y5m\u0013\u001atu\u000e^'jeJ|'\u000fC\u0005\u0003\fy\u0001\n\u00111\u0001\u0002l\u0005A\u0012n]\"p]Z,'\u000f\u001e+p!\u0016tG-\u001b8h\u001b&\u0014(o\u001c:\t\u0011\t=a\u0004%AA\u0002u\fqb]8ve\u000e,Gk\u001c9jG:\u000bW.\u001a\u0005\n\u0005'q\u0002\u0013!a\u0001\u0003s\tA#\u001a=qK\u000e$X\r\u001a'pG\u0006dGk\u001c9jG&#\u0017aH1mi\u0016\u0014X*\u001b:s_J$v\u000e]5d'R\fG/\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!\u0011\u0004\u0016\u0005\u0003W\u0012Yb\u000b\u0002\u0003\u001eA!!q\u0004B\u0015\u001b\t\u0011\tC\u0003\u0003\u0003$\t\u0015\u0012!C;oG\",7m[3e\u0015\r\u00119cT\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0016\u0005C\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003}\tG\u000e^3s\u001b&\u0014(o\u001c:U_BL7m\u0015;bi\u0016$C-\u001a4bk2$H%N\u0001 C2$XM]'jeJ|'\u000fV8qS\u000e\u001cF/\u0019;fI\u0011,g-Y;mi\u00122TC\u0001B\u001aU\ri(1D\u0001 C2$XM]'jeJ|'\u000fV8qS\u000e\u001cF/\u0019;fI\u0011,g-Y;mi\u0012:TC\u0001B\u001dU\u0011\tIDa\u0007\u0002-\u0011,G.\u001a;f\u00072,8\u000f^3s\u0019&t7N\u0017(pI\u0016$B!a\u001e\u0003@!9\u0011qG\u0012A\u0002\u0005e\u0012\u0001E1mi\u0016\u0014X*\u001b:s_J$v\u000e]5d))\u0011)Ea\u0016\u0003Z\tu#q\f\t\u0007\u0003w\u00119Ea\u0013\n\t\t%\u0013Q\b\u0002\f\u0017\u000647.\u0019$viV\u0014X\r\u0005\u0003\u0003N\tMSB\u0001B(\u0015\u0011\u0011\t&a+\u0002\t1\fgnZ\u0005\u0005\u0005+\u0012yE\u0001\u0003W_&$\u0007\"\u0002?%\u0001\u0004i\bb\u0002B.I\u0001\u0007\u0011\u0011E\u0001\u0011[&\u0014(o\u001c:U_BL7m\u0015;bi\u0016DaAa\u0004%\u0001\u0004i\bb\u0002B\nI\u0001\u0007\u0011\u0011H\u0001\u001cg\u0016tG-\u00117uKJl\u0015N\u001d:peR{\u0007/[2SKF,Xm\u001d;\u0015\r\u0005]$Q\rBG\u0011\u001d\u0011\t%\na\u0001\u0005O\u0002BA!\u001b\u0003\b:!!1\u000eBA\u001d\u0011\u0011iG! \u000f\t\t=$1\u0010\b\u0005\u0005c\u0012IH\u0004\u0003\u0003t\t]d\u0002BA\u0001\u0005kJ\u0011!X\u0005\u00037rK!a\f.\n\u0007\u0005}\u0012,\u0003\u0003\u0003\u0000\u0005u\u0012aB7fgN\fw-Z\u0005\u0005\u0005\u0007\u0013))\u0001\u000fBYR,'/T5se>\u0014Hk\u001c9jGN\u0014V-];fgR$\u0015\r^1\u000b\t\t}\u0014QH\u0005\u0005\u0005\u0013\u0013YI\u0001\tBYR,'/T5se>\u0014Hk\u001c9jG*!!1\u0011BC\u0011\u001d\u0011y)\na\u0001\u0005#\u000baA]3tk2$\bC\u0002BJ\u00053\u0013Y%\u0004\u0002\u0003\u0016*!!qSA\u001f\u0003%Ig\u000e^3s]\u0006d7/\u0003\u0003\u0003\u001c\nU%aD&bM.\fg)\u001e;ve\u0016LU\u000e\u001d7\u0002/\u001d,G/\u00117m\u0019&t7n\u001d$s_6lU\r^1eCR\fGC\u0001BQ!\u0019\u0011\u0019K!,\u0002\f:!!Q\u0015BU\u001d\u0011\t\tAa*\n\u0003AK1Aa+P\u0003\u001d\u0001\u0018mY6bO\u0016LAAa,\u00032\n\u00191+Z9\u000b\u0007\t-v*\u0001\rjg2Kgn[\"p_J$\u0017N\\1u_J,e.\u00192mK\u0012,\"!a\u001b\u0002'M,\b/\u001a:%[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0005\tm\u0006c\u0001\u001d\u0003>&\u0019!q\u0018\u0017\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0001")
public class ClusterLinkMetadataManagerWithKRaftSupport
extends ClusterLinkMetadataManager {
    private final Function0<Admin> localAdminFactory;

    private /* synthetic */ MetadataCache super$metadataCache() {
        return super.metadataCache();
    }

    @Override
    public Option<MirrorTopic> mirrorTopic(String topic) {
        return Option$.MODULE$.apply((Object)((KRaftMetadataCache)super.metadataCache()).currentImage().topics().getTopic(topic)).flatMap((Function1 & Serializable)x$1 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$1.mirrorTopic())));
    }

    private Map<String, ClusterLinkTopicState> mirrorTopicStates(Option<Set<String>> topicsOpt) {
        Set set;
        MetadataImage image = ((KRaftMetadataCache)super.metadataCache()).currentImage();
        if (topicsOpt instanceof Some) {
            set = (Set)((Set)((Some)topicsOpt).value()).map((Function1 & Serializable)topic -> Option$.MODULE$.apply((Object)image.topics().getTopic(topic)).flatMap((Function1 & Serializable)x$2 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$2.mirrorTopic()))));
        } else if (None$.MODULE$.equals(topicsOpt)) {
            set = ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)image.topics().topicsByName()).asScala().values().map((Function1 & Serializable)x$3 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$3.mirrorTopic())))).toSet();
        } else {
            throw new MatchError(topicsOpt);
        }
        return ((IterableOnceOps)((IterableOps)set.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isDefined()))).map((Function1 & Serializable)stateOpt -> {
            MirrorTopic state = (MirrorTopic)stateOpt.get();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)state.topicName()), (Object)ClusterLinkTopicState$.MODULE$.apply(state));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Map<String, ClusterLinkTopicState> mirrorTopicStates(Uuid linkId) {
        ImmutableMap mirrorTopics = ((KRaftMetadataCache)super.metadataCache()).currentImage().topics().topicsByLinkId(linkId);
        return ((MapOps)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)mirrorTopics).asScala().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetadataManagerWithKRaftSupport.$anonfun$mirrorTopicStates$6(x$5)))).map((Function1 & Serializable)entry -> {
            ClusterLinkTopicState state = ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)((TopicImage)entry._2()).mirrorTopic().get());
            return new Tuple2((Object)((TopicImage)entry._2()).name(), (Object)state);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataStore(Set<String> topics) {
        return this.mirrorTopicStates((Option<Set<String>>)new Some(topics));
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache(Uuid linkId) {
        return this.mirrorTopicStates(linkId);
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache(Set<String> topics) {
        return this.mirrorTopicStates((Option<Set<String>>)new Some(topics));
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache() {
        return this.mirrorTopicStates((Option<Set<String>>)None$.MODULE$);
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext(Uuid linkId) {
        return this.mirrorTopicStates(linkId);
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext(Set<String> topics) {
        return this.mirrorTopicStates((Option<Set<String>>)new Some(topics));
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext() {
        return this.mirrorTopicStates((Option<Set<String>>)None$.MODULE$);
    }

    @Override
    public Set<String> getAllTopicsInCluster() {
        return CollectionConverters$.MODULE$.SetHasAsScala(((KRaftMetadataCache)super.metadataCache()).currentImage().topics().topicsByName().keySet()).asScala().toSet();
    }

    @Override
    public boolean isTopicQueuedUpForDeletion(String topic) {
        return false;
    }

    @Override
    public void ensureClusterLinkExists(Uuid linkId) {
        if (!this.clusterLinkExists(linkId)) {
            throw new ClusterLinkNotFoundException(new StringBuilder(39).append("Cluster link with ID '").append(linkId).append("' does not exist.").toString());
        }
    }

    @Override
    public boolean clusterLinkExists(Uuid linkId) {
        return ((KRaftMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById().containsKey(linkId);
    }

    @Override
    public Option<ClusterLinkData> getClusterLinkData(Uuid linkId) {
        java.util.Map clusterLinks = ((KRaftMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById();
        if (clusterLinks.containsKey(linkId)) {
            ClusterLink clusterLink = (ClusterLink)clusterLinks.get(linkId);
            return new Some((Object)new ClusterLinkData(clusterLink.linkName(), linkId, (Option<String>)new Some((Object)clusterLink.remoteClusterId()), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(clusterLink.tenantPrefix())), false));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<ClusterLinkData> getClusterLinkData(String linkName) {
        java.util.Map clusterLinks = ((KRaftMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksByName();
        if (clusterLinks.containsKey(linkName)) {
            ClusterLink clusterLink = (ClusterLink)clusterLinks.get(linkName);
            return new Some((Object)new ClusterLinkData(clusterLink.linkName(), clusterLink.linkId(), (Option<String>)new Some((Object)clusterLink.remoteClusterId()), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(clusterLink.tenantPrefix())), false));
        }
        return None$.MODULE$;
    }

    @Override
    public Properties getClusterLinkConfigProps(Uuid linkId) {
        this.ensureClusterLinkExists(linkId);
        return ((KRaftMetadataCache)super.metadataCache()).config(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkId.toString()));
    }

    @Override
    public Properties getTopicConfig(String topic) {
        return ((KRaftMetadataCache)super.metadataCache()).config(new ConfigResource(ConfigResource.Type.TOPIC, topic));
    }

    @Override
    public void alterClusterLinkConfigZNode(Uuid linkId, String linkName, Properties persistentProps, ClusterLinkConfig linkConfig) {
        throw new IllegalStateException("Altering link configs in the ZNode is not supported in KRaft mode.");
    }

    @Override
    public void maybeReencryptClusterLinkConfigs(Function1<Properties, Option<Properties>> configTransformer) {
        scala.collection.mutable.Map clusterLinks = CollectionConverters$.MODULE$.MapHasAsScala(((KRaftMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById()).asScala();
        HashMap alterConfigRequestMap = new HashMap(clusterLinks.size());
        clusterLinks.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Uuid linkId = (Uuid)x0$1._1();
                ClusterLink clusterLink = (ClusterLink)x0$1._2();
                ConfigResource configResourceLinkId = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkId.toString());
                Option newEncodedProps = (Option)configTransformer.apply((Object)((KRaftMetadataCache)this.super$metadataCache()).config(configResourceLinkId));
                if (newEncodedProps instanceof Some) {
                    Properties props = (Properties)((Some)newEncodedProps).value();
                    HashSet newConfigs = new HashSet();
                    CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().foreach((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)newConfigs.add(new AlterConfigOp(new ConfigEntry((String)entry._1(), (String)entry._2()), AlterConfigOp.OpType.SET))));
                    ConfigResource configResourceLinkName = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, clusterLink.linkName());
                    return alterConfigRequestMap.put(configResourceLinkName, newConfigs);
                }
                if (None$.MODULE$.equals(newEncodedProps)) {
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)newEncodedProps);
            }
            throw new MatchError(null);
        });
        if (!alterConfigRequestMap.isEmpty()) {
            if (this.destAdmin() == null) {
                this.destAdmin_$eq((Admin)this.localAdminFactory.apply());
            }
            this.destAdmin().incrementalAlterConfigs(alterConfigRequestMap).all().get();
            return;
        }
    }

    @Override
    public void createClusterLinkZNode(ClusterLinkData clusterLinkData, Properties props) {
        throw new IllegalStateException("Creating a cluster link ZNode is not supported in KRaft mode.");
    }

    @Override
    public void setClusterLinkZNode(ClusterLinkData clusterLinkData) {
        throw new IllegalStateException("Setting a cluster link ZNode is not supported in KRaft mode.");
    }

    @Override
    public void alterMirrorTopicState(String topic, Function1<ClusterLinkTopicState, Option<ClusterLinkTopicState>> stateUpdater, boolean validateOnly, boolean failIfNotMirror, boolean isConvertToPendingMirror, String sourceTopicName, Uuid expectedLocalTopicId) {
        Option currentState = this.mirrorTopicStatesFromMetadataStore((Set<String>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).get((Object)topic);
        if (currentState.isEmpty() && failIfNotMirror && !isConvertToPendingMirror) {
            throw new InvalidRequestException(new StringBuilder(28).append("Topic ").append(topic).append(" is not a mirror topic").toString());
        }
        if (currentState.isEmpty() && isConvertToPendingMirror && !validateOnly) {
            ((Option)stateUpdater.apply(null)).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetadataManagerWithKRaftSupport.$anonfun$alterMirrorTopicState$2(x$6))).foreach((Function1 & Serializable)newState -> {
                if (!validateOnly) {
                    try {
                        return this.alterMirrorTopic(topic, (ClusterLinkTopicState)newState, sourceTopicName, expectedLocalTopicId).get();
                    }
                    catch (ExecutionException executionException) {
                        throw executionException.getCause();
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                return BoxedUnit.UNIT;
            });
        }
        currentState.foreach((Function1 & Serializable)state -> {
            this.applyState$1(state, stateUpdater, validateOnly, topic, sourceTopicName, expectedLocalTopicId);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void deleteClusterLinkZNode(Uuid linkId) {
        throw new IllegalStateException("Deleting a cluster link ZNode is not supported in KRaft mode.");
    }

    private KafkaFuture<Void> alterMirrorTopic(String topic, ClusterLinkTopicState mirrorTopicState, String sourceTopicName, Uuid expectedLocalTopicId) {
        AlterMirrorTopicsRequestData.AlterMirrorTopic alterMirrorTopic = new AlterMirrorTopicsRequestData.AlterMirrorTopic().setTopic(topic);
        KafkaFutureImpl result = new KafkaFutureImpl();
        if (mirrorTopicState instanceof ClusterLinkTopicState.Mirror) {
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.MIRROR.stateName());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.PausedMirror) {
            ClusterLinkTopicState.PausedMirror pausedMirror = (ClusterLinkTopicState.PausedMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.PAUSED.stateName()).setLinkLevelPause(pausedMirror.linkLevel()).setTopicLevelPause(pausedMirror.topicLevel()).setMirrorTopicError(pausedMirror.mirrorTopicError().code());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.FailedMirror) {
            ClusterLinkTopicState.FailedMirror failedMirror = (ClusterLinkTopicState.FailedMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.FAILED.stateName()).setMirrorTopicError(failedMirror.mirrorTopicError().code());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.PendingStoppedMirror) {
            ClusterLinkTopicState.PendingStoppedMirror pendingStoppedMirror = (ClusterLinkTopicState.PendingStoppedMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.PENDING_STOPPED.stateName()).setPromoted(pendingStoppedMirror.synchronize());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.StoppedMirror) {
            ClusterLinkTopicState.StoppedMirror stoppedMirror = (ClusterLinkTopicState.StoppedMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.STOPPED.stateName()).setStoppedLogEndOffsets(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)stoppedMirror.logEndOffsets().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToLong((Object)x$1))).asJava());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.PendingMirror) {
            ClusterLinkTopicState.PendingMirror pendingMirror = (ClusterLinkTopicState.PendingMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.PENDING_MIRROR.stateName()).setLinkId(pendingMirror.linkId()).setSourceTopicId(pendingMirror.sourceTopicId()).setSourceTopicName(sourceTopicName).setExpectedLocalTopicId(expectedLocalTopicId).setNextState(pendingMirror.nextState());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.PendingSynchronizeMirror) {
            ClusterLinkTopicState.PendingSynchronizeMirror pendingSynchronizeMirror = (ClusterLinkTopicState.PendingSynchronizeMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.PENDING_SYNCHRONIZE.stateName()).setNextState(pendingSynchronizeMirror.remoteMirrorNextState().name());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.PendingRepairMirror) {
            ClusterLinkTopicState.PendingRepairMirror pendingRepairMirror = (ClusterLinkTopicState.PendingRepairMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.PENDING_REPAIR.stateName()).setMirrorTopicError(pendingRepairMirror.mirrorTopicError().code());
        } else {
            throw new MatchError((Object)mirrorTopicState);
        }
        alterMirrorTopic.setMirrorStartOffsets(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)mirrorTopicState.mirrorStartOffsets().map((Function1 & Serializable)x -> ClusterLinkMetadataManagerWithKRaftSupport.$anonfun$alterMirrorTopic$2(BoxesRunTime.unboxToLong((Object)x)))).asJava());
        this.sendAlterMirrorTopicRequest(alterMirrorTopic, (KafkaFutureImpl<Void>)result);
        return result;
    }

    @Override
    public boolean alterMirrorTopicState$default$4() {
        return true;
    }

    @Override
    public boolean alterMirrorTopicState$default$5() {
        return false;
    }

    @Override
    public String alterMirrorTopicState$default$6() {
        return "";
    }

    @Override
    public Uuid alterMirrorTopicState$default$7() {
        return Uuid.ZERO_UUID;
    }

    private void sendAlterMirrorTopicRequest(AlterMirrorTopicsRequestData.AlterMirrorTopic alterMirrorTopic, KafkaFutureImpl<Void> result) {
        AlterMirrorTopicsRequest.Builder builder = new AlterMirrorTopicsRequest.Builder(alterMirrorTopic, false, this.requestTimeoutMs());
        ClusterLinkControllerRequestCompletionHandler requestHandler = new ClusterLinkControllerRequestCompletionHandler(null, alterMirrorTopic, result){
            private final AlterMirrorTopicsRequestData.AlterMirrorTopic alterMirrorTopic$1;
            private final KafkaFutureImpl result$1;

            public void handleResponse(AbstractResponse response) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(this.msgWithLogIdent("Received response for alterMirrorTopicRequest"));
                }
                ((AlterMirrorTopicsResponse)response).complete(Collections.singletonMap(this.alterMirrorTopic$1.topic(), this.result$1));
            }

            public void onFailure(Throwable ex) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(this.msgWithLogIdent("alterMirrorTopic request failed with exception"), ex);
                }
                this.result$1.completeExceptionally(ex);
            }

            public static final /* synthetic */ String $anonfun$handleResponse$1() {
                return "Received response for alterMirrorTopicRequest";
            }

            public static final /* synthetic */ String $anonfun$onFailure$1() {
                return "alterMirrorTopic request failed with exception";
            }

            public static final /* synthetic */ Throwable $anonfun$onFailure$2(Throwable ex$1) {
                return ex$1;
            }
            {
                this.alterMirrorTopic$1 = alterMirrorTopic$1;
                this.result$1 = result$1;
            }
        };
        super.controllerChannelManager().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)builder, requestHandler);
    }

    @Override
    public scala.collection.immutable.Seq<ClusterLinkData> getAllLinksFromMetadata() {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(((KRaftMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById()).asScala().values().map((Function1 & Serializable)clusterLink -> new ClusterLinkData(clusterLink.linkName(), clusterLink.linkId(), (Option<String>)new Some((Object)clusterLink.remoteClusterId()), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(clusterLink.tenantPrefix())), false))).toSeq();
    }

    @Override
    public boolean isLinkCoordinatorEnabled() {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$mirrorTopicStates$6(Tuple2 x$5) {
        return ((TopicImage)x$5._2()).mirrorTopic().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$alterMirrorTopicState$2(ClusterLinkTopicState x$6) {
        return x$6 != null;
    }

    private final void applyState$1(ClusterLinkTopicState state, Function1 stateUpdater$1, boolean validateOnly$1, String topic$1, String sourceTopicName$1, Uuid expectedLocalTopicId$1) {
        ((Option)stateUpdater$1.apply((Object)state)).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetadataManagerWithKRaftSupport.$anonfun$alterMirrorTopicState$2(x$6))).foreach((Function1 & Serializable)newState -> {
            if (!validateOnly) {
                try {
                    return this.alterMirrorTopic(topic, (ClusterLinkTopicState)newState, sourceTopicName, expectedLocalTopicId).get();
                }
                catch (ExecutionException executionException) {
                    throw executionException.getCause();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Long $anonfun$alterMirrorTopic$2(long x) {
        return BoxesRunTime.boxToLong((long)x);
    }

    public ClusterLinkMetadataManagerWithKRaftSupport(KafkaConfig brokerConfig, ClusterLinkScheduler scheduler, KRaftMetadataCache metadataCache, NodeToControllerChannelManager controllerChannelManager, Function0<Admin> localAdminFactory, AuthorizerServerInfo serverInfo) {
        this.localAdminFactory = localAdminFactory;
        super(brokerConfig, scheduler, metadataCache, controllerChannelManager, localAdminFactory, serverInfo);
    }
}

