/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpoint;
import org.apache.kafka.storage.internals.log.EpochEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TierStateFetcher {
    private static final Logger log = LoggerFactory.getLogger(TierStateFetcher.class);
    private final TierObjectStore tierObjectStore;
    private final ExecutorService executorService;
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    public static final Integer ESTIMATED_BUFFER_SIZE = 5192;

    public TierStateFetcher(Integer numThreads, TierObjectStore tierObjectStore) {
        this.tierObjectStore = tierObjectStore;
        this.executorService = Executors.newFixedThreadPool(numThreads);
    }

    public void close() {
        if (this.stopped.compareAndSet(false, true)) {
            this.executorService.shutdownNow();
        }
    }

    public CompletableFuture<List<EpochEntry>> fetchLeaderEpochStateAsync(TierObjectStore.ObjectMetadata metadata) {
        CompletableFuture<List<EpochEntry>> entries = new CompletableFuture<List<EpochEntry>>();
        this.executorService.execute(() -> {
            try (TierObjectStoreResponse response = this.tierObjectStore.getObject(metadata, TierObjectStore.FileType.EPOCH_STATE);
                 InputStreamReader inputStreamReader = new InputStreamReader(response.getInputStream());
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                entries.complete(LeaderEpochCheckpoint.read((String)metadata.toString(), (BufferedReader)bufferedReader));
            }
            catch (Throwable e) {
                entries.completeExceptionally(e);
            }
        });
        return entries;
    }

    public CompletableFuture<ByteBuffer> fetchProducerStateSnapshotAsync(TierObjectStore.ObjectMetadata metadata) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.fetchSnapshot(metadata, TierObjectStore.FileType.PRODUCER_STATE);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, this.executorService);
    }

    private ByteBuffer fetchSnapshot(TierObjectStore.ObjectStoreMetadata metadata, TierObjectStore.FileType fileType) {
        return this.tierObjectStore.getSnapshot(metadata, fileType, ESTIMATED_BUFFER_SIZE);
    }

    public ByteBuffer fetchRecoverSnapshot(TierObjectStore.TierStateRestoreSnapshotMetadata metadata) {
        return this.fetchSnapshot(metadata, TierObjectStore.FileType.TIER_STATE_SNAPSHOT);
    }

    public ByteBuffer fetchTierPartitionStateSnapshot(TierObjectStore.TierPartitionStateSnapshotMetadata metadata) {
        return this.fetchSnapshot(metadata, TierObjectStore.FileType.TIER_PARTITION_STATE_METADATA_SNAPSHOT);
    }
}

