/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.log.AbstractLog;
import kafka.log.LogSegment;
import kafka.server.ReplicaManager;
import kafka.server.resource.DiskIOManager;
import kafka.server.resource.TierArchiverDiskThroughputListener;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.TierTaskWorkingSet;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.ArchiverPartitionLagInfo;
import kafka.tier.tasks.archive.ArchiverTaskQueue;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.FailedState;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import kafka.utils.Throttler;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\rg\u0001B\u001e=\u0005\u0015C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t1\u0002\u0011\t\u0011)A\u00053\"Aq\f\u0001B\u0001B\u0003%\u0001\r\u0003\u0005g\u0001\t\u0005\t\u0015!\u0003h\u0011!i\u0007A!A!\u0002\u0013q\u0007\u0002\u0003;\u0001\u0005\u0003\u0005\u000b\u0011B;\t\u0011a\u0004!\u0011!Q\u0001\neD!\"a\u0003\u0001\u0005\u0003\u0005\u000b\u0011BA\u0007\u0011)\ty\u0002\u0001B\u0001B\u0003-\u0011\u0011\u0005\u0005\b\u0003[\u0001A\u0011AA\u0018\u0011\u001d\tI\u0005\u0001C)\u0003\u0017B\u0011\"a\u0019\u0001\u0005\u0004%\t!!\u001a\t\u0011\u0005=\u0004\u0001)A\u0005\u0003OB\u0011\"!\u001d\u0001\u0005\u0004%i!a\u001d\t\u0011\u0005e\u0004\u0001)A\u0007\u0003kB\u0011\"a\u001f\u0001\u0005\u0004%I!! \t\u0011\u00055\u0005\u0001)A\u0005\u0003\u007fB\u0011\"a$\u0001\u0005\u0004%I!!%\t\u0011\u0005\u0005\u0006\u0001)A\u0005\u0003'C\u0011\"a)\u0001\u0005\u0004%I!!*\t\u0011\u0005u\u0006\u0001)A\u0005\u0003OC\u0011\"a0\u0001\u0005\u0004%I!!*\t\u0011\u0005\u0005\u0007\u0001)A\u0005\u0003OC\u0011\"a1\u0001\u0005\u0004%I!!*\t\u0011\u0005\u0015\u0007\u0001)A\u0005\u0003OC\u0011\"a2\u0001\u0005\u0004%I!!3\t\u0011\u0005E\u0007\u0001)A\u0005\u0003\u0017D\u0011\"a5\u0001\u0001\u0004%I!!6\t\u0013\u0005u\u0007\u00011A\u0005\n\u0005}\u0007\u0002CAv\u0001\u0001\u0006K!a6\t\u0013\u0005U\b\u00011A\u0005\n\u0005U\u0007\"CA|\u0001\u0001\u0007I\u0011BA}\u0011!\ti\u0010\u0001Q!\n\u0005]\u0007\"\u0003B\u0001\u0001\u0001\u0007I\u0011BAk\u0011%\u0011\u0019\u0001\u0001a\u0001\n\u0013\u0011)\u0001\u0003\u0005\u0003\n\u0001\u0001\u000b\u0015BAl\u0011%\u0011i\u0001\u0001a\u0001\n\u0013\u0011y\u0001C\u0005\u0003\u0012\u0001\u0001\r\u0011\"\u0003\u0003\u0014!9!q\u0003\u0001!B\u0013)\b\"\u0003B\u000e\u0001\u0001\u0007I\u0011BAk\u0011%\u0011i\u0002\u0001a\u0001\n\u0013\u0011y\u0002\u0003\u0005\u0003$\u0001\u0001\u000b\u0015BAl\u0011)\u00119\u0003\u0001b\u0001\n\u0003q$\u0011\u0006\u0005\t\u0005c\u0001\u0001\u0015!\u0003\u0003,!I!1\u0007\u0001C\u0002\u0013%!Q\u0007\u0005\t\u0005\u000b\u0002\u0001\u0015!\u0003\u00038!9!q\t\u0001\u0005\u0002\t%\u0003b\u0002B2\u0001\u0011\u0005!Q\r\u0005\b\u0005O\u0002A\u0011\u0001B5\u0011\u001d\u0011\u0019\b\u0001C\u0001\u0005kBqAa\u001f\u0001\t\u0013\u0011i\bC\u0004\u0003\u000e\u0002!IAa$\t\u000f\tU\u0005\u0001\"\u0003\u0003\u0018\u001eI!Q\u0014\u001f\u0002\u0002#\u0005!q\u0014\u0004\twq\n\t\u0011#\u0001\u0003\"\"9\u0011QF\u001c\u0005\u0002\t\r\u0006\"\u0003BSoE\u0005I\u0011\u0001BT\u0011%\u0011ilNI\u0001\n\u0003\u0011yL\u0001\u0007US\u0016\u0014\u0018I]2iSZ,'O\u0003\u0002>}\u00059\u0011M]2iSZ,'BA A\u0003\u0015!\u0018m]6t\u0015\t\t%)\u0001\u0003uS\u0016\u0014(\"A\"\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001A\u0012'\u0011\u0005\u001dSU\"\u0001%\u000b\u0003%\u000bQa]2bY\u0006L!a\u0013%\u0003\r\u0005s\u0017PU3g!\ti\u0005+D\u0001O\u0015\ty%)A\u0003vi&d7/\u0003\u0002R\u001d\n9Aj\\4hS:<\u0017AB2p]\u001aLw\r\u0005\u0002U-6\tQK\u0003\u0002S}%\u0011q+\u0016\u0002\u0010)&,'\u000fV1tWN\u001cuN\u001c4jO\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bC\u0001.^\u001b\u0005Y&B\u0001/C\u0003\u0019\u0019XM\u001d<fe&\u0011al\u0017\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003E!\u0018.\u001a:U_BL7-\u00119qK:$WM\u001d\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G\u0002\u000bQ\u0001^8qS\u000eL!!\u001a2\u0003#QKWM\u001d+pa&\u001c\u0017\t\u001d9f]\u0012,'/A\buS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f!\tA7.D\u0001j\u0015\tQ\u0007)A\u0003ti>\u0014X-\u0003\u0002mS\nyA+[3s\u001f\nTWm\u0019;Ti>\u0014X-A\u0002dib\u0004\"a\u001c:\u000e\u0003AT!!\u001d!\u0002\u000f\u0019,Go\u00195fe&\u00111\u000f\u001d\u0002\u0014\u0007\u0006t7-\u001a7mCRLwN\\\"p]R,\u0007\u0010^\u0001\t[\u0006DH+Y:lgB\u0011qI^\u0005\u0003o\"\u00131!\u00138u\u0003\u0011!\u0018.\\3\u0011\u0007i\f9!D\u0001|\u0015\tyEP\u0003\u0002~}\u000611m\\7n_:T!aQ@\u000b\t\u0005\u0005\u00111A\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\u0015\u0011aA8sO&\u0019\u0011\u0011B>\u0003\tQKW.Z\u0001\u0011I&\u001c8.S(NC:\fw-\u001a:PaR\u0004RaRA\b\u0003'I1!!\u0005I\u0005\u0019y\u0005\u000f^5p]B!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001am\u000b\u0001B]3t_V\u00148-Z\u0005\u0005\u0003;\t9BA\u0007ESN\\\u0017jT'b]\u0006<WM]\u0001\u0003K\u000e\u0004B!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003OA\u0015AC2p]\u000e,(O]3oi&!\u00111FA\u0013\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0013\u0003c\tI$a\u000f\u0002>\u0005}\u0012\u0011IA\"\u0003\u000b\n9\u0005\u0006\u0003\u00024\u0005]\u0002cAA\u001b\u00015\tA\bC\u0004\u0002 )\u0001\u001d!!\t\t\u000bIS\u0001\u0019A*\t\u000baS\u0001\u0019A-\t\u000b}S\u0001\u0019\u00011\t\u000b\u0019T\u0001\u0019A4\t\u000b5T\u0001\u0019\u00018\t\u000bQT\u0001\u0019A;\t\u000faT\u0001\u0013!a\u0001s\"I\u00111\u0002\u0006\u0011\u0002\u0003\u0007\u0011QB\u0001\u000bY><w-\u001a:OC6,WCAA'!\u0011\ty%!\u0018\u000f\t\u0005E\u0013\u0011\f\t\u0004\u0003'BUBAA+\u0015\r\t9\u0006R\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005m\u0003*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003?\n\tG\u0001\u0004TiJLgn\u001a\u0006\u0004\u00037B\u0015!\u00073jg.$\u0006N]8vO\"\u0004X\u000f\u001e'jgR,g.\u001a:PaR,\"!a\u001a\u0011\u000b\u001d\u000by!!\u001b\u0011\t\u0005U\u00111N\u0005\u0005\u0003[\n9B\u0001\u0012US\u0016\u0014\u0018I]2iSZ,'\u000fR5tWRC'o\\;hQB,H\u000fT5ti\u0016tWM]\u0001\u001bI&\u001c8\u000e\u00165s_V<\u0007\u000e];u\u0019&\u001cH/\u001a8fe>\u0003H\u000fI\u0001\u001d)>\u0003v\fT!H\u000f&sui\u0018)B%RKE+S(O'~\u001bu*\u0016(U+\t\t)h\u0004\u0002\u0002xu\tQ!A\u000fU\u001fB{F*Q$H\u0013:;u\fU!S)&#\u0016j\u0014(T?\u000e{UK\u0014+!\u00031iW\r\u001e:jGN<%o\\;q+\t\ty\b\u0005\u0003\u0002\u0002\u0006%UBAAB\u0015\u0011\t))a\"\u0002\u000f5,GO]5dg*\u0011AL`\u0005\u0005\u0003\u0017\u000b\u0019IA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkB\fQ\"\\3ue&\u001c7o\u0012:pkB\u0004\u0013AJ#3\u000b~\u001b\u0005*R\"L'Vku,\u0013(W\u00032KEiX\"P+:#v,T#U%&\u001buLT!N\u000bV\u0011\u00111\u0013\t\u0005\u0003+\u000by*\u0004\u0002\u0002\u0018*!\u0011\u0011TAN\u0003\u0011a\u0017M\\4\u000b\u0005\u0005u\u0015\u0001\u00026bm\u0006LA!a\u0018\u0002\u0018\u00069SIM#`\u0007\"+5iS*V\u001b~KeJV!M\u0013\u0012{6iT+O)~kU\t\u0016*J\u0007~s\u0015)T#!\u0003!\u0011\u0017\u0010^3SCR,WCAAT!\u0011\tI+!/\u000e\u0005\u0005-&\u0002BAW\u0003_\u000bAaY8sK*!\u0011QQAY\u0015\u0011\t\u0019,!.\u0002\re\fW.\\3s\u0015\t\t9,A\u0002d_6LA!a/\u0002,\n)Q*\u001a;fe\u0006I!-\u001f;f%\u0006$X\rI\u0001\ne\u0016$(/\u001f*bi\u0016\f!B]3uef\u0014\u0016\r^3!\u00039)\u0007pY3qi&|gn\u001d*bi\u0016\fq\"\u001a=dKB$\u0018n\u001c8t%\u0006$X\rI\u0001\u0018KJ*7\t[3dWN,X.\u00138wC2LGmQ8v]R,\"!a3\u0011\t\u0005%\u0016QZ\u0005\u0005\u0003\u001f\fYKA\u0004D_VtG/\u001a:\u00021\u0015\u0014Tm\u00115fG.\u001cX/\\%om\u0006d\u0017\u000eZ\"pk:$\b%A\u0007u_R\fG\u000eT1h-\u0006dW/Z\u000b\u0003\u0003/\u00042aRAm\u0013\r\tY\u000e\u0013\u0002\u0005\u0019>tw-A\tu_R\fG\u000eT1h-\u0006dW/Z0%KF$B!!9\u0002hB\u0019q)a9\n\u0007\u0005\u0015\bJ\u0001\u0003V]&$\b\"CAu;\u0005\u0005\t\u0019AAl\u0003\rAH%M\u0001\u000fi>$\u0018\r\u001c'bOZ\u000bG.^3!Q\rq\u0012q\u001e\t\u0004\u000f\u0006E\u0018bAAz\u0011\nAao\u001c7bi&dW-A\u0012u_R\fG\u000eT1h-\u0006dW/Z,ji\"|W\u000f^#se>\u0014\b+\u0019:uSRLwN\\:\u0002OQ|G/\u00197MC\u001e4\u0016\r\\;f/&$\bn\\;u\u000bJ\u0014xN\u001d)beRLG/[8og~#S-\u001d\u000b\u0005\u0003C\fY\u0010C\u0005\u0002j\u0002\n\t\u00111\u0001\u0002X\u0006!Co\u001c;bY2\u000bwMV1mk\u0016<\u0016\u000e\u001e5pkR,%O]8s!\u0006\u0014H/\u001b;j_:\u001c\b\u0005K\u0002\"\u0003_\fA\u0003]1si&$\u0018n\u001c8MC\u001el\u0015\r\u001f,bYV,\u0017\u0001\u00079beRLG/[8o\u0019\u0006<W*\u0019=WC2,Xm\u0018\u0013fcR!\u0011\u0011\u001dB\u0004\u0011%\tIoIA\u0001\u0002\u0004\t9.A\u000bqCJ$\u0018\u000e^5p]2\u000bw-T1y-\u0006dW/\u001a\u0011)\u0007\u0011\ny/\u0001\fmC\u001e<\u0017N\\4QCJ$\u0018\u000e^5p]N\u001cu.\u001e8u+\u0005)\u0018A\u00077bO\u001eLgn\u001a)beRLG/[8og\u000e{WO\u001c;`I\u0015\fH\u0003BAq\u0005+A\u0001\"!;'\u0003\u0003\u0005\r!^\u0001\u0018Y\u0006<w-\u001b8h!\u0006\u0014H/\u001b;j_:\u001c8i\\;oi\u0002B3aJAx\u0003a\u0001\u0018M\u001d;ji&|g\u000eV5nK2\u000bw-T1y-\u0006dW/Z\u0001\u001da\u0006\u0014H/\u001b;j_:$\u0016.\\3MC\u001el\u0015\r\u001f,bYV,w\fJ3r)\u0011\t\tO!\t\t\u0013\u0005%\u0018&!AA\u0002\u0005]\u0017!\u00079beRLG/[8o)&lW\rT1h\u001b\u0006Dh+\u00197vK\u0002B3AKAx\u0003%!\u0018m]6Rk\u0016,X-\u0006\u0002\u0003,A!\u0011Q\u0007B\u0017\u0013\r\u0011y\u0003\u0010\u0002\u0012\u0003J\u001c\u0007.\u001b<feR\u000b7o[)vKV,\u0017A\u0003;bg.\fV/Z;fA\u0005Qqo\u001c:lS:<7+\u001a;\u0016\u0005\t]\u0002C\u0002B\u001d\u0005w\u0011y$D\u0001?\u0013\r\u0011iD\u0010\u0002\u0013)&,'\u000fV1tW^{'o[5oON+G\u000f\u0005\u0003\u00026\t\u0005\u0013b\u0001B\"y\tY\u0011I]2iSZ,G+Y:l\u0003-9xN]6j]\u001e\u001cV\r\u001e\u0011\u0002\r\u0011|wk\u001c:l)\t\u0011Y\u0005\u0005\u0004\u0003N\t]#Q\f\b\u0005\u0005\u001f\u0012\u0019F\u0004\u0003\u0002T\tE\u0013\"A%\n\u0007\tU\u0003*A\u0004qC\u000e\\\u0017mZ3\n\t\te#1\f\u0002\u0005\u0019&\u001cHOC\u0002\u0003V!\u0003b!a\t\u0003`\t}\u0012\u0002\u0002B1\u0003K\u0011aAR;ukJ,\u0017\u0001C:ikR$wn\u001e8\u0015\u0005\u0005\u0005\u0018\u0001\u00059beRLG/[8o\u0019\u0006<\u0017J\u001c4p+\t\u0011Y\u0007\u0005\u0004\u0003N\t]#Q\u000e\t\u0005\u0003k\u0011y'C\u0002\u0003rq\u0012\u0001$\u0011:dQ&4XM\u001d)beRLG/[8o\u0019\u0006<\u0017J\u001c4p\u0003Mawn\u001a)beRLG/[8o\u0019\u0006<\u0017J\u001c4p)\u0011\t\tOa\u001e\t\u000f\te$\u00071\u0001\u0002X\u0006Y1-\u001e:sK:$H+[7f\u0003Y\u0019\u0018N_3PMRKWM]1cY\u0016\u001cVmZ7f]R\u001cH\u0003BAl\u0005\u007fBqA!!4\u0001\u0004\u0011\u0019)A\u0002m_\u001e\u0004BA!\"\u0003\n6\u0011!q\u0011\u0006\u0004\u0005\u0003\u0013\u0015\u0002\u0002BF\u0005\u000f\u00131\"\u00112tiJ\f7\r\u001e'pO\u0006yb\r\\;tQRKW.Z(g\r&\u00148\u000f\u001e+jKJ\f'\r\\3TK\u001elWM\u001c;\u0015\t\tE%1\u0013\t\u0006\u000f\u0006=\u0011q\u001b\u0005\b\u0005\u0003#\u0004\u0019\u0001BB\u00035\u00198\r[3ek2Lgn\u001a'bOR!!\u0011\u0013BM\u0011\u001d\u0011Y*\u000ea\u0001\u0005\u007f\tA\u0001^1tW\u0006aA+[3s\u0003J\u001c\u0007.\u001b<feB\u0019\u0011QG\u001c\u0014\u0005]2EC\u0001BP\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!\u0011\u0016\u0016\u0004s\n-6F\u0001BW!\u0011\u0011yK!/\u000e\u0005\tE&\u0002\u0002BZ\u0005k\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t]\u0006*\u0001\u0006b]:|G/\u0019;j_:LAAa/\u00032\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00139+\t\u0011\tM\u000b\u0003\u0002\u000e\t-\u0006")
public final class TierArchiver
implements Logging {
    private final TierTasksConfig config;
    private final ReplicaManager replicaManager;
    private final CancellationContext ctx;
    private final Time time;
    private final Option<TierArchiverDiskThroughputListener> diskThroughputListenerOpt;
    private final KafkaMetricsGroup metricsGroup;
    private final String E2E_CHECKSUM_INVALID_COUNT_METRIC_NAME;
    private final Meter byteRate;
    private final Meter retryRate;
    private final Meter exceptionsRate;
    private final Counter e2eChecksumInvalidCount;
    private volatile long kafka$tier$tasks$archive$TierArchiver$$totalLagValue;
    private volatile long kafka$tier$tasks$archive$TierArchiver$$totalLagValueWithoutErrorPartitions;
    private volatile long kafka$tier$tasks$archive$TierArchiver$$partitionLagMaxValue;
    private volatile int kafka$tier$tasks$archive$TierArchiver$$laggingPartitionsCount;
    private volatile long kafka$tier$tasks$archive$TierArchiver$$partitionTimeLagMaxValue;
    private final ArchiverTaskQueue taskQueue;
    private final TierTaskWorkingSet<ArchiveTask> workingSet;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<DiskIOManager> $lessinit$greater$default$8() {
        return None$.MODULE$;
    }

    public static Time $lessinit$greater$default$7() {
        return Time.SYSTEM;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return TierArchiver.class.getName();
    }

    public Option<TierArchiverDiskThroughputListener> diskThroughputListenerOpt() {
        return this.diskThroughputListenerOpt;
    }

    private final int TOP_LAGGING_PARTITIONS_COUNT() {
        return 5;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private String E2E_CHECKSUM_INVALID_COUNT_METRIC_NAME() {
        return this.E2E_CHECKSUM_INVALID_COUNT_METRIC_NAME;
    }

    private Meter byteRate() {
        return this.byteRate;
    }

    private Meter retryRate() {
        return this.retryRate;
    }

    private Meter exceptionsRate() {
        return this.exceptionsRate;
    }

    private Counter e2eChecksumInvalidCount() {
        return this.e2eChecksumInvalidCount;
    }

    public long kafka$tier$tasks$archive$TierArchiver$$totalLagValue() {
        return this.kafka$tier$tasks$archive$TierArchiver$$totalLagValue;
    }

    private void totalLagValue_$eq(long x$1) {
        this.kafka$tier$tasks$archive$TierArchiver$$totalLagValue = x$1;
    }

    public long kafka$tier$tasks$archive$TierArchiver$$totalLagValueWithoutErrorPartitions() {
        return this.kafka$tier$tasks$archive$TierArchiver$$totalLagValueWithoutErrorPartitions;
    }

    private void totalLagValueWithoutErrorPartitions_$eq(long x$1) {
        this.kafka$tier$tasks$archive$TierArchiver$$totalLagValueWithoutErrorPartitions = x$1;
    }

    public long kafka$tier$tasks$archive$TierArchiver$$partitionLagMaxValue() {
        return this.kafka$tier$tasks$archive$TierArchiver$$partitionLagMaxValue;
    }

    private void partitionLagMaxValue_$eq(long x$1) {
        this.kafka$tier$tasks$archive$TierArchiver$$partitionLagMaxValue = x$1;
    }

    public int kafka$tier$tasks$archive$TierArchiver$$laggingPartitionsCount() {
        return this.kafka$tier$tasks$archive$TierArchiver$$laggingPartitionsCount;
    }

    private void laggingPartitionsCount_$eq(int x$1) {
        this.kafka$tier$tasks$archive$TierArchiver$$laggingPartitionsCount = x$1;
    }

    public long kafka$tier$tasks$archive$TierArchiver$$partitionTimeLagMaxValue() {
        return this.kafka$tier$tasks$archive$TierArchiver$$partitionTimeLagMaxValue;
    }

    private void partitionTimeLagMaxValue_$eq(long x$1) {
        this.kafka$tier$tasks$archive$TierArchiver$$partitionTimeLagMaxValue = x$1;
    }

    public ArchiverTaskQueue taskQueue() {
        return this.taskQueue;
    }

    private TierTaskWorkingSet<ArchiveTask> workingSet() {
        return this.workingSet;
    }

    public List<Future<ArchiveTask>> doWork() {
        return this.workingSet().doWork(this.config, (Option<Throttler>)this.diskThroughputListenerOpt().map((Function1 & Serializable)x$1 -> x$1.throttler()));
    }

    public void shutdown() {
        this.ctx.cancel();
        this.taskQueue().close();
    }

    public List<ArchiverPartitionLagInfo> partitionLagInfo() {
        return (List)this.replicaManager.leaderPartitionsIterator().flatMap((Function1 & Serializable)x$2 -> x$2.log()).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TierArchiver.$anonfun$partitionLagInfo$2(x$3))).map((Function1 & Serializable)log -> new ArchiverPartitionLagInfo(log.topicPartition(), log.tierPartitionState().status(), this.sizeOfTierableSegments((AbstractLog)log), this.flushTimeOfFirstTierableSegment((AbstractLog)log))).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TierArchiver.$anonfun$partitionLagInfo$4(x$4))).toList().sortBy((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)TierArchiver.$anonfun$partitionLagInfo$5(x$5)), (Ordering)Ordering.Long$.MODULE$);
    }

    public void logPartitionLagInfo(long currentTime) {
        List<ArchiverPartitionLagInfo> laggingPartitions = this.partitionLagInfo();
        this.laggingPartitionsCount_$eq(laggingPartitions.size());
        this.totalLagValue_$eq(BoxesRunTime.unboxToLong((Object)this.partitionLagInfo().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.sizeOfTierableSegments())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        if (this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = TierArchiver.$anonfun$logPartitionLagInfo$2(this);
            Object var6_3 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        this.totalLagValueWithoutErrorPartitions_$eq(BoxesRunTime.unboxToLong((Object)laggingPartitions.filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TierArchiver.$anonfun$logPartitionLagInfo$3(x$7))).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.sizeOfTierableSegments())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        List topLaggingPartitions = laggingPartitions.take(5);
        if (topLaggingPartitions.nonEmpty()) {
            if (this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = TierArchiver.$anonfun$logPartitionLagInfo$5(this, topLaggingPartitions);
                Object var7_5 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            this.partitionLagMaxValue_$eq(((ArchiverPartitionLagInfo)topLaggingPartitions.head()).sizeOfTierableSegments());
        } else {
            this.partitionLagMaxValue_$eq(0L);
        }
        List partitionsWithOldestSegments = ((List)laggingPartitions.filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TierArchiver.$anonfun$logPartitionLagInfo$6(x$9))).sortBy((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)TierArchiver.$anonfun$logPartitionLagInfo$7(x$10)), (Ordering)Ordering.Long$.MODULE$)).take(5);
        if (partitionsWithOldestSegments.nonEmpty()) {
            if (this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = TierArchiver.$anonfun$logPartitionLagInfo$8(this, partitionsWithOldestSegments);
                Object var8_7 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            this.partitionTimeLagMaxValue_$eq(Math.max(currentTime - BoxesRunTime.unboxToLong((Object)((ArchiverPartitionLagInfo)partitionsWithOldestSegments.head()).timeFirstTierableSegmentRolled().get()), 0L));
            return;
        }
        this.partitionTimeLagMaxValue_$eq(0L);
    }

    private long sizeOfTierableSegments(AbstractLog log) {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)log.tierableLogSegments().map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.size()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    private Option<Object> flushTimeOfFirstTierableSegment(AbstractLog log) {
        return log.tierableLogSegments().headOption().map((Function1 & Serializable)segment -> BoxesRunTime.boxToLong((long)TierArchiver.$anonfun$flushTimeOfFirstTierableSegment$1(segment)));
    }

    private Option<Object> schedulingLag(ArchiveTask task) {
        ArchiveTaskState archiveTaskState = task.state();
        if (archiveTaskState instanceof BeforeLeader) {
            return new Some((Object)BoxesRunTime.boxToLong((long)-1L));
        }
        if (archiveTaskState instanceof BeforeUpload) {
            return this.replicaManager.getLog(task.topicPartition()).map((Function1 & Serializable)log -> BoxesRunTime.boxToLong((long)this.sizeOfTierableSegments(log)));
        }
        if (archiveTaskState instanceof Upload) {
            return new Some((Object)BoxesRunTime.boxToLong((long)-2L));
        }
        if (archiveTaskState instanceof AfterUpload) {
            return new Some((Object)BoxesRunTime.boxToLong((long)-3L));
        }
        if (archiveTaskState instanceof FailedState) {
            return new Some((Object)BoxesRunTime.boxToLong((long)-4L));
        }
        throw new MatchError((Object)archiveTaskState);
    }

    public static final /* synthetic */ boolean $anonfun$partitionLagInfo$2(AbstractLog x$3) {
        return x$3.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ boolean $anonfun$partitionLagInfo$4(ArchiverPartitionLagInfo x$4) {
        return x$4.sizeOfTierableSegments() > 0L;
    }

    public static final /* synthetic */ long $anonfun$partitionLagInfo$5(ArchiverPartitionLagInfo x$5) {
        return 0L - x$5.sizeOfTierableSegments();
    }

    public static final /* synthetic */ String $anonfun$logPartitionLagInfo$2(TierArchiver $this) {
        return new StringBuilder(43).append("Sum of TierArchiver lag of all partitions: ").append($this.kafka$tier$tasks$archive$TierArchiver$$totalLagValue()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$logPartitionLagInfo$3(ArchiverPartitionLagInfo x$7) {
        return !x$7.tierPartitionStatus().hasError();
    }

    public static final /* synthetic */ String $anonfun$logPartitionLagInfo$5(TierArchiver $this, List topLaggingPartitions$1) {
        return new StringBuilder(160).append($this.kafka$tier$tasks$archive$TierArchiver$$laggingPartitionsCount()).append(" partitions seen with lag > 0. Partitions with most").append(" TierArchiver lag in descending order of lag (TopicPartition, PartitionStatus, LagInBytes, OldestTimestamp):").append(" ").append(topLaggingPartitions$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$logPartitionLagInfo$6(ArchiverPartitionLagInfo x$9) {
        return x$9.timeFirstTierableSegmentRolled().isDefined();
    }

    public static final /* synthetic */ long $anonfun$logPartitionLagInfo$7(ArchiverPartitionLagInfo x$10) {
        return BoxesRunTime.unboxToLong((Object)x$10.timeFirstTierableSegmentRolled().get());
    }

    public static final /* synthetic */ String $anonfun$logPartitionLagInfo$8(TierArchiver $this, List partitionsWithOldestSegments$1) {
        return new StringBuilder(169).append($this.kafka$tier$tasks$archive$TierArchiver$$laggingPartitionsCount()).append(" partitions seen with lag > 0. Partitions with oldest").append(" segments awaiting archival in order of oldest time (TopicPartition, PartitionStatus, LagInBytes, OldestTimestamp):").append(" ").append(partitionsWithOldestSegments$1).toString();
    }

    public static final /* synthetic */ long $anonfun$flushTimeOfFirstTierableSegment$1(LogSegment segment) {
        return BoxesRunTime.unboxToLong((Object)segment.lastFlushedTimeMs().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> segment.lastModified()));
    }

    public TierArchiver(TierTasksConfig config, ReplicaManager replicaManager, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, CancellationContext ctx, int maxTasks, Time time, Option<DiskIOManager> diskIOManagerOpt, ExecutionContext ec) {
        this.config = config;
        this.replicaManager = replicaManager;
        this.ctx = ctx;
        this.time = time;
        this.diskThroughputListenerOpt = diskIOManagerOpt.map((Function1 & Serializable)diskIOManager -> {
            TierArchiverDiskThroughputListener diskThroughputListener = new TierArchiverDiskThroughputListener($this.time);
            diskIOManager.registerListener(diskThroughputListener);
            return diskThroughputListener;
        });
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.E2E_CHECKSUM_INVALID_COUNT_METRIC_NAME = "ArchiverE2EChecksumInvalidCount";
        this.metricsGroup().removeMetric("BytesPerSec");
        this.byteRate = this.metricsGroup().newMeter("BytesPerSec", "bytes per second", TimeUnit.SECONDS);
        this.metricsGroup().removeMetric("RetriesPerSec");
        this.retryRate = this.metricsGroup().newMeter("RetriesPerSec", "number of retries per second", TimeUnit.SECONDS);
        this.metricsGroup().removeMetric("ObjectStoreRetriableExceptionsPerSec");
        this.exceptionsRate = this.metricsGroup().newMeter("ObjectStoreRetriableExceptionsPerSec", "number of times TierObjectStoreRetriableException was invoked per second", TimeUnit.SECONDS);
        this.metricsGroup().removeMetric(this.E2E_CHECKSUM_INVALID_COUNT_METRIC_NAME());
        this.e2eChecksumInvalidCount = this.metricsGroup().newCounter(this.E2E_CHECKSUM_INVALID_COUNT_METRIC_NAME());
        this.kafka$tier$tasks$archive$TierArchiver$$totalLagValue = 0L;
        this.metricsGroup().removeMetric("TotalLag");
        this.metricsGroup().newGauge("TotalLag", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TierArchiver $outer;

            public long value() {
                return this.$outer.kafka$tier$tasks$archive$TierArchiver$$totalLagValue();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$tier$tasks$archive$TierArchiver$$totalLagValueWithoutErrorPartitions = 0L;
        this.metricsGroup().removeMetric("TotalLagWithoutErrorPartitions");
        this.metricsGroup().newGauge("TotalLagWithoutErrorPartitions", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TierArchiver $outer;

            public long value() {
                return this.$outer.kafka$tier$tasks$archive$TierArchiver$$totalLagValueWithoutErrorPartitions();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$tier$tasks$archive$TierArchiver$$partitionLagMaxValue = 0L;
        this.metricsGroup().removeMetric("PartitionLagMaxValue");
        this.metricsGroup().newGauge("PartitionLagMaxValue", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TierArchiver $outer;

            public long value() {
                return this.$outer.kafka$tier$tasks$archive$TierArchiver$$partitionLagMaxValue();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$tier$tasks$archive$TierArchiver$$laggingPartitionsCount = 0;
        this.metricsGroup().removeMetric("LaggingPartitionsCount");
        this.metricsGroup().newGauge("LaggingPartitionsCount", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TierArchiver $outer;

            public int value() {
                return this.$outer.kafka$tier$tasks$archive$TierArchiver$$laggingPartitionsCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$tier$tasks$archive$TierArchiver$$partitionTimeLagMaxValue = 0L;
        this.metricsGroup().removeMetric("PartitionTimeLagMaxValue");
        this.metricsGroup().newGauge("PartitionTimeLagMaxValue", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TierArchiver $outer;

            public long value() {
                return this.$outer.kafka$tier$tasks$archive$TierArchiver$$partitionTimeLagMaxValue();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().removeMetric("TierArchiverDiskThroughputQuota");
        this.diskThroughputListenerOpt().foreach((Function1 & Serializable)listener -> this.metricsGroup().newGauge("TierArchiverDiskThroughputQuota", (Gauge)new Gauge<Object>(null, listener){
            private final TierArchiverDiskThroughputListener listener$1;

            public double value() {
                return this.listener$1.quota();
            }
            {
                this.listener$1 = listener$1;
            }
        }));
        this.taskQueue = new ArchiverTaskQueue(ctx.subContext(), maxTasks, time, (Function1<ArchiveTask, Option<Object>>)(Function1 & Serializable)task -> this.schedulingLag((ArchiveTask)task), new ArchiverMetrics((Option<Meter>)new Some((Object)this.byteRate()), (Option<Meter>)new Some((Object)this.retryRate()), (Option<Meter>)new Some((Object)this.exceptionsRate()), (Option<Counter>)new Some((Object)this.e2eChecksumInvalidCount())), config.brokerId());
        this.workingSet = new TierTaskWorkingSet<ArchiveTask>(this.taskQueue(), replicaManager, tierTopicAppender, tierObjectStore, time, ec);
    }
}

