/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.snapshot;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.log.AbstractLog;
import kafka.server.ReplicaManager;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.TierTaskWorkingSet;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.tasks.snapshot.MetadataSnapshotMetrics;
import kafka.tier.tasks.snapshot.MetadataSnapshotTask;
import kafka.tier.tasks.snapshot.MetadataSnapshotTaskQueue;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import kafka.utils.Throttler;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005=f\u0001\u0002\u0010 \u0005!B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011!\t\u0006A!A!\u0002\u0013\u0011\u0006\u0002C+\u0001\u0005\u000b\u0007I\u0011\u0001,\t\u0011q\u0003!\u0011!Q\u0001\n]C\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006IA\u0018\u0005\tU\u0002\u0011\t\u0011)A\u0006W\")\u0011\u000f\u0001C\u0001e\"9a\u0010\u0001b\u0001\n\u0013y\b\u0002CA\b\u0001\u0001\u0006I!!\u0001\t\u0013\u0005E\u0001A1A\u0005\n\u0005M\u0001\u0002CA\u0016\u0001\u0001\u0006I!!\u0006\t\u0013\u00055\u0002A1A\u0005\n\u0005M\u0001\u0002CA\u0018\u0001\u0001\u0006I!!\u0006\t\u0013\u0005E\u0002A1A\u0005\n\u0005M\u0001\u0002CA\u001a\u0001\u0001\u0006I!!\u0006\t\u0015\u0005U\u0002A1A\u0005\u0002\u0005\n9\u0004\u0003\u0005\u0002@\u0001\u0001\u000b\u0011BA\u001d\u0011%\t\t\u0005\u0001b\u0001\n\u0013\t\u0019\u0005\u0003\u0005\u0002T\u0001\u0001\u000b\u0011BA#\u0011\u001d\t)\u0006\u0001C\u0001\u0003/Bq!a\u001e\u0001\t\u0003\tI\bC\u0004\u0002\u0002\u0002!I!a!\b\u0013\u0005=u$!A\t\u0002\u0005Ee\u0001\u0003\u0010 \u0003\u0003E\t!a%\t\rE\\B\u0011AAK\u0011%\t9jGI\u0001\n\u0003\tIJA\u000eUS\u0016\u0014X*\u001a;bI\u0006$\u0018m\u00158baNDw\u000e^'b]\u0006<WM\u001d\u0006\u0003A\u0005\n\u0001b\u001d8baNDw\u000e\u001e\u0006\u0003E\r\nQ\u0001^1tWNT!\u0001J\u0013\u0002\tQLWM\u001d\u0006\u0002M\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001*_A\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t1\u0011I\\=SK\u001a\u0004\"\u0001M\u001a\u000e\u0003ER!AM\u0013\u0002\u000bU$\u0018\u000e\\:\n\u0005Q\n$a\u0002'pO\u001eLgnZ\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\t9$(D\u00019\u0015\tIT%\u0001\u0004tKJ4XM]\u0005\u0003wa\u0012aBU3qY&\u001c\u0017-T1oC\u001e,'/A\tuS\u0016\u0014Hk\u001c9jG\u0006\u0003\b/\u001a8eKJ\u0004\"AP!\u000e\u0003}R!\u0001Q\u0012\u0002\u000bQ|\u0007/[2\n\u0005\t{$!\u0005+jKJ$v\u000e]5d\u0003B\u0004XM\u001c3fe\u0006yA/[3s\u001f\nTWm\u0019;Ti>\u0014X\r\u0005\u0002F\u00116\taI\u0003\u0002HG\u0005)1\u000f^8sK&\u0011\u0011J\u0012\u0002\u0010)&,'o\u00142kK\u000e$8\u000b^8sK\u0006\u00191\r\u001e=\u0011\u00051{U\"A'\u000b\u00059\u001b\u0013a\u00024fi\u000eDWM]\u0005\u0003!6\u00131cQ1oG\u0016dG.\u0019;j_:\u001cuN\u001c;fqR\f\u0001\"\\1y)\u0006\u001c8n\u001d\t\u0003UMK!\u0001V\u0016\u0003\u0007%sG/\u0001\u0004d_:4\u0017nZ\u000b\u0002/B\u0011\u0001LW\u0007\u00023*\u0011Q+I\u0005\u00037f\u0013q\u0002V5feR\u000b7o[:D_:4\u0017nZ\u0001\bG>tg-[4!\u0003\u0011!\u0018.\\3\u0011\u0005}CW\"\u00011\u000b\u0005I\n'B\u00012d\u0003\u0019\u0019w.\\7p]*\u0011a\u0005\u001a\u0006\u0003K\u001a\fa!\u00199bG\",'\"A4\u0002\u0007=\u0014x-\u0003\u0002jA\n!A+[7f\u0003\t)7\r\u0005\u0002m_6\tQN\u0003\u0002oW\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005Al'\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}QA1o\u001e=zundX\u0010\u0006\u0002umB\u0011Q\u000fA\u0007\u0002?!)!N\u0003a\u0002W\")QG\u0003a\u0001m!)AH\u0003a\u0001{!)1I\u0003a\u0001\t\")!J\u0003a\u0001\u0017\")\u0011K\u0003a\u0001%\")QK\u0003a\u0001/\"9QL\u0003I\u0001\u0002\u0004q\u0016\u0001D7fiJL7m]$s_V\u0004XCAA\u0001!\u0011\t\u0019!a\u0003\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\tq!\\3ue&\u001c7O\u0003\u0002:G&!\u0011QBA\u0003\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f]\u0001\u000e[\u0016$(/[2t\u000fJ|W\u000f\u001d\u0011\u0002\u0011\tLH/\u001a*bi\u0016,\"!!\u0006\u0011\t\u0005]\u0011qE\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u0005!1m\u001c:f\u0015\u0011\t9!a\b\u000b\t\u0005\u0005\u00121E\u0001\u0007s\u0006lW.\u001a:\u000b\u0005\u0005\u0015\u0012aA2p[&!\u0011\u0011FA\r\u0005\u0015iU\r^3s\u0003%\u0011\u0017\u0010^3SCR,\u0007%A\u0005sKR\u0014\u0018PU1uK\u0006Q!/\u001a;ssJ\u000bG/\u001a\u0011\u0002\u001d\u0015D8-\u001a9uS>t7OU1uK\u0006yQ\r_2faRLwN\\:SCR,\u0007%A\u0005uCN\\\u0017+^3vKV\u0011\u0011\u0011\b\t\u0004k\u0006m\u0012bAA\u001f?\tIR*\u001a;bI\u0006$\u0018m\u00158baNDw\u000e\u001e+bg.\fV/Z;f\u0003)!\u0018m]6Rk\u0016,X\rI\u0001\u000bo>\u00148.\u001b8h'\u0016$XCAA#!\u0019\t9%!\u0013\u0002N5\t\u0011%C\u0002\u0002L\u0005\u0012!\u0003V5feR\u000b7o[,pe.LgnZ*fiB\u0019Q/a\u0014\n\u0007\u0005EsD\u0001\u000bNKR\fG-\u0019;b':\f\u0007o\u001d5piR\u000b7o[\u0001\fo>\u00148.\u001b8h'\u0016$\b%\u0001\u0004e_^{'o\u001b\u000b\u0003\u00033\u0002b!a\u0017\u0002l\u0005Ed\u0002BA/\u0003OrA!a\u0018\u0002f5\u0011\u0011\u0011\r\u0006\u0004\u0003G:\u0013A\u0002\u001fs_>$h(C\u0001-\u0013\r\tIgK\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti'a\u001c\u0003\t1K7\u000f\u001e\u0006\u0004\u0003SZ\u0003#\u00027\u0002t\u00055\u0013bAA;[\n1a)\u001e;ve\u0016\f\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0003\u0003w\u00022AKA?\u0013\r\tyh\u000b\u0002\u0005+:LG/A\u0007tG\",G-\u001e7j]\u001ed\u0015m\u001a\u000b\u0005\u0003\u000b\u000bY\tE\u0002+\u0003\u000fK1!!#,\u0005\u0011auN\\4\t\u000f\u00055\u0015\u00041\u0001\u0002N\u0005!A/Y:l\u0003m!\u0016.\u001a:NKR\fG-\u0019;b':\f\u0007o\u001d5pi6\u000bg.Y4feB\u0011QoG\n\u00037%\"\"!!%\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00138+\t\tYJK\u0002_\u0003;[#!a(\u0011\t\u0005\u0005\u00161V\u0007\u0003\u0003GSA!!*\u0002(\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003S[\u0013AC1o]>$\u0018\r^5p]&!\u0011QVAR\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public final class TierMetadataSnapshotManager
implements Logging {
    private final ReplicaManager replicaManager;
    private final CancellationContext ctx;
    private final TierTasksConfig config;
    private final KafkaMetricsGroup metricsGroup;
    private final Meter byteRate;
    private final Meter retryRate;
    private final Meter exceptionsRate;
    private final MetadataSnapshotTaskQueue taskQueue;
    private final TierTaskWorkingSet<MetadataSnapshotTask> workingSet;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$7() {
        return Time.SYSTEM;
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public TierTasksConfig config() {
        return this.config;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private Meter byteRate() {
        return this.byteRate;
    }

    private Meter retryRate() {
        return this.retryRate;
    }

    private Meter exceptionsRate() {
        return this.exceptionsRate;
    }

    public MetadataSnapshotTaskQueue taskQueue() {
        return this.taskQueue;
    }

    private TierTaskWorkingSet<MetadataSnapshotTask> workingSet() {
        return this.workingSet;
    }

    public List<Future<MetadataSnapshotTask>> doWork() {
        return this.workingSet().doWork(this.config(), (Option<Throttler>)None$.MODULE$);
    }

    public void shutdown() {
        this.ctx.cancel();
        this.taskQueue().close();
    }

    private long schedulingLag(MetadataSnapshotTask task) {
        MetadataSnapshotTask.MetadataSnapshotTaskState metadataSnapshotTaskState = task.state();
        if (metadataSnapshotTaskState instanceof MetadataSnapshotTask.BeforeLeaderSnapshotState) {
            return -1L;
        }
        if (metadataSnapshotTaskState instanceof MetadataSnapshotTask.BeforeMetadataSnapshotState) {
            return BoxesRunTime.unboxToLong((Object)this.replicaManager.getLog(task.topicPartition()).map((Function1 & Serializable)log -> BoxesRunTime.boxToLong((long)TierMetadataSnapshotManager.$anonfun$schedulingLag$1(log))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        }
        if (metadataSnapshotTaskState instanceof MetadataSnapshotTask.MetadataSnapshotState) {
            return -2L;
        }
        if (metadataSnapshotTaskState instanceof MetadataSnapshotTask.AfterMetadataSnapshotState) {
            return -3L;
        }
        if (metadataSnapshotTaskState instanceof MetadataSnapshotTask.MetadataSnapshotGarbageCollectionState) {
            return -4L;
        }
        if (metadataSnapshotTaskState instanceof MetadataSnapshotTask.FailedMetadataSnapshotState) {
            return -5L;
        }
        throw new MatchError((Object)metadataSnapshotTaskState);
    }

    public static final /* synthetic */ long $anonfun$schedulingLag$1(AbstractLog log) {
        return log.tierPartitionState().lastSnapshotTimestampMs();
    }

    public TierMetadataSnapshotManager(ReplicaManager replicaManager, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, CancellationContext ctx, int maxTasks, TierTasksConfig config, Time time, ExecutionContext ec) {
        this.replicaManager = replicaManager;
        this.ctx = ctx;
        this.config = config;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.metricsGroup().removeMetric("BytesPerSec");
        this.byteRate = this.metricsGroup().newMeter("BytesPerSec", "bytes per second", TimeUnit.SECONDS);
        this.metricsGroup().removeMetric("RetriesPerSec");
        this.retryRate = this.metricsGroup().newMeter("RetriesPerSec", "number of retries per second", TimeUnit.SECONDS);
        this.metricsGroup().removeMetric("ObjectStoreRetriableExceptionsPerSec");
        this.exceptionsRate = this.metricsGroup().newMeter("ObjectStoreRetriableExceptionsPerSec", "number of times TierObjectStoreRetriableException was invoked per second", TimeUnit.SECONDS);
        this.taskQueue = new MetadataSnapshotTaskQueue(ctx.subContext(), maxTasks, time, (Function1<MetadataSnapshotTask, Object>)(Function1 & Serializable)task -> BoxesRunTime.boxToLong((long)this.schedulingLag(task)), new MetadataSnapshotMetrics((Option<Meter>)new Some((Object)this.byteRate()), (Option<Meter>)new Some((Object)this.retryRate()), (Option<Meter>)new Some((Object)this.exceptionsRate())), config.brokerId());
        this.workingSet = new TierTaskWorkingSet<MetadataSnapshotTask>(this.taskQueue(), replicaManager, tierTopicAppender, tierObjectStore, time, ec);
    }
}

