/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.rest;

import io.confluent.kafka.secretregistry.client.rest.Versions;
import io.confluent.kafka.secretregistry.exceptions.SecretRegistryInitializationException;
import io.confluent.rest.RestConfig;
import io.confluent.rest.RestConfigException;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Iterable;
import scala.jdk.javaapi.CollectionConverters;

public class SecretRegistryConfig
extends RestConfig {
    private static final Logger log = LoggerFactory.getLogger(SecretRegistryConfig.class);
    public static final int SECRETREGISTRY_PORT_DEFAULT = 8081;
    public static final String SECRETREGISTRY_LISTENERS_DEFAULT = "";
    public static final String SECRETREGISTRY_GROUP_ID_CONFIG = "secret.registry.group.id";
    public static final String KAFKASTORE_BOOTSTRAP_SERVERS_CONFIG = "kafkastore.bootstrap.servers";
    public static final String KAFKASTORE_GROUP_ID_CONFIG = "kafkastore.group.id";
    public static final String KAFKASTORE_TOPIC_CONFIG = "kafkastore.topic";
    public static final String DEFAULT_KAFKASTORE_TOPIC = "_confluent-secrets";
    public static final String KAFKASTORE_TOPIC_REPLICATION_FACTOR_CONFIG = "kafkastore.topic.replication.factor";
    public static final int DEFAULT_KAFKASTORE_TOPIC_REPLICATION_FACTOR = 3;
    public static final String KAFKASTORE_TIMEOUT_CONFIG = "kafkastore.timeout.ms";
    public static final String KAFKASTORE_INIT_TIMEOUT_CONFIG = "kafkastore.init.timeout.ms";
    public static final String MASTER_ELIGIBILITY = "master.eligibility";
    public static final boolean DEFAULT_MASTER_ELIGIBILITY = true;
    public static final String HOST_NAME_CONFIG = "host.name";
    public static final String KAFKASTORE_SECURITY_PROTOCOL_CONFIG = "kafkastore.security.protocol";
    public static final String KAFKASTORE_SSL_TRUSTSTORE_LOCATION_CONFIG = "kafkastore.ssl.truststore.location";
    public static final String KAFKASTORE_SSL_TRUSTSTORE_PASSWORD_CONFIG = "kafkastore.ssl.truststore.password";
    public static final String KAFKASTORE_SSL_KEYSTORE_LOCATION_CONFIG = "kafkastore.ssl.keystore.location";
    public static final String KAFKASTORE_SSL_TRUSTSTORE_TYPE_CONFIG = "kafkastore.ssl.truststore.type";
    public static final String KAFKASTORE_SSL_TRUSTMANAGER_ALGORITHM_CONFIG = "kafkastore.ssl.trustmanager.algorithm";
    public static final String KAFKASTORE_SSL_KEYSTORE_PASSWORD_CONFIG = "kafkastore.ssl.keystore.password";
    public static final String KAFKASTORE_SSL_KEYSTORE_TYPE_CONFIG = "kafkastore.ssl.keystore.type";
    public static final String KAFKASTORE_SSL_KEYMANAGER_ALGORITHM_CONFIG = "kafkastore.ssl.keymanager.algorithm";
    public static final String KAFKASTORE_SSL_KEY_PASSWORD_CONFIG = "kafkastore.ssl.key.password";
    public static final String KAFKASTORE_SSL_ENABLED_PROTOCOLS_CONFIG = "kafkastore.ssl.enabled.protocols";
    public static final String KAFKASTORE_SSL_PROTOCOL_CONFIG = "kafkastore.ssl.protocol";
    public static final String KAFKASTORE_SSL_PROVIDER_CONFIG = "kafkastore.ssl.provider";
    public static final String KAFKASTORE_SSL_CIPHER_SUITES_CONFIG = "kafkastore.ssl.cipher.suites";
    public static final String KAFKASTORE_SSL_ENDPOINT_IDENTIFICATION_ALGORITHM_CONFIG = "kafkastore.ssl.endpoint.identification.algorithm";
    public static final String KAFKASTORE_SASL_KERBEROS_SERVICE_NAME_CONFIG = "kafkastore.sasl.kerberos.service.name";
    public static final String KAFKASTORE_SASL_MECHANISM_CONFIG = "kafkastore.sasl.mechanism";
    public static final String KAFKASTORE_SASL_KERBEROS_KINIT_CMD_CONFIG = "kafkastore.sasl.kerberos.kinit.cmd";
    public static final String KAFKASTORE_SASL_KERBEROS_MIN_TIME_BEFORE_RELOGIN_CONFIG = "kafkastore.sasl.kerberos.min.time.before.relogin";
    public static final String KAFKASTORE_SASL_KERBEROS_TICKET_RENEW_JITTER_CONFIG = "kafkastore.sasl.kerberos.ticket.renew.jitter";
    public static final String KAFKASTORE_SASL_KERBEROS_TICKET_RENEW_WINDOW_FACTOR_CONFIG = "kafkastore.sasl.kerberos.ticket.renew.window.factor";
    public static final String RESOURCE_EXTENSION_CONFIG = "resource.extension.class";
    public static final String RESOURCE_STATIC_LOCATIONS_CONFIG = "resource.static.locations";
    public static final String INTER_INSTANCE_PROTOCOL_CONFIG = "inter.instance.protocol";
    public static final String INTER_INSTANCE_HEADERS_WHITELIST_CONFIG = "inter.instance.headers.whitelist";
    public static final String MASTER_ENCRYPTION_KEY_CONFIG = "master.encryption.key";
    public static final String MASTER_ENCRYPTION_OLD_KEY_CONFIG = "master.encryption.old.key";
    protected static final String SECRETREGISTRY_GROUP_ID_DOC = "Use this setting to override the group.id for the Kafka group used when Kafka is used for master election.\nWithout this configuration, group.id will be \"secret-registry\". If you want to run more than one secret registry cluster against a single Kafka cluster you should make this setting unique for each cluster.";
    protected static final String KAFKASTORE_BOOTSTRAP_SERVERS_DOC = "A list of Kafka brokers to connect to. For example, `PLAINTEXT://hostname:9092,SSL://hostname2:9092`\n\nThe Kafka cluster containing these bootstrap servers will be used both to coordinate secret registry instances (master election) and store secret data.\nBy specifiying this configuration, you can control which endpoints are used to connect to Kafka. Kafka may expose multiple endpoints that all will be stored in ZooKeeper, but the Secret Registry may need to be configured with just one of those endpoints, for example to control which security protocol it uses.";
    protected static final String KAFKASTORE_GROUP_ID_DOC = "Use this setting to override the group.id for the KafkaStore consumer.\nThis setting can become important when security is enabled, to ensure stability over the secret registry consumer's group.id\nWithout this configuration, group.id will be \"secret-registry-<host>-<port>\"";
    protected static final String KAFKASTORE_TOPIC_DOC = "The durable single partition topic that actsas the durable log for the data";
    protected static final String KAFKASTORE_TOPIC_REPLICATION_FACTOR_DOC = "The desired replication factor of the secret topic. The actual replication factor will be the smaller of this value and the number of live Kafka brokers.";
    protected static final String KAFKASTORE_WRITE_RETRIES_DOC = "Retry a failed register secret request to the underlying Kafka store up to this many times,  for example in case of a Kafka broker failure";
    protected static final String KAFKASTORE_WRITE_RETRY_BACKOFF_MS_DOC = "The amount of time in milliseconds to wait before attempting to retry a failed write to the Kafka store";
    protected static final String KAFKASTORE_INIT_TIMEOUT_DOC = "The timeout for initialization of the Kafka store, including creation of the Kafka topic that stores secret data.";
    protected static final String KAFKASTORE_TIMEOUT_DOC = "The timeout for an operation on the Kafka store";
    protected static final String HOST_DOC = "The host name advertised in Zookeeper. Make sure to set this if running SecretRegistry with multiple nodes.";
    protected static final String MASTER_ELIGIBILITY_DOC = "If true, this node can participate in master election. In a multi-colo setup, turn this off for clusters in the slave data center.";
    protected static final String KAFKASTORE_SECURITY_PROTOCOL_DOC = "The security protocol to use when connecting with Kafka, the underlying persistent storage. Values can be `PLAINTEXT`, `SSL`, `SASL_PLAINTEXT`, or `SASL_SSL`.";
    protected static final String KAFKASTORE_SSL_TRUSTSTORE_LOCATION_DOC = "The location of the SSL trust store file.";
    protected static final String KAFKASTORE_SSL_TRUSTSTORE_PASSWORD_DOC = "The password to access the trust store.";
    protected static final String KAFAKSTORE_SSL_TRUSTSTORE_TYPE_DOC = "The file format of the trust store.";
    protected static final String KAFKASTORE_SSL_TRUSTMANAGER_ALGORITHM_DOC = "The algorithm used by the trust manager factory for SSL connections.";
    protected static final String KAFKASTORE_SSL_KEYSTORE_LOCATION_DOC = "The location of the SSL keystore file.";
    protected static final String KAFKASTORE_SSL_KEYSTORE_PASSWORD_DOC = "The password to access the keystore.";
    protected static final String KAFAKSTORE_SSL_KEYSTORE_TYPE_DOC = "The file format of the keystore.";
    protected static final String KAFKASTORE_SSL_KEYMANAGER_ALGORITHM_DOC = "The algorithm used by key manager factory for SSL connections.";
    protected static final String KAFKASTORE_SSL_KEY_PASSWORD_DOC = "The password of the key contained in the keystore.";
    protected static final String KAFAKSTORE_SSL_ENABLED_PROTOCOLS_DOC = "Protocols enabled for SSL connections.";
    protected static final String KAFAKSTORE_SSL_PROTOCOL_DOC = "The SSL protocol used.";
    protected static final String KAFAKSTORE_SSL_PROVIDER_DOC = "The name of the security provider used for SSL.";
    protected static final String KAFKASTORE_SSL_CIPHER_SUITES_DOC = "A list of cipher suites used for SSL.";
    protected static final String KAFKASTORE_SSL_ENDPOINT_IDENTIFICATION_ALGORITHM_DOC = "The endpoint identification algorithm to validate the server hostname using the server certificate.";
    public static final String KAFKASTORE_SASL_KERBEROS_SERVICE_NAME_DOC = "The Kerberos principal name that the Kafka client runs as. This can be defined either in the JAAS config file or here.";
    public static final String KAFKASTORE_SASL_MECHANISM_DOC = "The SASL mechanism used for Kafka connections. GSSAPI is the default.";
    public static final String KAFKASTORE_SASL_KERBEROS_KINIT_CMD_DOC = "The Kerberos kinit command path.";
    public static final String KAFKASTORE_SASL_KERBEROS_MIN_TIME_BEFORE_RELOGIN_DOC = "The login time between refresh attempts.";
    public static final String KAFKASTORE_SASL_KERBEROS_TICKET_RENEW_JITTER_DOC = "The percentage of random jitter added to the renewal time.";
    public static final String KAFKASTORE_SASL_KERBEROS_TICKET_RENEW_WINDOW_FACTOR_DOC = "Login thread will sleep until the specified window factor of time from last refresh to ticket's expiry has been reached, at which time it will try to renew the ticket.";
    protected static final String SECRETREGISTRY_RESOURCE_EXTENSION_DOC = "  A list of classes to use as SecretRegistryResourceExtension. Implementing the interface  <code>SecretRegistryResourceExtension</code> allows you to inject user defined resources  like filters to Secret Registry. Typically used to add custom capability like logging,  security, etc.";
    protected static final String RESOURCE_STATIC_LOCATIONS_DOC = "  A list of classpath resources containing static resources to serve using the default servlet.";
    protected static final String SECRETREGISTRY_INTER_INSTANCE_PROTOCOL_DOC = "The protocol used while making calls between the instances of secret registry. The slave to master node calls for writes and deletes will use the specified protocol. The default value would be `http`. When `https` is set, `ssl.keystore.` and `ssl.truststore.` configs are used while making the call.";
    protected static final String MASTER_ENCRYPTION_KEY_DOC = "The master key used to encrypt and decrypt secrets.";
    protected static final String MASTER_ENCRYPTION_OLD_KEY_DOC = "The old master key that was used to encrypt and decrypt secrets.  This is only required when the master key is updated. If specified, all secrets are decrypted using thisold key and re-encrypted using the new key.";
    protected static final String INTER_INSTANCE_HEADERS_WHITELIST_DOC = "A list of ``http`` headers to forward from slave to master, in addition to ``Content-Type``, ``Accept``, ``Authorization``.";
    private static final String METRICS_JMX_PREFIX_DEFAULT_OVERRIDE = "kafka.secret.registry";
    private static final ConfigDef config = SecretRegistryConfig.baseSecretRegistryConfigDef();
    public static final String HTTPS = "https";
    public static final String HTTP = "http";
    private Properties originalProperties;

    public static ConfigDef baseSecretRegistryConfigDef() {
        return SecretRegistryConfig.baseConfigDef((int)8081, (String)SECRETREGISTRY_LISTENERS_DEFAULT, (String)String.join((CharSequence)",", Versions.PREFERRED_RESPONSE_TYPES), (String)"application/vnd.secretregistry.v1+json", (String)METRICS_JMX_PREFIX_DEFAULT_OVERRIDE).define(KAFKASTORE_BOOTSTRAP_SERVERS_CONFIG, ConfigDef.Type.LIST, (Object)SECRETREGISTRY_LISTENERS_DEFAULT, ConfigDef.Importance.MEDIUM, KAFKASTORE_BOOTSTRAP_SERVERS_DOC).define(SECRETREGISTRY_GROUP_ID_CONFIG, ConfigDef.Type.STRING, (Object)"secret-registry", ConfigDef.Importance.MEDIUM, SECRETREGISTRY_GROUP_ID_DOC).define(INTER_INSTANCE_HEADERS_WHITELIST_CONFIG, ConfigDef.Type.LIST, (Object)SECRETREGISTRY_LISTENERS_DEFAULT, ConfigDef.Importance.LOW, INTER_INSTANCE_HEADERS_WHITELIST_DOC).define(KAFKASTORE_TOPIC_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_KAFKASTORE_TOPIC, ConfigDef.Importance.HIGH, KAFKASTORE_TOPIC_DOC).define(KAFKASTORE_TOPIC_REPLICATION_FACTOR_CONFIG, ConfigDef.Type.INT, (Object)3, ConfigDef.Importance.HIGH, KAFKASTORE_TOPIC_REPLICATION_FACTOR_DOC).define(KAFKASTORE_INIT_TIMEOUT_CONFIG, ConfigDef.Type.INT, (Object)60000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, KAFKASTORE_INIT_TIMEOUT_DOC).define(KAFKASTORE_TIMEOUT_CONFIG, ConfigDef.Type.INT, (Object)500, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, KAFKASTORE_TIMEOUT_DOC).define(HOST_NAME_CONFIG, ConfigDef.Type.STRING, (Object)SecretRegistryConfig.getDefaultHost(), ConfigDef.Importance.HIGH, HOST_DOC).define(MASTER_ELIGIBILITY, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.MEDIUM, MASTER_ELIGIBILITY_DOC).define(KAFKASTORE_SECURITY_PROTOCOL_CONFIG, ConfigDef.Type.STRING, (Object)SecurityProtocol.PLAINTEXT.toString(), ConfigDef.Importance.MEDIUM, KAFKASTORE_SECURITY_PROTOCOL_DOC).define(KAFKASTORE_SSL_TRUSTSTORE_LOCATION_CONFIG, ConfigDef.Type.STRING, (Object)SECRETREGISTRY_LISTENERS_DEFAULT, ConfigDef.Importance.HIGH, KAFKASTORE_SSL_TRUSTSTORE_LOCATION_DOC).define(KAFKASTORE_SSL_TRUSTSTORE_PASSWORD_CONFIG, ConfigDef.Type.PASSWORD, (Object)SECRETREGISTRY_LISTENERS_DEFAULT, ConfigDef.Importance.HIGH, KAFKASTORE_SSL_TRUSTSTORE_PASSWORD_DOC).define(KAFKASTORE_SSL_TRUSTSTORE_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)"JKS", ConfigDef.Importance.MEDIUM, KAFAKSTORE_SSL_TRUSTSTORE_TYPE_DOC).define(KAFKASTORE_SSL_TRUSTMANAGER_ALGORITHM_CONFIG, ConfigDef.Type.STRING, (Object)"PKIX", ConfigDef.Importance.LOW, KAFKASTORE_SSL_TRUSTMANAGER_ALGORITHM_DOC).define(KAFKASTORE_SSL_KEYSTORE_LOCATION_CONFIG, ConfigDef.Type.STRING, (Object)SECRETREGISTRY_LISTENERS_DEFAULT, ConfigDef.Importance.HIGH, KAFKASTORE_SSL_KEYSTORE_LOCATION_DOC).define(KAFKASTORE_SSL_KEYSTORE_PASSWORD_CONFIG, ConfigDef.Type.PASSWORD, (Object)SECRETREGISTRY_LISTENERS_DEFAULT, ConfigDef.Importance.HIGH, KAFKASTORE_SSL_KEYSTORE_PASSWORD_DOC).define(KAFKASTORE_SSL_KEYSTORE_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)"JKS", ConfigDef.Importance.MEDIUM, KAFAKSTORE_SSL_KEYSTORE_TYPE_DOC).define(KAFKASTORE_SSL_KEYMANAGER_ALGORITHM_CONFIG, ConfigDef.Type.STRING, (Object)"SunX509", ConfigDef.Importance.LOW, KAFKASTORE_SSL_KEYMANAGER_ALGORITHM_DOC).define(KAFKASTORE_SSL_KEY_PASSWORD_CONFIG, ConfigDef.Type.PASSWORD, (Object)SECRETREGISTRY_LISTENERS_DEFAULT, ConfigDef.Importance.HIGH, KAFKASTORE_SSL_KEY_PASSWORD_DOC).define(KAFKASTORE_SSL_ENABLED_PROTOCOLS_CONFIG, ConfigDef.Type.STRING, (Object)"TLSv1.2,TLSv1.1,TLSv1", ConfigDef.Importance.MEDIUM, KAFAKSTORE_SSL_ENABLED_PROTOCOLS_DOC).define(KAFKASTORE_SSL_PROTOCOL_CONFIG, ConfigDef.Type.STRING, (Object)"TLS", ConfigDef.Importance.MEDIUM, KAFAKSTORE_SSL_PROTOCOL_DOC).define(KAFKASTORE_SSL_PROVIDER_CONFIG, ConfigDef.Type.STRING, (Object)SECRETREGISTRY_LISTENERS_DEFAULT, ConfigDef.Importance.MEDIUM, KAFAKSTORE_SSL_PROVIDER_DOC).define(KAFKASTORE_SSL_CIPHER_SUITES_CONFIG, ConfigDef.Type.STRING, (Object)SECRETREGISTRY_LISTENERS_DEFAULT, ConfigDef.Importance.LOW, KAFKASTORE_SSL_CIPHER_SUITES_DOC).define(KAFKASTORE_SSL_ENDPOINT_IDENTIFICATION_ALGORITHM_CONFIG, ConfigDef.Type.STRING, (Object)SECRETREGISTRY_LISTENERS_DEFAULT, ConfigDef.Importance.LOW, KAFKASTORE_SSL_ENDPOINT_IDENTIFICATION_ALGORITHM_DOC).define(KAFKASTORE_SASL_KERBEROS_SERVICE_NAME_CONFIG, ConfigDef.Type.STRING, (Object)SECRETREGISTRY_LISTENERS_DEFAULT, ConfigDef.Importance.MEDIUM, KAFKASTORE_SASL_KERBEROS_SERVICE_NAME_DOC).define(KAFKASTORE_SASL_MECHANISM_CONFIG, ConfigDef.Type.STRING, (Object)"GSSAPI", ConfigDef.Importance.MEDIUM, KAFKASTORE_SASL_MECHANISM_DOC).define(KAFKASTORE_SASL_KERBEROS_KINIT_CMD_CONFIG, ConfigDef.Type.STRING, (Object)"/usr/bin/kinit", ConfigDef.Importance.LOW, KAFKASTORE_SASL_KERBEROS_KINIT_CMD_DOC).define(KAFKASTORE_SASL_KERBEROS_MIN_TIME_BEFORE_RELOGIN_CONFIG, ConfigDef.Type.LONG, (Object)60000, ConfigDef.Importance.LOW, KAFKASTORE_SASL_KERBEROS_MIN_TIME_BEFORE_RELOGIN_DOC).define(KAFKASTORE_SASL_KERBEROS_TICKET_RENEW_JITTER_CONFIG, ConfigDef.Type.DOUBLE, (Object)0.05, ConfigDef.Importance.LOW, KAFKASTORE_SASL_KERBEROS_TICKET_RENEW_JITTER_DOC).define(KAFKASTORE_SASL_KERBEROS_TICKET_RENEW_WINDOW_FACTOR_CONFIG, ConfigDef.Type.DOUBLE, (Object)0.8, ConfigDef.Importance.LOW, KAFKASTORE_SASL_KERBEROS_TICKET_RENEW_WINDOW_FACTOR_DOC).define(KAFKASTORE_GROUP_ID_CONFIG, ConfigDef.Type.STRING, (Object)SECRETREGISTRY_LISTENERS_DEFAULT, ConfigDef.Importance.LOW, KAFKASTORE_GROUP_ID_DOC).define(RESOURCE_EXTENSION_CONFIG, ConfigDef.Type.LIST, (Object)SECRETREGISTRY_LISTENERS_DEFAULT, ConfigDef.Importance.LOW, SECRETREGISTRY_RESOURCE_EXTENSION_DOC).define(RESOURCE_STATIC_LOCATIONS_CONFIG, ConfigDef.Type.LIST, (Object)SECRETREGISTRY_LISTENERS_DEFAULT, ConfigDef.Importance.LOW, RESOURCE_STATIC_LOCATIONS_DOC).define(INTER_INSTANCE_PROTOCOL_CONFIG, ConfigDef.Type.STRING, (Object)HTTP, ConfigDef.Importance.LOW, SECRETREGISTRY_INTER_INSTANCE_PROTOCOL_DOC).define(MASTER_ENCRYPTION_KEY_CONFIG, ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.HIGH, MASTER_ENCRYPTION_KEY_DOC).define(MASTER_ENCRYPTION_OLD_KEY_CONFIG, ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.HIGH, MASTER_ENCRYPTION_OLD_KEY_DOC);
    }

    private static Properties getPropsFromFile(String propsFile) throws ConfigException {
        Properties props = new Properties();
        if (propsFile == null) {
            return props;
        }
        try (FileInputStream propStream = new FileInputStream(propsFile);){
            props.load(propStream);
        }
        catch (IOException e) {
            throw new ConfigException("Couldn't load properties from " + propsFile, (Object)e);
        }
        return props;
    }

    public SecretRegistryConfig(String propsFile) throws RestConfigException {
        this(SecretRegistryConfig.getPropsFromFile(propsFile));
    }

    public SecretRegistryConfig(Properties props) throws RestConfigException {
        this(config, props);
    }

    public SecretRegistryConfig(ConfigDef configDef, Properties props) throws RestConfigException {
        super(configDef, (Map)props);
        this.originalProperties = props;
    }

    private static String getDefaultHost() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            throw new ConfigException("Unknown local hostname", (Object)e);
        }
    }

    public Properties originalProperties() {
        return this.originalProperties;
    }

    public String masterEncryptionKey() throws SecretRegistryInitializationException {
        Password key = this.getPassword(MASTER_ENCRYPTION_KEY_CONFIG);
        String masterKey = key != null ? key.value() : System.getenv("MASTER_ENCRYPTION_KEY");
        if (masterKey == null) {
            throw new SecretRegistryInitializationException("Could not obtain master key");
        }
        return masterKey;
    }

    public String masterEncryptionOldKey() {
        Password key = this.getPassword(MASTER_ENCRYPTION_OLD_KEY_CONFIG);
        String masterKey = key != null ? key.value() : System.getenv("MASTER_ENCRYPTION_OLD_KEY");
        return masterKey;
    }

    public String bootstrapBrokers() {
        List bootstrapServersConfig = this.getList(KAFKASTORE_BOOTSTRAP_SERVERS_CONFIG);
        if (bootstrapServersConfig.isEmpty()) {
            throw new ConfigException("Missing configuration for kafkastore.bootstrap.servers");
        }
        return SecretRegistryConfig.endpointsToBootstrapServers(bootstrapServersConfig, this.getString(KAFKASTORE_SECURITY_PROTOCOL_CONFIG));
    }

    static List<String> brokersToEndpoints(List<Broker> brokers) {
        LinkedList<String> endpoints = new LinkedList<String>();
        for (Broker broker : brokers) {
            for (EndPoint ep : CollectionConverters.asJavaCollection((Iterable)broker.endPoints())) {
                String hostport = ep.host() == null ? ":" + ep.port() : Utils.formatAddress((String)ep.host(), (Integer)ep.port());
                String endpoint = ep.securityProtocol() + "://" + hostport;
                endpoints.add(endpoint);
            }
        }
        return endpoints;
    }

    static String endpointsToBootstrapServers(List<String> endpoints, String securityProtocol) {
        HashSet supportedSecurityProtocols = new HashSet(SecurityProtocol.names());
        if (!supportedSecurityProtocols.contains(securityProtocol.toUpperCase(Locale.ROOT))) {
            throw new ConfigException("Only PLAINTEXT, SSL, SASL_PLAINTEXT, and SASL_SSL Kafka endpoints are supported.");
        }
        String securityProtocolUrlPrefix = securityProtocol + "://";
        StringBuilder sb = new StringBuilder();
        for (String endpoint : endpoints) {
            if (!endpoint.startsWith(securityProtocolUrlPrefix)) {
                if (endpoint.contains("://")) {
                    log.warn("Ignoring Kafka broker endpoint " + endpoint + " that does not match the setting for " + KAFKASTORE_SECURITY_PROTOCOL_CONFIG + "=" + securityProtocol);
                    continue;
                }
                endpoint = securityProtocolUrlPrefix + endpoint;
            }
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(endpoint);
        }
        if (sb.length() == 0) {
            throw new ConfigException("No supported Kafka endpoints are configured. Either kafkastore.bootstrap.servers must have at least one endpoint matching kafkastore.security.protocol or broker endpoints loaded from ZooKeeper must have at least one endpoint matching kafkastore.security.protocol.");
        }
        return sb.toString();
    }

    public String definedResourceExtensionConfigName() {
        return RESOURCE_EXTENSION_CONFIG;
    }

    public List<String> getStaticLocations() {
        return this.getList(RESOURCE_STATIC_LOCATIONS_CONFIG);
    }

    public String interInstanceProtocol() {
        return this.getString(INTER_INSTANCE_PROTOCOL_CONFIG);
    }

    public List<String> whitelistHeaders() {
        return this.getList(INTER_INSTANCE_HEADERS_WHITELIST_CONFIG);
    }

    public static void main(String[] args) {
        System.out.println(config.toRst());
    }
}

