/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.rest;

import io.confluent.kafka.secretregistry.exceptions.SecretRegistryException;
import io.confluent.kafka.secretregistry.rest.SecretRegistryConfig;
import io.confluent.kafka.secretregistry.rest.SslFactory;
import io.confluent.kafka.secretregistry.rest.extensions.SecretRegistryResourceExtension;
import io.confluent.kafka.secretregistry.rest.resources.PathKeyResource;
import io.confluent.kafka.secretregistry.rest.resources.PathKeyVersionResource;
import io.confluent.kafka.secretregistry.rest.resources.PathResource;
import io.confluent.kafka.secretregistry.rest.resources.RootResource;
import io.confluent.kafka.secretregistry.storage.KafkaSecretRegistry;
import io.confluent.kafka.secretregistry.storage.UriInfo;
import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.RestConfigException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.core.Configurable;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretRegistryRestApplication
extends Application<SecretRegistryConfig> {
    private static final Logger log = LoggerFactory.getLogger(SecretRegistryRestApplication.class);
    private KafkaSecretRegistry secretRegistry = null;
    private List<SecretRegistryResourceExtension> secretRegistryResourceExtensions = null;
    private static final String USE_ADVERTISED_ENDPOINTS_CONFIG = "secret.registry.use.advertised.endpoints";
    private static final String REST_ADVERTISED_HOST_NAME_CONFIG = "rest.advertised.host.name";
    private static final String REST_ADVERTISED_PORT_CONFIG = "rest.advertised.port";
    private static final String REST_ADVERTISED_LISTENER_CONFIG = "rest.advertised.listener";
    private static final boolean USE_ADVERTISED_ENDPOINTS_DEFAULT = false;

    public SecretRegistryRestApplication(Properties props) throws RestConfigException {
        this(new SecretRegistryConfig(props));
    }

    public SecretRegistryRestApplication(SecretRegistryConfig config) {
        super((RestConfig)SecretRegistryRestApplication.modifyConfigForAdvertisedEndpoints(config));
    }

    private static boolean shouldUseAdvertisedEndpoints(SecretRegistryConfig config) {
        return Boolean.parseBoolean(((Object)config.originals().getOrDefault(USE_ADVERTISED_ENDPOINTS_CONFIG, false)).toString());
    }

    private static SecretRegistryConfig modifyConfigForAdvertisedEndpoints(SecretRegistryConfig originalConfig) {
        if (!SecretRegistryRestApplication.shouldUseAdvertisedEndpoints(originalConfig)) {
            return originalConfig;
        }
        String advertisedHost = originalConfig.getString(REST_ADVERTISED_HOST_NAME_CONFIG);
        Integer advertisedPort = originalConfig.getInt(REST_ADVERTISED_PORT_CONFIG);
        String advertisedListener = originalConfig.getString(REST_ADVERTISED_LISTENER_CONFIG);
        if (advertisedPort != null && advertisedListener != null) {
            Properties modifiedProps = new Properties();
            modifiedProps.putAll((Map<?, ?>)originalConfig.originalProperties());
            String bindingHost = advertisedHost != null ? advertisedHost : "0.0.0.0";
            String newListener = advertisedListener + "://" + bindingHost + ":" + advertisedPort;
            modifiedProps.setProperty("listeners", newListener);
            log.info("Using advertised endpoints for binding: {}", (Object)newListener);
            try {
                return new SecretRegistryConfig(modifiedProps);
            }
            catch (Exception e) {
                log.warn("Failed to create modified config with advertised endpoints, using original config", (Throwable)e);
                return originalConfig;
            }
        }
        return originalConfig;
    }

    protected KafkaSecretRegistry initSecretRegistry(SecretRegistryConfig config) {
        KafkaSecretRegistry kafkaSecretRegistry = null;
        try {
            UriInfo uriInfo;
            kafkaSecretRegistry = new KafkaSecretRegistry(config);
            kafkaSecretRegistry.initStore();
            if (SecretRegistryRestApplication.shouldUseAdvertisedEndpoints(config)) {
                String advertisedHost = config.getString(REST_ADVERTISED_HOST_NAME_CONFIG);
                Integer advertisedPort = config.getInt(REST_ADVERTISED_PORT_CONFIG);
                String advertisedListener = config.getString(REST_ADVERTISED_LISTENER_CONFIG);
                uriInfo = KafkaSecretRegistry.getUriInfoForIdentity(advertisedHost != null ? advertisedHost : config.getString("host.name"), advertisedPort != null ? advertisedPort : config.getInt("port"), config.getList("listeners"), advertisedListener != null ? advertisedListener : config.interInstanceProtocol(), true);
            } else {
                uriInfo = KafkaSecretRegistry.getUriInfoForIdentity(config.getString("host.name"), config.getInt("port"), config.getList("listeners"), config.interInstanceProtocol());
            }
            kafkaSecretRegistry.initRest(new SslFactory(config), uriInfo);
        }
        catch (SecretRegistryException e) {
            log.error("Error starting the secret registry", (Throwable)e);
            this.onShutdown();
            throw new RuntimeException(e);
        }
        return kafkaSecretRegistry;
    }

    public void setupResources(Configurable<?> config, SecretRegistryConfig secretRegistryConfig) {
        this.secretRegistry = this.initSecretRegistry(secretRegistryConfig);
        this.secretRegistryResourceExtensions = secretRegistryConfig.getConfiguredInstances(secretRegistryConfig.definedResourceExtensionConfigName(), SecretRegistryResourceExtension.class);
        config.register(RootResource.class);
        config.register((Object)new PathResource(this.secretRegistry));
        config.register((Object)new PathKeyResource(this.secretRegistry));
        config.register((Object)new PathKeyVersionResource(this.secretRegistry));
        if (this.secretRegistryResourceExtensions != null) {
            try {
                for (SecretRegistryResourceExtension secretRegistryResourceExtension : this.secretRegistryResourceExtensions) {
                    secretRegistryResourceExtension.register(config, secretRegistryConfig, this.secretRegistry);
                }
            }
            catch (SecretRegistryException e) {
                log.error("Error starting the secret registry", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    protected ResourceCollection getStaticResources() {
        List<String> locations = ((SecretRegistryConfig)this.config).getStaticLocations();
        if (locations != null && !locations.isEmpty()) {
            Resource[] resources = (Resource[])locations.stream().map(Resource::newClassPathResource).toArray(Resource[]::new);
            return new ResourceCollection(resources);
        }
        return super.getStaticResources();
    }

    public void onShutdown() {
        if (this.secretRegistry != null) {
            this.secretRegistry.close();
        }
        if (this.secretRegistryResourceExtensions != null) {
            for (SecretRegistryResourceExtension secretRegistryResourceExtension : this.secretRegistryResourceExtensions) {
                try {
                    secretRegistryResourceExtension.close();
                }
                catch (IOException e) {
                    log.error("Error closing the extension resource", (Throwable)e);
                }
            }
        }
    }

    public KafkaSecretRegistry secretRegistry() {
        return this.secretRegistry;
    }
}

