/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.mqtt;

import io.confluent.license.InvalidLicenseException;
import io.confluent.license.LicenseManager;
import io.confluent.mqtt.ExitStatus;
import io.confluent.mqtt.MqttConfig;
import io.confluent.mqtt.PipelineFactory;
import io.confluent.mqtt.ProxyServer;
import io.confluent.mqtt.network.netty.NettyProxyFactory;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaMqttMain {
    private static final Class<?> CURRENT_CLASS = KafkaMqttMain.class;
    private static final Logger log = LoggerFactory.getLogger(CURRENT_CLASS);

    public static void main(String[] args) {
        if (args.length < 1) {
            log.info("Usage: {} <kafka-mqtt properties file>", (Object)CURRENT_CLASS.getSimpleName());
            Exit.exit((int)ExitStatus.INVALID.code());
        }
        try {
            Time time = Time.SYSTEM;
            log.info("Kafka-MQTT initializing ...");
            long initStart = time.hiResClockMs();
            String proxyPropsFile = args[0];
            Map proxyProps = !proxyPropsFile.isEmpty() ? Utils.propsToStringMap((Properties)Utils.loadProps((String)proxyPropsFile)) : Collections.emptyMap();
            MqttConfig config = KafkaMqttMain.newConfig(proxyProps);
            KafkaMqttMain.start(config, initStart, time, true);
        }
        catch (Throwable t) {
            log.error("Stopping Kafka-MQTT due to error", t);
            Exit.exit((int)ExitStatus.ERROR.code());
        }
    }

    public static void start(MqttConfig config, long initStart, Time time, boolean blockOnStop) {
        KafkaMqttMain.checkLicense(config);
        log.info("Creating network factory...");
        NettyProxyFactory proxyFactory = new NettyProxyFactory(config);
        log.info("Creating event pipeline factory...");
        PipelineFactory pipelineFactory = new PipelineFactory(config);
        log.info("Creating network server...");
        ProxyServer proxyServer = proxyFactory.newProxy(pipelineFactory);
        log.info("Kafka-MQTT initialized after {}ms", (Object)(time.hiResClockMs() - initStart));
        try {
            proxyServer.start();
        }
        catch (Exception e) {
            log.error("Failed to start Kafka-MQTT", (Throwable)e);
            proxyServer.stop();
            Exit.exit((int)ExitStatus.FAILED.code());
        }
        if (blockOnStop) {
            proxyServer.awaitStop();
        } else {
            Runnable awaitStopRunnable = () -> proxyServer.awaitStop();
            new Thread(awaitStopRunnable, "kafka-mqtt-await-stop").start();
        }
    }

    private static MqttConfig newConfig(Map<String, String> props) {
        try {
            return new MqttConfig(props);
        }
        catch (ConfigException e) {
            log.error("Stopping Kafka-MQTT due to configuration error:\n{}", (Object)e.getMessage());
            log.debug("Exception:", (Throwable)e);
            Exit.exit((int)ExitStatus.INVALID.code());
            return null;
        }
    }

    private static void checkLicense(MqttConfig config) {
        LicenseManager licenseManager = new LicenseManager(config.licenseTopicName(), config.licenseProducerConfig(), config.licenseConsumerConfig(), config.licenseTopicAdminConfig());
        try {
            licenseManager.registerOrValidateLicense(config.license());
        }
        catch (InvalidLicenseException e) {
            throw new RuntimeException("Error validating license", e);
        }
        licenseManager.stop();
    }
}

