/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.mqtt;

import io.confluent.mqtt.MqttConfig;
import io.confluent.mqtt.protocol.netty.NettyMqttHandler;
import io.confluent.mqtt.protocol.security.SecurityProtocol;
import io.confluent.mqtt.stream.netty.NettyKafkaPublisher;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineFactory {
    private static final Logger log = LoggerFactory.getLogger(PipelineFactory.class);
    private final MqttConfig config;
    private final SecurityProtocol securityProtocol;

    public PipelineFactory(MqttConfig config) {
        this.config = config;
        this.securityProtocol = config.listenersSecurityProtocol();
    }

    public ChannelHandler[] newPublishPipelineHandlers(SocketChannel channel) {
        ArrayList<Object> handlers = new ArrayList<Object>();
        switch (this.securityProtocol) {
            case SASL_SSL: 
            case SSL: 
            case SASL_TLS: 
            case TLS: {
                handlers.add(this.newSslHandler((Channel)channel));
                break;
            }
            case SASL_PLAINTEXT: {
                log.warn("It's recommended to set {}={} to avoid sending credentials as plain text", (Object)"security.protocol", (Object)SecurityProtocol.SASL_SSL);
                break;
            }
        }
        handlers.add(MqttEncoder.INSTANCE);
        handlers.add(new MqttDecoder(this.config.mqttMessageMaxBytes()));
        handlers.add(NettyMqttHandler.instance(this.config));
        return handlers.toArray(new ChannelHandler[0]);
    }

    public ChannelHandler newKafkaPublishHandler(SocketChannel channel) {
        return NettyKafkaPublisher.instance(this.config);
    }

    private SslHandler newSslHandler(Channel channel) {
        SslHandler sslHandler;
        log.debug("Creating SSL handler");
        Map<String, Object> sslConfigs = this.config.valuesWithPrefix("listeners.");
        if (sslConfigs.size() < 2) {
            throw new IllegalArgumentException("No encryption configurations are defined for listeners");
        }
        try {
            SslFactory sslFactory = new SslFactory(Mode.SERVER, this.config.listenersSslClientAuthConfig(), false);
            sslFactory.configure(sslConfigs);
            SSLEngine sslEngine = sslFactory.createSslEngine(((InetSocketAddress)channel.remoteAddress()).getHostName(), ((InetSocketAddress)channel.remoteAddress()).getPort());
            sslHandler = new SslHandler(sslEngine);
        }
        catch (Exception e) {
            String msg = "Unable to create SSL handler for channel: " + channel;
            log.error(msg, (Throwable)e);
            channel.close();
            throw new ConnectException(msg);
        }
        return sslHandler;
    }
}

