/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.mqtt.stream;

import io.confluent.mqtt.BaseConfig;
import io.confluent.mqtt.stream.SelectedProducerConfigDef;
import io.confluent.mqtt.util.ConfigUtils;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.internals.Topic;

public interface StreamConfig
extends BaseConfig {
    public static final String PRODUCER_PREFIX = "producer.";
    public static final String TOPIC_REGEX_LIST_CONFIG = "topic.regex.list";
    public static final String TOPIC_REGEX_LIST_DOC = "A comma-separated list of pairs of type '<kafka topic>:<regex>' that is used to map MQTT topics to Kafka topics.";
    public static final String STREAM_THREADS_CONFIG = "stream.threads.num";
    public static final String STREAM_THREADS_DOC = "Number of threads publishing records to Kafka";
    public static final int STREAM_THREADS_DEFAULT = 1;
    public static final String KAFKA_PRODUCER_GROUPS_PREFIX = "kafka-mqtt-stream-thread";

    default public ConfigDef assembleStreamConfig(ConfigDef configDef) {
        return StreamConfig.streamConfig(configDef);
    }

    public static ConfigDef streamConfig(ConfigDef configDef) {
        BaseConfig.GroupAndOrder group = new BaseConfig.GroupAndOrder("Stream", 0);
        ConfigDef newConfig = configDef == null ? new ConfigDef() : configDef;
        newConfig = StreamConfig.bootstrapServersDef(newConfig, group);
        newConfig = StreamConfig.topicRegexListDef(newConfig, group);
        newConfig = StreamConfig.streamThreads(newConfig, group);
        newConfig = SelectedProducerConfigDef.configDef(PRODUCER_PREFIX, newConfig, group);
        return newConfig;
    }

    public static ConfigDef bootstrapServersDef(ConfigDef config, BaseConfig.GroupAndOrder group) {
        return config.define("bootstrap.servers", ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Importance.HIGH, "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).", group.name, ++group.order, ConfigDef.Width.LONG, "Bootstrap Servers");
    }

    public static ConfigDef topicRegexListDef(ConfigDef config, BaseConfig.GroupAndOrder group) {
        return config.define(TOPIC_REGEX_LIST_CONFIG, ConfigDef.Type.LIST, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)new ConfigUtils.GenericValidator((name, value) -> {
            ConfigException ce = null;
            try {
                for (Object entry : (List)value) {
                    String[] pair = ((String)entry).split(":");
                    Topic.validate((String)pair[0]);
                    if (pair.length != 2) {
                        ce = new ConfigException(name, value, "Entry" + entry + " not a valid pair");
                    }
                    String regex = pair[1];
                    Pattern.compile(regex);
                }
            }
            catch (InvalidTopicException e) {
                ce = ce == null ? new ConfigException(name, value, "Invalid Kafka topic") : ce;
                ce.initCause((Throwable)e);
            }
            catch (PatternSyntaxException e) {
                ce = ce == null ? new ConfigException(name, value, "Invalid MQTT topic regex") : ce;
            }
            catch (Throwable t) {
                ConfigException configException = ce = ce == null ? new ConfigException(name, value, "Invalid list") : ce;
            }
            if (ce != null) {
                throw ce;
            }
        }, () -> "A list of pairs in the form <kafka topic1>:<regex1>, <kafka topic2>:<regex2>, ..."), ConfigDef.Importance.HIGH, TOPIC_REGEX_LIST_DOC, group.name, ++group.order, ConfigDef.Width.LONG, "MQTT to Kafka Topic Regex Mappings");
    }

    default public String bootstrapServers() {
        return this.getString("bootstrap.servers");
    }

    default public Collection<String> topicRegex() {
        return this.getList(TOPIC_REGEX_LIST_CONFIG);
    }

    public static ConfigDef streamThreads(ConfigDef config, BaseConfig.GroupAndOrder group) {
        return config.define(STREAM_THREADS_CONFIG, ConfigDef.Type.INT, (Object)1, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, STREAM_THREADS_DOC, group.name, ++group.order, ConfigDef.Width.LONG, "Stream Threads Number");
    }

    default public int streamThreads() {
        return this.getInt(STREAM_THREADS_CONFIG);
    }
}

