/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.mqtt.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class ConfigUtils {
    public static ConfigDef addConfigKeys(ConfigDef container, ConfigDef other, Set<String> skip) {
        for (ConfigDef.ConfigKey key : other.configKeys().values()) {
            if (skip == null || skip.contains(key.name)) continue;
            container.define(key);
        }
        return container;
    }

    public static class GenericValidator
    implements ConfigDef.Validator {
        BiConsumer<String, Object> ensureValid;
        Supplier<String> toStringFunction;

        public GenericValidator(BiConsumer<String, Object> ensureValid, Supplier<String> toStringFunction) {
            this.ensureValid = ensureValid;
            this.toStringFunction = toStringFunction;
        }

        public void ensureValid(String name, Object value) {
            this.ensureValid.accept(name, value);
        }

        public String toString() {
            return this.toStringFunction.get();
        }
    }

    public static class EnumRecommender
    implements ConfigDef.Validator,
    ConfigDef.Recommender {
        private final List<String> canonicalValues;
        private final Set<String> validValues;

        private EnumRecommender(List<String> canonicalValues, Set<String> validValues) {
            this.canonicalValues = canonicalValues;
            this.validValues = validValues;
        }

        @SafeVarargs
        public static <E> EnumRecommender in(boolean recommendUpperCase, E ... enumerators) {
            ArrayList<String> canonicalValues = new ArrayList<String>(enumerators.length);
            HashSet<String> validValues = new HashSet<String>(enumerators.length * 2);
            for (E e : enumerators) {
                if (recommendUpperCase) {
                    canonicalValues.add(e.toString().toUpperCase(Locale.ROOT));
                } else {
                    canonicalValues.add(e.toString().toLowerCase(Locale.ROOT));
                }
                validValues.add(e.toString().toUpperCase(Locale.ROOT));
                validValues.add(e.toString().toLowerCase(Locale.ROOT));
            }
            return new EnumRecommender(canonicalValues, validValues);
        }

        public void ensureValid(String key, Object value) {
            if (value != null && !this.validValues.contains(value.toString())) {
                throw new ConfigException(key, value, "Invalid enumerator");
            }
        }

        public String toString() {
            return this.canonicalValues.toString();
        }

        public List<Object> validValues(String name, Map<String, Object> configs) {
            return new ArrayList<Object>(this.canonicalValues);
        }

        public boolean visible(String name, Map<String, Object> configs) {
            return true;
        }
    }
}

