/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hub.io;

import io.confluent.connect.hub.io.ConfluentHubStorage;
import io.confluent.connect.hub.io.Storage;
import io.confluent.connect.hub.utils.IOUtils;
import io.confluent.pluginregistry.rest.entities.PluginArchive;
import io.confluent.pluginregistry.rest.entities.PluginManifest;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;

public class StorageAdapter
implements Storage {
    private final Storage adaptee = new ConfluentHubStorage();
    private final boolean dryRun;

    public StorageAdapter(boolean dryRun) {
        this.dryRun = dryRun;
    }

    @Override
    public void verifiedCopy(InputStream is, String outputFilePath, PluginArchive archive) {
        if (this.dryRun) {
            IOUtils.trace("Skipping verified copy of data into file {}", outputFilePath);
        } else {
            this.adaptee.verifiedCopy(is, outputFilePath, archive);
        }
    }

    @Override
    public void unzip(File sourceFile, File outputDir) {
        if (this.dryRun) {
            IOUtils.trace("Skipping unzip of file {} into {}", sourceFile.getPath(), outputDir.getPath());
        } else {
            this.adaptee.unzip(sourceFile, outputDir);
        }
    }

    @Override
    public void delete(String path) {
        if (this.dryRun) {
            IOUtils.trace("Skipping deletion of path {}", path);
        } else {
            this.adaptee.delete(path);
        }
    }

    @Override
    public void list(String path, Consumer<Path> consumer, boolean dirsOnly) {
        this.adaptee.list(path, consumer, dirsOnly);
    }

    @Override
    public File createTmpDir(String prefix) {
        if (this.dryRun) {
            IOUtils.trace("Skipping temporary directory creation", new Object[0]);
            return new File("<temporary directory>");
        }
        return this.adaptee.createTmpDir(prefix);
    }

    @Override
    public PluginManifest loadManifest(String path) {
        return this.adaptee.loadManifest(path);
    }

    @Override
    public List<String> readLines(String path) {
        return this.adaptee.readLines(path);
    }

    @Override
    public List<String> getPropertyValues(String path, String key) {
        return this.adaptee.getPropertyValues(path, key);
    }

    @Override
    public void updateConfig(String path, String key, List<String> values) {
        if (this.dryRun) {
            IOUtils.trace("Skipping updating config file {}", path);
        } else {
            this.adaptee.updateConfig(path, key, values);
        }
    }

    @Override
    public String getParentDirectoryPath(String absPath) {
        return this.adaptee.getParentDirectoryPath(absPath);
    }

    @Override
    public boolean exists(String path) {
        return this.adaptee.exists(path);
    }

    @Override
    public void createDirectories(String path) {
        if (this.dryRun) {
            IOUtils.trace("Skipping directory {} creation", path);
        } else {
            this.adaptee.createDirectories(path);
        }
    }
}

