/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.pluginregistry.rest.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.confluent.pluginregistry.util.JsonUtil;
import io.confluent.pluginregistry.util.ObjectUtil;
import java.io.IOException;

@JsonPropertyOrder(value={"provider_name", "summary", "url", "logo"})
public class PluginSupport
implements Comparable<PluginSupport> {
    @JsonProperty(value="provider_name")
    private String providerName;
    @JsonProperty
    private String summary;
    @JsonProperty
    private String url;
    @JsonProperty
    private String logo;

    public static PluginSupport fromJson(String json) throws IOException {
        return (PluginSupport)JsonUtil.newObjectMapper().readValue(json, PluginSupport.class);
    }

    public PluginSupport() {
    }

    public PluginSupport(String providerName, String summary, String url, String logo) {
        this.providerName = providerName;
        this.summary = summary;
        this.url = url;
        this.logo = logo;
    }

    public PluginSupport(PluginSupport original) {
        this.providerName = original.providerName;
        this.summary = original.summary;
        this.url = original.url;
        this.logo = original.logo;
    }

    public String toJson() throws IOException {
        return JsonUtil.newObjectMapper().writeValueAsString((Object)this);
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public int hashCode() {
        return this.providerName != null ? this.providerName.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginSupport that = (PluginSupport)o;
        return ObjectUtil.equals(this.providerName, that.providerName) && ObjectUtil.equals(this.summary, that.summary) && ObjectUtil.equals(this.url, that.url) && ObjectUtil.equals(this.logo, that.logo);
    }

    @Override
    public int compareTo(PluginSupport that) {
        if (this == that) {
            return 0;
        }
        if (that == null) {
            return 1;
        }
        int diff = ObjectUtil.compareTo(this.providerName, that.providerName);
        if (diff != 0) {
            return diff;
        }
        diff = ObjectUtil.compareTo(this.summary, that.summary);
        if (diff != 0) {
            return diff;
        }
        diff = ObjectUtil.compareTo(this.url, that.url);
        if (diff != 0) {
            return diff;
        }
        diff = ObjectUtil.compareTo(this.logo, that.logo);
        return diff;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{providerName=" + this.providerName + ",");
        sb.append("summary=" + this.summary + ",");
        sb.append("url=" + this.url + ",");
        sb.append("logo=" + this.logo + "}");
        return sb.toString();
    }
}

