/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.pluginregistry.rest.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.confluent.pluginregistry.util.JsonUtil;
import io.confluent.pluginregistry.util.ObjectUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@JsonPropertyOrder(value={"name", "url", "mime_type", "md5", "sha1", "asc"})
public class Signature
implements Comparable<Signature> {
    @JsonProperty
    private Map<String, String> header;
    @JsonProperty
    private String signature;
    @JsonProperty(value="protected")
    private String protectedValue;

    public static Signature fromJson(String json) throws IOException {
        return (Signature)JsonUtil.newObjectMapper().readValue(json, Signature.class);
    }

    public Signature() {
    }

    public Signature(Map<String, String> header, String signature, String protectedValue) {
        this.header = header;
        this.signature = signature;
        this.protectedValue = protectedValue;
    }

    public Signature(Signature original) {
        this.setHeader(original.header);
        this.setSignature(original.signature);
        this.setProtectedValue(original.protectedValue);
    }

    public String toJson() throws IOException {
        return JsonUtil.newObjectMapper().writeValueAsString((Object)this);
    }

    public Map<String, String> getHeader() {
        return this.header;
    }

    public void setHeader(Map<String, String> header) {
        this.header = header != null ? new HashMap<String, String>(header) : null;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    @JsonProperty(value="protected")
    public String getProtectedValue() {
        return this.protectedValue;
    }

    @JsonProperty(value="protected")
    public void setProtectedValue(String protectedValue) {
        this.protectedValue = protectedValue;
    }

    public int hashCode() {
        int result = this.header != null ? this.header.hashCode() : 0;
        result = 31 * result + (this.signature != null ? this.signature.hashCode() : 0);
        result = 31 * result + (this.protectedValue != null ? this.protectedValue.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signature that = (Signature)o;
        return ObjectUtil.equals(this.header, that.header) && ObjectUtil.equals(this.signature, that.signature) && ObjectUtil.equals(this.protectedValue, that.protectedValue);
    }

    @Override
    public int compareTo(Signature that) {
        if (this == that) {
            return 0;
        }
        if (that == null) {
            return 1;
        }
        int diff = ObjectUtil.compareTo(this.header, that.header);
        if (diff != 0) {
            return diff;
        }
        diff = ObjectUtil.compareTo(this.signature, that.signature);
        if (diff != 0) {
            return diff;
        }
        diff = ObjectUtil.compareTo(this.protectedValue, that.protectedValue);
        return diff;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{header=" + this.header + ",");
        sb.append("signature=" + this.signature + ",");
        sb.append("protectedValue=" + this.protectedValue + ",");
        return sb.toString();
    }
}

