/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.rest.extensions.SchemaRegistryResourceExtension;
import io.confluent.kafka.schemaregistry.security.config.SecureSchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.rest.NamedURI;
import io.confluent.rest.RestConfigException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.core.Configurable;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.fips.FipsValidator;
import org.apache.kafka.common.utils.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegistryFipsResourceExtension
implements SchemaRegistryResourceExtension {
    private static final Logger log = LoggerFactory.getLogger(SchemaRegistryFipsResourceExtension.class);

    public void register(Configurable<?> configurable, SchemaRegistryConfig schemaRegistryConfig, SchemaRegistry schemaRegistry) throws SchemaRegistryException {
        SecureSchemaRegistryConfig confluentSecureSchemaRegistryConfig;
        try {
            confluentSecureSchemaRegistryConfig = new SecureSchemaRegistryConfig(schemaRegistryConfig.originalProperties());
        }
        catch (RestConfigException e) {
            throw new SchemaRegistryException((Throwable)e);
        }
        SchemaRegistryFipsResourceExtension.validateFipsConfig(confluentSecureSchemaRegistryConfig);
    }

    public void close() throws IOException {
    }

    @VisibleForTesting
    static void validateFipsConfig(SecureSchemaRegistryConfig config) {
        if (!config.getBoolean("enable.fips").booleanValue()) {
            return;
        }
        log.info("Schema Registry has FIPS enabled. Starting FIPS validation...");
        String securityProvider = (String)config.originals().get("security.providers");
        if (securityProvider == null || securityProvider.isEmpty()) {
            String errorMsg = "FIPS 140-2 Configuration Error, invalid security provider: <empty>";
            log.error(errorMsg);
            throw new SecurityException(errorMsg);
        }
        SecurityUtils.addConfiguredSecurityProviders((Map)config.originals());
        FipsValidator fipsValidator = ConfluentConfigs.buildFipsValidator();
        SchemaRegistryFipsResourceExtension.validateListenerCipherSuitesAndTlsVersions(fipsValidator, config);
        SchemaRegistryFipsResourceExtension.validateBrokerCommunicationProtocol(fipsValidator, config);
        log.info("FIPS validation successful for Schema Registry");
    }

    private static void validateListenerCipherSuitesAndTlsVersions(FipsValidator fipsValidator, SchemaRegistryConfig config) {
        Map<NamedURI, Map<String, Object>> listenerConfigs = SchemaRegistryFipsResourceExtension.getListenerConfigMaps(config);
        for (Map.Entry<NamedURI, Map<String, Object>> entry : listenerConfigs.entrySet()) {
            List tlsVersions;
            NamedURI listener = entry.getKey();
            Map<String, Object> listenerConfig = entry.getValue();
            List cipherSuites = (List)listenerConfig.get("ssl.cipher.suites");
            if (cipherSuites == null || cipherSuites.isEmpty()) {
                String warningMsg = "FIPS 140-2 Configuration Warning, ssl.cipher.suites not provided.";
                log.warn("FIPS 140-2 Configuration Warning, ssl.cipher.suites not provided.");
            }
            if ((tlsVersions = (List)listenerConfig.get("ssl.enabled.protocols")) == null || tlsVersions.isEmpty()) {
                String errorMsg = "FIPS 140-2 Configuration Error, invalid TLS versions: <empty>";
                log.error("FIPS 140-2 Configuration Error, invalid TLS versions: <empty>");
                throw new SecurityException("FIPS 140-2 Configuration Error, invalid TLS versions: <empty>");
            }
            try {
                fipsValidator.validateRestProtocol(listener.getUri().getScheme());
                fipsValidator.validateFipsTls(listenerConfig);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new SecurityException(e.getMessage());
            }
        }
    }

    private static void validateBrokerCommunicationProtocol(FipsValidator fipsValidator, SchemaRegistryConfig config) {
        String brokerSecurityProtocol = config.getString("kafkastore.security.protocol");
        HashMap<String, SecurityProtocol> securityProtocolMap = new HashMap<String, SecurityProtocol>();
        securityProtocolMap.put("kafkastore.security.protocol", SecurityProtocol.forName((String)brokerSecurityProtocol));
        try {
            fipsValidator.validateFipsBrokerProtocol(securityProtocolMap);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new SecurityException(e.getMessage());
        }
    }

    private static Map<NamedURI, Map<String, Object>> getListenerConfigMaps(SchemaRegistryConfig config) {
        return config.getListeners().stream().collect(Collectors.toMap(Function.identity(), namedURI -> config.valuesWithPrefixOverride("listener.name." + Optional.ofNullable(namedURI.getName()).orElse("https") + ".")));
    }
}

