/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.util;

import io.confluent.kafka.schemaregistry.security.util.CrnConstants;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;

public class CrnElement {
    private final CrnConstants.CrnResourceType resourceType;
    private final String encodedResourceName;

    public static CrnElement of(CrnConstants.CrnResourceType resourceType, String resourceName) {
        String encodedResourceName;
        if (resourceType == null) {
            throw new IllegalArgumentException("resource type cannot be null");
        }
        if ("".equals(resourceName) && CrnConstants.CrnResourceType.SchemaRegistrySubject.equals((Object)resourceType)) {
            resourceName = "__EMPTY";
        } else if (StringUtils.isEmpty((CharSequence)resourceName)) {
            return null;
        }
        try {
            encodedResourceName = URLEncoder.encode(resourceName, StandardCharsets.UTF_8.toString()).replace("*", "%2A");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Error encoding resourceName " + resourceName, e);
        }
        return new CrnElement(resourceType, encodedResourceName);
    }

    private CrnElement(CrnConstants.CrnResourceType resourceType, String encodedResourceName) {
        this.resourceType = resourceType;
        this.encodedResourceName = encodedResourceName;
    }

    public CrnConstants.CrnResourceType resourceType() {
        return this.resourceType;
    }

    public String encodedResourceName() {
        return this.encodedResourceName;
    }
}

