/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafkarest.controllers.AbstractConfigManager;
import io.confluent.kafkarest.controllers.ClusterManager;
import io.confluent.kafkarest.controllers.TopicConfigManager;
import io.confluent.kafkarest.entities.AlterConfigCommand;
import io.confluent.kafkarest.entities.TopicConfig;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.config.ConfigResource;

final class TopicConfigManagerImpl
extends AbstractConfigManager<TopicConfig, TopicConfig.Builder>
implements TopicConfigManager {
    @Inject
    TopicConfigManagerImpl(Admin adminClient, ClusterManager clusterManager) {
        super(adminClient, clusterManager);
    }

    @Override
    public CompletableFuture<List<TopicConfig>> listTopicConfigs(String clusterId, String topicName) {
        return this.listConfigs(clusterId, new ConfigResource(ConfigResource.Type.TOPIC, topicName), ((TopicConfig.Builder)TopicConfig.builder().setClusterId(clusterId)).setTopicName(topicName));
    }

    @Override
    public CompletableFuture<Map<String, List<TopicConfig>>> listTopicConfigs(String clusterId, List<String> topicNames) {
        List<ConfigResource> topicResources = topicNames.stream().map(topicName -> new ConfigResource(ConfigResource.Type.TOPIC, topicName)).collect(Collectors.toList());
        return this.listConfigs(clusterId, topicResources, ((TopicConfig.Builder)TopicConfig.builder().setClusterId(clusterId)).setTopicName("")).thenApply(configs -> configs.entrySet().stream().collect(Collectors.toMap(e -> ((ConfigResource)e.getKey()).name(), e -> ((List)e.getValue()).stream().map(config -> TopicConfig.create(config.getClusterId(), ((ConfigResource)e.getKey()).name(), config.getName(), config.getValue(), config.isDefault(), config.isReadOnly(), config.isSensitive(), config.getSource(), config.getSynonyms())).collect(Collectors.toList()))));
    }

    @Override
    public CompletableFuture<Optional<TopicConfig>> getTopicConfig(String clusterId, String topicName, String name) {
        return this.getConfig(clusterId, new ConfigResource(ConfigResource.Type.TOPIC, topicName), ((TopicConfig.Builder)TopicConfig.builder().setClusterId(clusterId)).setTopicName(topicName), name);
    }

    @Override
    public CompletableFuture<Void> updateTopicConfig(String clusterId, String topicName, String name, String newValue) {
        return this.safeUpdateConfig(clusterId, new ConfigResource(ConfigResource.Type.TOPIC, topicName), ((TopicConfig.Builder)TopicConfig.builder().setClusterId(clusterId)).setTopicName(topicName), name, newValue);
    }

    @Override
    public CompletableFuture<Void> resetTopicConfig(String clusterId, String topicName, String name) {
        return this.safeResetConfig(clusterId, new ConfigResource(ConfigResource.Type.TOPIC, topicName), ((TopicConfig.Builder)TopicConfig.builder().setClusterId(clusterId)).setTopicName(topicName), name);
    }

    @Override
    public CompletableFuture<Void> alterTopicConfigs(String clusterId, String topicName, List<AlterConfigCommand> commands) {
        return this.safeAlterConfigs(clusterId, new ConfigResource(ConfigResource.Type.TOPIC, topicName), ((TopicConfig.Builder)TopicConfig.builder().setClusterId(clusterId)).setTopicName(topicName), commands);
    }

    @Override
    public CompletableFuture<Void> alterTopicConfigs(String clusterId, String topicName, List<AlterConfigCommand> commands, boolean validateOnly) {
        return this.safeAlterOrValidateConfigs(clusterId, new ConfigResource(ConfigResource.Type.TOPIC, topicName), ((TopicConfig.Builder)TopicConfig.builder().setClusterId(clusterId)).setTopicName(topicName), commands, validateOnly);
    }
}

