/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.Acl;
import io.confluent.kafkarest.entities.AutoValue_Topic;
import io.confluent.kafkarest.entities.Partition;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

@AutoValue
public abstract class Topic {
    Topic() {
    }

    public abstract String getClusterId();

    public abstract String getName();

    public abstract ImmutableList<Partition> getPartitions();

    public abstract short getReplicationFactor();

    public abstract boolean isInternal();

    public abstract Set<Acl.Operation> getAuthorizedOperations();

    public static Builder builder() {
        return new AutoValue_Topic.Builder();
    }

    public static Topic create(String clusterId, String name, List<Partition> partitions, short replicationFactor, boolean isInternal) {
        return Topic.create(clusterId, name, partitions, replicationFactor, isInternal, null);
    }

    public static Topic create(String clusterId, String name, List<Partition> partitions, short replicationFactor, boolean isInternal, @Nullable Set<Acl.Operation> authorizedOperations) {
        return Topic.builder().setClusterId(clusterId).setName(name).addAllPartitions(partitions).setReplicationFactor(replicationFactor).setInternal(isInternal).setAuthorizedOperations(authorizedOperations == null ? Collections.emptySet() : authorizedOperations).build();
    }

    public Builder toBuilder() {
        return Topic.builder().setClusterId(this.getClusterId()).setName(this.getName()).addAllPartitions((Iterable<Partition>)this.getPartitions()).setReplicationFactor(this.getReplicationFactor()).setInternal(this.isInternal()).setAuthorizedOperations(this.getAuthorizedOperations());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setName(String var1);

        abstract ImmutableList.Builder<Partition> partitionsBuilder();

        public final Builder addAllPartitions(Iterable<Partition> partitions) {
            this.partitionsBuilder().addAll(partitions);
            return this;
        }

        public abstract Builder setReplicationFactor(short var1);

        public abstract Builder setInternal(boolean var1);

        public abstract Builder setAuthorizedOperations(Set<Acl.Operation> var1);

        public abstract Topic build();
    }
}

