/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.ratelimit;

import io.confluent.kafkarest.ratelimit.GuavaRateLimiter;
import io.confluent.kafkarest.ratelimit.RateLimitBackend;
import io.confluent.kafkarest.ratelimit.RequestRateLimiter;
import io.confluent.kafkarest.ratelimit.Resilience4JRateLimiter;
import java.time.Duration;
import java.util.Objects;
import org.glassfish.hk2.api.Factory;

abstract class RequestRateLimiterFactory
implements Factory<RequestRateLimiter> {
    private final RateLimitBackend backend;
    private final int permitsPerSecond;
    private final Duration timeout;

    RequestRateLimiterFactory(RateLimitBackend backend, Integer permitsPerSecond, Duration timeout) {
        this.backend = Objects.requireNonNull(backend);
        this.permitsPerSecond = permitsPerSecond;
        this.timeout = Objects.requireNonNull(timeout);
    }

    public RequestRateLimiter provide() {
        switch (this.backend) {
            case GUAVA: {
                return GuavaRateLimiter.create(this.permitsPerSecond, this.timeout);
            }
            case RESILIENCE4J: {
                return Resilience4JRateLimiter.create(this.permitsPerSecond, this.timeout);
            }
        }
        throw new AssertionError((Object)("Unknown enum constant: " + (Object)((Object)this.backend)));
    }

    public void dispose(RequestRateLimiter rateLimiter) {
    }
}

