/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v2;

import io.confluent.kafkarest.Errors;
import io.confluent.kafkarest.controllers.PartitionManager;
import io.confluent.kafkarest.entities.Partition;
import io.confluent.kafkarest.entities.v2.GetPartitionResponse;
import io.confluent.kafkarest.entities.v2.TopicPartitionOffsetResponse;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;

@Path(value="/topics/{topic}/partitions")
@Consumes(value={"application/vnd.kafka.v2+json"})
@Produces(value={"application/vnd.kafka.v2+json"})
@ResourceAccesslistFeature.ResourceName(value="api.v2.partitions.*")
public final class PartitionsResource {
    private final Provider<PartitionManager> partitionManager;

    @Inject
    public PartitionsResource(Provider<PartitionManager> partitionManager) {
        this.partitionManager = Objects.requireNonNull(partitionManager);
    }

    @GET
    @PerformanceMetric(value="partitions.list+v2")
    @ResourceAccesslistFeature.ResourceName(value="api.v2.partitions.list")
    public void list(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topic) {
        CompletionStage response = ((PartitionManager)this.partitionManager.get()).listLocalPartitions(topic).thenApply(partitions -> partitions.stream().map(GetPartitionResponse::fromPartition).collect(Collectors.toList()));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    @GET
    @Path(value="/{partition}")
    @PerformanceMetric(value="partition.get+v2")
    @ResourceAccesslistFeature.ResourceName(value="api.v2.partitions.get")
    public void getPartition(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topic, @PathParam(value="partition") int partitionId) {
        CompletionStage response = ((CompletableFuture)((PartitionManager)this.partitionManager.get()).getLocalPartition(topic, partitionId).thenApply(partition -> (Partition)partition.orElseThrow(Errors::partitionNotFoundException))).thenApply(GetPartitionResponse::fromPartition);
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    @GET
    @Path(value="/{partition}/offsets")
    @ResourceAccesslistFeature.ResourceName(value="api.v2.partitions.get-offsets")
    public void getOffsets(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topic, @PathParam(value="partition") int partitionId) {
        CompletionStage response = ((CompletableFuture)((PartitionManager)this.partitionManager.get()).getLocalPartition(topic, partitionId).thenApply(partition -> (Partition)partition.orElseThrow(Errors::partitionNotFoundException))).thenApply(partition -> new TopicPartitionOffsetResponse(partition.getEarliestOffset(), partition.getLatestOffset()));
        AsyncResponses.asyncResume(asyncResponse, response);
    }
}

