/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.confluent.kafkarest.config.ConfigModule;
import io.confluent.kafkarest.ratelimit.RateLimitExceededException;
import io.confluent.kafkarest.ratelimit.RateLimitModule;
import io.confluent.kafkarest.ratelimit.RequestRateLimiter;
import io.confluent.kafkarest.ratelimit.RequestRateLimiterCacheLoader;
import java.time.Duration;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.http.HttpServletRequest;

public class ProduceRateLimiters {
    private final boolean rateLimitingEnabled;
    private final LoadingCache<String, RequestRateLimiter> countCache;
    private final LoadingCache<String, RequestRateLimiter> bytesCache;
    private final Provider<RequestRateLimiter> bytesLimiterGlobal;
    private final Provider<RequestRateLimiter> countLimiterGlobal;

    @Inject
    public ProduceRateLimiters(@RateLimitModule.ProduceRateLimiterCount Provider<RequestRateLimiter> countLimiterProvider, @RateLimitModule.ProduceRateLimiterBytes Provider<RequestRateLimiter> bytesLimiterProvider, @RateLimitModule.ProduceRateLimiterCountGlobal Provider<RequestRateLimiter> countLimiterGlobal, @RateLimitModule.ProduceRateLimiterBytesGlobal Provider<RequestRateLimiter> bytesLimiterGlobal, @ConfigModule.ProduceRateLimitEnabledConfig Boolean produceRateLimitEnabledConfig, @ConfigModule.ProduceRateLimitCacheExpiryConfig Duration produceRateLimitCacheExpiryConfig) {
        this.rateLimitingEnabled = Objects.requireNonNull(produceRateLimitEnabledConfig);
        this.countLimiterGlobal = Objects.requireNonNull(countLimiterGlobal);
        this.bytesLimiterGlobal = Objects.requireNonNull(bytesLimiterGlobal);
        this.countCache = CacheBuilder.newBuilder().expireAfterAccess(produceRateLimitCacheExpiryConfig).build((CacheLoader)new RequestRateLimiterCacheLoader(countLimiterProvider));
        this.bytesCache = CacheBuilder.newBuilder().expireAfterAccess(produceRateLimitCacheExpiryConfig).build((CacheLoader)new RequestRateLimiterCacheLoader(bytesLimiterProvider));
    }

    public void rateLimit(String clusterId, long requestSize, HttpServletRequest httpServletRequest) {
        if (!this.rateLimitingEnabled) {
            return;
        }
        try {
            ((RequestRateLimiter)this.countLimiterGlobal.get()).rateLimit(1);
        }
        catch (RateLimitExceededException ex) {
            httpServletRequest.setAttribute("REST_ERROR_CODE", (Object)429001);
            throw ex;
        }
        try {
            ((RequestRateLimiter)this.bytesLimiterGlobal.get()).rateLimit(Math.toIntExact(requestSize));
        }
        catch (RateLimitExceededException ex) {
            httpServletRequest.setAttribute("REST_ERROR_CODE", (Object)429003);
            throw ex;
        }
        RequestRateLimiter countRateLimiter = (RequestRateLimiter)this.countCache.getUnchecked((Object)clusterId);
        RequestRateLimiter byteRateLimiter = (RequestRateLimiter)this.bytesCache.getUnchecked((Object)clusterId);
        try {
            countRateLimiter.rateLimit(1);
        }
        catch (RateLimitExceededException ex) {
            httpServletRequest.setAttribute("REST_ERROR_CODE", (Object)429002);
            throw ex;
        }
        try {
            byteRateLimiter.rateLimit(Math.toIntExact(requestSize));
        }
        catch (RateLimitExceededException ex) {
            httpServletRequest.setAttribute("REST_ERROR_CODE", (Object)429004);
            throw ex;
        }
    }

    public void clear() {
        this.countCache.invalidateAll();
        this.bytesCache.invalidateAll();
    }
}

