/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.hcvault;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KmsClient;
import com.google.crypto.tink.subtle.Validators;
import io.confluent.kafka.schemaregistry.encryption.hcvault.HcVaultKmsAead;
import io.confluent.kafka.schemaregistry.encryption.hcvault.HcVaultKmsDriver;
import io.github.jopenlibs.vault.EnvironmentLoader;
import io.github.jopenlibs.vault.SslConfig;
import io.github.jopenlibs.vault.Vault;
import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.api.Logical;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Locale;
import java.util.Optional;

public class HcVaultKmsClient
implements KmsClient {
    public static final String PREFIX = "hcvault://";
    private String keyUri;
    private VaultConfig vaultConfig;
    private Logical vault;

    public HcVaultKmsClient() {
    }

    public HcVaultKmsClient(String uri) {
        if (!uri.toLowerCase(Locale.US).startsWith(PREFIX)) {
            throw new IllegalArgumentException("key URI must starts with hcvault://");
        }
        this.keyUri = uri;
    }

    public boolean doesSupport(String uri) {
        if (this.keyUri != null && this.keyUri.equals(uri)) {
            return true;
        }
        return this.keyUri == null && uri.toLowerCase(Locale.US).startsWith(PREFIX);
    }

    public KmsClient withCredentials(String token) throws GeneralSecurityException {
        return this.withCredentials(token, Optional.empty());
    }

    public KmsClient withCredentials(String token, Optional<String> namespace) throws GeneralSecurityException {
        return this.withCredentials(null, token, namespace);
    }

    public KmsClient withCredentials(SslConfig sslConfig, String token, Optional<String> namespace) throws GeneralSecurityException {
        try {
            URI uri = new URI(HcVaultKmsClient.toHcVaultUri(this.keyUri));
            String address = "";
            if (uri.getScheme() != null) {
                address = address + uri.getScheme() + "://";
            }
            address = address + uri.getHost();
            if (uri.getPort() != -1) {
                address = address + ":" + uri.getPort();
            }
            VaultConfig config = new VaultConfig().address(address).token(token).engineVersion(Integer.valueOf(1));
            if (namespace.isPresent()) {
                config = config.nameSpace(namespace.get());
            }
            if (sslConfig != null) {
                config = config.sslConfig(sslConfig);
            }
            this.vaultConfig = config = config.build();
            this.vault = new Vault(config).logical();
            return this;
        }
        catch (VaultException | URISyntaxException e) {
            throw new GeneralSecurityException("invalid path provided", e);
        }
    }

    public KmsClient withDefaultCredentials() throws GeneralSecurityException {
        try {
            String truststore;
            String keystorePassword;
            String keystore;
            SslConfig sslConfig;
            URI uri = new URI(HcVaultKmsClient.toHcVaultUri(this.keyUri));
            String address = "";
            if (uri.getScheme() != null) {
                address = address + uri.getScheme() + "://";
            }
            address = address + uri.getHost();
            if (uri.getPort() != -1) {
                address = address + ":" + uri.getPort();
            }
            VaultConfig config = new VaultConfig().address(address).engineVersion(Integer.valueOf(1));
            EnvironmentLoader envLoader = new EnvironmentLoader();
            String namespace = envLoader.loadVariable("VAULT_NAMESPACE");
            if (namespace != null && !namespace.isEmpty()) {
                config = config.nameSpace(namespace);
            }
            if ((sslConfig = HcVaultKmsDriver.getSslConfig(keystore = envLoader.loadVariable("VAULT_SSL_KEYSTORE_LOCATION"), keystorePassword = envLoader.loadVariable("VAULT_SSL_KEYSTORE_PASSWORD"), truststore = envLoader.loadVariable("VAULT_SSL_TRUSTSTORE_LOCATION"))) != null) {
                config = config.sslConfig(sslConfig);
            }
            this.vaultConfig = config = config.build();
            this.vault = new Vault(config).logical();
        }
        catch (VaultException | URISyntaxException e) {
            throw new GeneralSecurityException("unable to create config", e);
        }
        return this;
    }

    public KmsClient withConfig(VaultConfig config) throws GeneralSecurityException {
        this.vaultConfig = config;
        this.vault = new Vault(config).logical();
        return this;
    }

    public KmsClient withVault(Logical vault) {
        this.vault = vault;
        return this;
    }

    public VaultConfig getVaultConfig() {
        return this.vaultConfig;
    }

    public Aead getAead(String uri) throws GeneralSecurityException {
        if (this.keyUri != null && !this.keyUri.equals(uri)) {
            throw new GeneralSecurityException(String.format("this client is bound to %s, cannot load keys bound to %s", this.keyUri, uri));
        }
        return new HcVaultKmsAead(this.vault, HcVaultKmsClient.toHcVaultUri(uri));
    }

    private static String toHcVaultUri(String uri) {
        String uriStr = Validators.validateKmsKeyUriAndRemovePrefix((String)PREFIX, (String)uri);
        if (!uriStr.startsWith("http")) {
            uriStr = "https://" + uriStr;
        }
        return uriStr;
    }
}

