/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.cache;

import io.confluent.security.auth.metadata.AuthCache;
import io.confluent.security.auth.store.cache.AccessRuleStore;
import io.confluent.security.auth.store.data.AclBindingKey;
import io.confluent.security.auth.store.data.AclBindingValue;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthKey;
import io.confluent.security.auth.store.data.AuthValue;
import io.confluent.security.auth.store.data.IdentityPoolKey;
import io.confluent.security.auth.store.data.IdentityPoolValueV2;
import io.confluent.security.auth.store.data.JwtIssuerKeyV2;
import io.confluent.security.auth.store.data.JwtIssuerValue;
import io.confluent.security.auth.store.data.RefreshTokenInfoKey;
import io.confluent.security.auth.store.data.RefreshTokenInfoValue;
import io.confluent.security.auth.store.data.RoleBindingKey;
import io.confluent.security.auth.store.data.RoleBindingValue;
import io.confluent.security.auth.store.data.StatusKey;
import io.confluent.security.auth.store.data.StatusValue;
import io.confluent.security.auth.store.data.UserKey;
import io.confluent.security.auth.store.data.UserValue;
import io.confluent.security.authentication.oidc.RefreshTokenInfo;
import io.confluent.security.authorizer.AccessRule;
import io.confluent.security.authorizer.AclAccessRule;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.AuthorizePolicy;
import io.confluent.security.authorizer.Operation;
import io.confluent.security.authorizer.PermissionType;
import io.confluent.security.authorizer.ResourceType;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.acl.AclRule;
import io.confluent.security.authorizer.provider.AuthorizeRule;
import io.confluent.security.authorizer.provider.InvalidScopeException;
import io.confluent.security.authorizer.provider.ResourceAuthorizeRules;
import io.confluent.security.rbac.AccessPolicy;
import io.confluent.security.rbac.InvalidRoleBindingException;
import io.confluent.security.rbac.RbacAccessRule;
import io.confluent.security.rbac.RbacRoles;
import io.confluent.security.rbac.Role;
import io.confluent.security.rbac.RoleBinding;
import io.confluent.security.rbac.RoleBindingFilter;
import io.confluent.security.rbac.UserMetadata;
import io.confluent.security.store.KeyValueStore;
import io.confluent.security.store.MetadataStoreException;
import io.confluent.security.store.MetadataStoreStatus;
import io.confluent.security.trustservice.store.TrustCache;
import io.confluent.security.trustservice.store.data.IdentityPool;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.security.auth.ConfluentPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.jose4j.jwk.JsonWebKeySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthCache
implements AuthCache,
TrustCache,
KeyValueStore<AuthKey, AuthValue> {
    private static final Logger log = LoggerFactory.getLogger(AbstractAuthCache.class);
    private static final String WILDCARD_HOST = "*";
    private static final Map<RoleBindingKey, RoleBindingValue> NO_ROLE_BINDINGS = Collections.emptyMap();
    private final RbacRoles rbacRoles;
    protected final Scope rootScope;
    private final Map<KafkaPrincipal, UserMetadata> users;
    protected final Map<KafkaPrincipal, Map<RoleBindingKey, RoleBindingValue>> roleBindings;
    private final Map<String, JsonWebKeySet> jsonWebKeys;
    private final Map<String, IdentityPool> identityPools;
    private final Map<Integer, StatusValue> partitionStatus;
    private final Map<String, RefreshTokenInfo> refreshTokens;
    protected final AccessRuleStore rbacAccessRuleStore;
    protected final AccessRuleStore aclAccessRuleStore;

    public AbstractAuthCache(RbacRoles rbacRoles, Scope rootScope, AccessRuleStore rbacAccessRuleStore, AccessRuleStore aclAccessRuleStore) {
        this.rbacRoles = rbacRoles;
        this.rootScope = rootScope;
        this.users = new ConcurrentHashMap<KafkaPrincipal, UserMetadata>();
        this.roleBindings = new ConcurrentHashMap<KafkaPrincipal, Map<RoleBindingKey, RoleBindingValue>>();
        this.jsonWebKeys = new ConcurrentHashMap<String, JsonWebKeySet>();
        this.identityPools = new ConcurrentHashMap<String, IdentityPool>();
        this.partitionStatus = new ConcurrentHashMap<Integer, StatusValue>();
        this.refreshTokens = new ConcurrentHashMap<String, RefreshTokenInfo>();
        this.rbacAccessRuleStore = rbacAccessRuleStore;
        this.aclAccessRuleStore = aclAccessRuleStore;
    }

    public abstract AuthorizeRule findRule(KafkaPrincipal var1, Set<KafkaPrincipal> var2, String var3, Action var4);

    public Set<KafkaPrincipal> groups(KafkaPrincipal sessionPrincipal) {
        this.ensureNotFailed();
        HashSet<KafkaPrincipal> result = new HashSet<KafkaPrincipal>(this.groupPrincipals(sessionPrincipal));
        KafkaPrincipal userPrincipal = this.userPrincipal(sessionPrincipal);
        UserMetadata user = this.users.get(userPrincipal);
        if (user != null) {
            result.addAll(user.groups());
        }
        return result;
    }

    private KafkaPrincipal userPrincipal(KafkaPrincipal sessionPrincipal) {
        return Objects.nonNull(sessionPrincipal) && sessionPrincipal.getClass() != KafkaPrincipal.class ? new KafkaPrincipal(sessionPrincipal.getPrincipalType(), sessionPrincipal.getName()) : sessionPrincipal;
    }

    private Set<KafkaPrincipal> groupPrincipals(KafkaPrincipal sessionPrincipal) {
        return Optional.of(sessionPrincipal).filter(p -> p instanceof ConfluentPrincipal).map((? super T p) -> (ConfluentPrincipal)p).map(ConfluentPrincipal::getGroups).orElse(Collections.emptySet()).stream().map((? super T group) -> new KafkaPrincipal("Group", group)).collect(Collectors.toSet());
    }

    public Set<RoleBinding> rbacRoleBindings(Scope scope) {
        this.ensureNotFailed();
        HashSet<RoleBinding> bindings = new HashSet<RoleBinding>();
        this.roleBindings.values().stream().flatMap(map -> map.entrySet().stream()).filter(e -> scope.equals((Object)((RoleBindingKey)e.getKey()).scope())).forEach(e -> bindings.add(this.roleBinding((RoleBindingKey)e.getKey(), (RoleBindingValue)e.getValue())));
        return bindings;
    }

    public Set<RoleBinding> rbacRoleBindings(Set<Scope> scopes) {
        this.ensureNotFailed();
        HashSet<RoleBinding> bindings = new HashSet<RoleBinding>();
        this.roleBindings.values().stream().flatMap(map -> map.entrySet().stream()).filter(e -> scopes.contains(((RoleBindingKey)e.getKey()).scope())).forEach(e -> bindings.add(this.roleBinding((RoleBindingKey)e.getKey(), (RoleBindingValue)e.getValue())));
        return bindings;
    }

    public Set<RoleBinding> rbacRoleBindings(RoleBindingFilter filter) {
        this.ensureNotFailed();
        HashSet<RoleBinding> bindings = new HashSet<RoleBinding>();
        this.roleBindings.values().stream().flatMap(map -> map.entrySet().stream()).map((? super T e) -> this.roleBinding((RoleBindingKey)e.getKey(), (RoleBindingValue)e.getValue())).forEach(binding -> {
            RoleBinding matching = filter.matchingBinding(binding, this.rbacRoles.role(binding.role()).bindWithResource());
            if (matching != null) {
                bindings.add(matching);
            }
        });
        return bindings;
    }

    public Set<RoleBinding> rbacRoleBindings(KafkaPrincipal principal) {
        this.ensureNotFailed();
        Set<KafkaPrincipal> principals = this.principalsToLookup(principal);
        return principals.stream().map(this.roleBindings::get).filter(Objects::nonNull).flatMap(map -> map.entrySet().stream()).map((? super T entry) -> this.roleBinding((RoleBindingKey)entry.getKey(), (RoleBindingValue)entry.getValue())).collect(Collectors.toSet());
    }

    private Set<KafkaPrincipal> principalsToLookup(KafkaPrincipal principal) {
        HashSet<KafkaPrincipal> principals = new HashSet<KafkaPrincipal>(this.groups(principal));
        principals.add(this.userPrincipal(principal));
        return principals;
    }

    public Set<RoleBinding> rbacRoleBindings(KafkaPrincipal principal, Set<Scope> scopes) {
        this.ensureNotFailed();
        Set<KafkaPrincipal> principals = this.principalsToLookup(principal);
        return principals.stream().map(this.roleBindings::get).filter(Objects::nonNull).flatMap(map -> map.entrySet().stream()).filter(entry -> scopes.contains(((RoleBindingKey)entry.getKey()).scope())).map((? super T entry) -> this.roleBinding((RoleBindingKey)entry.getKey(), (RoleBindingValue)entry.getValue())).collect(Collectors.toSet());
    }

    public Map<String, JsonWebKeySet> jsonWebKeySets() {
        return Collections.unmodifiableMap(this.jsonWebKeys);
    }

    public JsonWebKeySet jsonWebKeySet(String jwtKey) {
        return this.jsonWebKeys.get(jwtKey);
    }

    public IdentityPool identityPool(String poolId) {
        return this.identityPools.get(poolId);
    }

    public Map<String, IdentityPool> identityPools() {
        return Collections.unmodifiableMap(this.identityPools);
    }

    public RefreshTokenInfo refreshTokenInfo(String refreshTokenKey) {
        return this.refreshTokens.get(refreshTokenKey);
    }

    public UserMetadata userMetadata(KafkaPrincipal userPrincipal) {
        return this.users.get(userPrincipal);
    }

    public Map<KafkaPrincipal, UserMetadata> users() {
        return Collections.unmodifiableMap(this.users);
    }

    public Set<Scope> knownScopes() {
        this.ensureNotFailed();
        return new HashSet<Scope>(this.rbacAccessRuleStore.knownScopes());
    }

    public Scope rootScope() {
        return this.rootScope;
    }

    public RbacRoles rbacRoles() {
        return this.rbacRoles;
    }

    public Map<io.confluent.security.authorizer.ResourcePattern, Set<AccessRule>> aclRules(Scope scope) {
        this.ensureNotFailed();
        return Collections.unmodifiableMap(this.aclAccessRuleStore.get(scope));
    }

    public Collection<AclBinding> aclBindings(Scope scope, AclBindingFilter aclBindingFilter, Predicate<io.confluent.security.authorizer.ResourcePattern> resourceAccess) {
        this.ensureNotFailed();
        if (!this.rootScope.containsScope(scope)) {
            throw new InvalidScopeException("This authorization cache does not contain scope " + scope);
        }
        if (aclBindingFilter.isUnknown()) {
            throw new InvalidRequestException("The AclBindingFilter must not contain UNKNOWN elements.");
        }
        HashSet<AclBinding> aclBindings = new HashSet<AclBinding>();
        for (Scope nextScope = scope; nextScope != null; nextScope = nextScope.parent()) {
            NavigableMap<io.confluent.security.authorizer.ResourcePattern, Set<AccessRule>> rules = this.aclAccessRuleStore.get(nextScope);
            if (rules == null) continue;
            for (Map.Entry e : rules.entrySet()) {
                io.confluent.security.authorizer.ResourcePattern resourcePattern = (io.confluent.security.authorizer.ResourcePattern)e.getKey();
                if (!resourceAccess.test(resourcePattern)) continue;
                Set accessRules = (Set)e.getValue();
                for (AccessRule accessRule : accessRules) {
                    AclBinding fixture = new AclBinding(io.confluent.security.authorizer.ResourcePattern.to((io.confluent.security.authorizer.ResourcePattern)resourcePattern), AclRule.accessControlEntry((AccessRule)accessRule));
                    if (!aclBindingFilter.matches(fixture)) continue;
                    aclBindings.add(fixture);
                }
            }
        }
        return aclBindings;
    }

    public void addMatchingRules(ResourceAuthorizeRules matchingRules, KafkaPrincipal userPrincipal, Set<KafkaPrincipal> groupPrincipals, String host, Operation operation, Scope resourceScope, ResourceType resourceType) {
        this.ensureNotFailed();
        if (!this.rootScope.containsScope(resourceScope)) {
            throw new InvalidScopeException("This authorization cache does not contain scope " + resourceScope);
        }
        Set matchingPrincipals = AccessRule.matchingPrincipals((KafkaPrincipal)userPrincipal, groupPrincipals, (KafkaPrincipal)AccessRule.WILDCARD_USER_PRINCIPAL, (KafkaPrincipal)AccessRule.WILDCARD_GROUP_PRINCIPAL);
        this.aclAccessRuleStore.addMatchingRules(matchingRules, resourceScope, matchingPrincipals, host, operation, resourceType);
        this.rbacAccessRuleStore.addMatchingRules(matchingRules, resourceScope, matchingPrincipals, host, operation, resourceType);
    }

    public AuthCache.Result healthcheck() {
        try {
            this.ensureNotFailed();
            return AuthCache.Result.healthy();
        }
        catch (Exception e) {
            return AuthCache.Result.unhealthy((String)e.getMessage());
        }
    }

    public AuthValue get(AuthKey key) {
        switch (key.entryType()) {
            case ROLE_BINDING: {
                RoleBindingKey roleBindingKey = (RoleBindingKey)key;
                return (AuthValue)this.roleBindings.getOrDefault(roleBindingKey.principal(), NO_ROLE_BINDINGS).get(roleBindingKey);
            }
            case USER: {
                UserMetadata user = this.users.get(((UserKey)key).principal());
                return user == null ? null : new UserValue((Collection)user.groups());
            }
            case STATUS: {
                StatusKey statusKey = (StatusKey)key;
                return (AuthValue)this.partitionStatus.get(statusKey.partition());
            }
            case ACL_BINDING: {
                AclBindingKey aclBindingKey = (AclBindingKey)key;
                NavigableMap<io.confluent.security.authorizer.ResourcePattern, Set<AccessRule>> scopeRules = this.aclAccessRuleStore.get(aclBindingKey.scope());
                if (scopeRules != null) {
                    Set accessRules = (Set)scopeRules.get(aclBindingKey.resourcePattern());
                    return accessRules == null ? null : this.aclBindingValue(accessRules);
                }
                return null;
            }
            case JWT_ISSUER: {
                JsonWebKeySet jwks = this.jsonWebKeys.get(((JwtIssuerKeyV2)key).cacheKey());
                return jwks == null ? null : new JwtIssuerValue(jwks);
            }
            case IDENTITY_POOL: {
                IdentityPoolKey identityPoolKey = (IdentityPoolKey)key;
                IdentityPool identityPool = this.identityPools.get(identityPoolKey.poolId());
                return identityPool == null ? null : new IdentityPoolValueV2(identityPool);
            }
            case REFRESH_TOKEN_INFO: {
                RefreshTokenInfoKey refreshTokenInfoKey = (RefreshTokenInfoKey)key;
                RefreshTokenInfo refreshTokenInfo = this.refreshTokens.get(refreshTokenInfoKey.cacheKey());
                return refreshTokenInfo == null ? null : new RefreshTokenInfoValue(refreshTokenInfo);
            }
        }
        throw new IllegalArgumentException("Unknown key type " + key.entryType());
    }

    public AuthValue put(AuthKey key, AuthValue value) {
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null");
        }
        if (key.entryType() != value.entryType()) {
            throw new CorruptRecordException("Invalid record with key=" + key + ", value=" + value);
        }
        switch (key.entryType()) {
            case ROLE_BINDING: {
                return this.updateRoleBinding((RoleBindingKey)key, (RoleBindingValue)value);
            }
            case ACL_BINDING: {
                return this.updateAclBinding((AclBindingKey)key, (AclBindingValue)value);
            }
            case USER: {
                return this.updateUser((UserKey)key, (UserValue)value);
            }
            case JWT_ISSUER: {
                return this.updateJwtIssuer((JwtIssuerKeyV2)key, (JwtIssuerValue)value);
            }
            case IDENTITY_POOL: {
                return this.updateIdentityPool((IdentityPoolKey)key, (IdentityPoolValueV2)value);
            }
            case STATUS: {
                StatusValue status = (StatusValue)value;
                if (status.status() == MetadataStoreStatus.FAILED) {
                    log.error("Received failed status with key {} value {}", (Object)key, (Object)value);
                } else {
                    log.debug("Processing status with key {} value {}", (Object)key, (Object)value);
                }
                return (AuthValue)this.partitionStatus.put(((StatusKey)key).partition(), status);
            }
            case LATENCY_RECORD: {
                return null;
            }
            case REFRESH_TOKEN_INFO: {
                return this.updateRefreshTokenInfo((RefreshTokenInfoKey)key, (RefreshTokenInfoValue)value);
            }
        }
        throw new IllegalArgumentException("Unknown key type " + key.entryType());
    }

    public AuthValue remove(AuthKey key) {
        switch (key.entryType()) {
            case ROLE_BINDING: {
                return this.removeRoleBinding((RoleBindingKey)key);
            }
            case ACL_BINDING: {
                return this.removeAclBinding((AclBindingKey)key);
            }
            case USER: {
                UserMetadata oldUser = this.users.remove(((UserKey)key).principal());
                return oldUser == null ? null : new UserValue((Collection)oldUser.groups());
            }
            case JWT_ISSUER: {
                JsonWebKeySet oldJwks = this.jsonWebKeys.remove(((JwtIssuerKeyV2)key).cacheKey());
                return oldJwks == null ? null : new JwtIssuerValue(oldJwks);
            }
            case IDENTITY_POOL: {
                IdentityPool oldIdentityPool = this.identityPools.remove(((IdentityPoolKey)key).poolId());
                return oldIdentityPool == null ? null : new IdentityPoolValueV2(oldIdentityPool);
            }
            case STATUS: {
                return (AuthValue)this.partitionStatus.remove(((StatusKey)key).partition());
            }
            case LATENCY_RECORD: {
                return null;
            }
            case REFRESH_TOKEN_INFO: {
                RefreshTokenInfo oldRefreshTokenInfo = this.refreshTokens.remove(((RefreshTokenInfoKey)key).cacheKey());
                return oldRefreshTokenInfo == null ? null : new RefreshTokenInfoValue(oldRefreshTokenInfo);
            }
        }
        throw new IllegalArgumentException("Unknown key type " + key.entryType());
    }

    public Map<? extends AuthKey, ? extends AuthValue> map(String type) {
        AuthEntryType entryType = AuthEntryType.valueOf((String)type);
        switch (entryType) {
            case ROLE_BINDING: {
                Map<RoleBindingKey, RoleBindingValue> roleBindingsMap = this.roleBindings.values().stream().flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                return Collections.unmodifiableMap(roleBindingsMap);
            }
            case USER: {
                return this.users.entrySet().stream().collect(Collectors.toMap(e -> new UserKey((KafkaPrincipal)e.getKey()), e -> new UserValue((Collection)((UserMetadata)e.getValue()).groups())));
            }
            case STATUS: {
                return this.partitionStatus.entrySet().stream().collect(Collectors.toMap(e -> new StatusKey(((Integer)e.getKey()).intValue()), Map.Entry::getValue));
            }
        }
        throw new IllegalArgumentException("Unknown key type " + entryType);
    }

    public void fail(int partition, String errorMessage) {
        this.partitionStatus.put(partition, new StatusValue(MetadataStoreStatus.FAILED, -1, null, errorMessage));
    }

    public MetadataStoreStatus status(int partition) {
        StatusValue statusValue = this.partitionStatus.get(partition);
        return statusValue != null ? statusValue.status() : MetadataStoreStatus.UNKNOWN;
    }

    public int totalRoleBindings() {
        return this.roleBindings.values().stream().mapToInt(Map::size).sum();
    }

    public long totalRbacAccessRules() {
        return this.rbacAccessRuleStore.ruleCount();
    }

    public long totalAclAccessRules() {
        return this.aclAccessRuleStore.ruleCount();
    }

    public int totalJwtIssuers() {
        return this.jsonWebKeys.size();
    }

    public long totalIdentityPools() {
        return this.identityPools.size();
    }

    public long totalRefreshTokenInfos() {
        return this.refreshTokens.size();
    }

    protected RoleBindingValue updateRoleBinding(RoleBindingKey key, RoleBindingValue value) {
        if (!this.rootScope.containsScope(key.scope())) {
            return null;
        }
        Map<String, Collection<AccessPolicy>> accessPolicies = this.accessPolicies(key);
        if (accessPolicies.isEmpty()) {
            return null;
        }
        KafkaPrincipal principal = key.principal();
        String role = key.role();
        RoleBindingValue oldValue = this.roleBindings.computeIfAbsent(key.principal(), p -> new ConcurrentHashMap()).put(key, value);
        for (String bindingScope : accessPolicies.keySet()) {
            Scope policyScope = key.scope().ancestorWithBindingScope(bindingScope);
            if (policyScope == null) {
                throw new InvalidRoleBindingException("Binding at scope " + bindingScope + " is missing enclosing scope " + bindingScope);
            }
            RoleBindingKey policyKey = new RoleBindingKey(principal, role, policyScope);
            Map<io.confluent.security.authorizer.ResourcePattern, Set<AccessRule>> accessRules = this.accessRules(policyKey, value);
            this.rbacAccessRuleStore.add(policyScope, principal, accessRules);
            this.removeDeletedAccessPolicies(principal, policyScope);
        }
        return oldValue;
    }

    protected RoleBindingValue removeRoleBinding(RoleBindingKey key) {
        Scope scope = key.scope();
        if (!this.rootScope.containsScope(scope)) {
            return null;
        }
        Map<RoleBindingKey, RoleBindingValue> principalRoleBindings = this.roleBindings.get(key.principal());
        if (principalRoleBindings == null) {
            return null;
        }
        RoleBindingValue existing = principalRoleBindings.remove(key);
        if (existing != null) {
            if (principalRoleBindings.isEmpty()) {
                this.roleBindings.remove(key.principal());
            }
            Role role = this.rbacRoles.role(key.role());
            for (String bindingScope : role.bindingScopes()) {
                this.removeDeletedAccessPolicies(key.principal(), scope.ancestorWithBindingScope(bindingScope));
            }
            return existing;
        }
        return null;
    }

    private JwtIssuerValue updateJwtIssuer(JwtIssuerKeyV2 key, JwtIssuerValue value) {
        JsonWebKeySet oldValue = this.jsonWebKeys.put(key.cacheKey(), value.keys());
        return oldValue == null ? null : new JwtIssuerValue(oldValue);
    }

    private IdentityPoolValueV2 updateIdentityPool(IdentityPoolKey key, IdentityPoolValueV2 value) {
        IdentityPool oldValue = this.identityPools.put(key.poolId(), new IdentityPool(key.poolId(), value.version(), value.providerId(), value.issuer(), value.jwksEndpoint(), value.subjectClaim(), value.serviceAccount(), value.policy(), value.orgId()));
        return oldValue == null ? null : new IdentityPoolValueV2(oldValue);
    }

    private RefreshTokenInfoValue updateRefreshTokenInfo(RefreshTokenInfoKey key, RefreshTokenInfoValue value) {
        RefreshTokenInfo oldValue = this.refreshTokens.put(key.cacheKey(), new RefreshTokenInfo(value.issuer(), value.encryptedRefreshToken(), value.issuedAt(), value.subClaim(), value.sessionId()));
        return oldValue == null ? null : new RefreshTokenInfoValue(oldValue);
    }

    private UserValue updateUser(UserKey key, UserValue value) {
        UserMetadata oldValue = this.users.put(key.principal(), new UserMetadata(value.groups()));
        return oldValue == null ? null : new UserValue((Collection)oldValue.groups());
    }

    protected void ensureNotFailed() {
        Map<Integer, String> exceptions = this.partitionStatus.entrySet().stream().filter(e -> ((StatusValue)e.getValue()).status() == MetadataStoreStatus.FAILED).collect(Collectors.toMap(Map.Entry::getKey, e -> ((StatusValue)e.getValue()).errorMessage()));
        if (!exceptions.isEmpty()) {
            throw new MetadataStoreException("Some partitions have failed: " + exceptions);
        }
    }

    protected Map<String, Collection<AccessPolicy>> accessPolicies(RoleBindingKey roleBindingKey) {
        Role role = this.rbacRoles.role(roleBindingKey.role());
        if (role == null) {
            log.error("Unknown role, ignoring role binding {}", (Object)roleBindingKey);
            return Collections.emptyMap();
        }
        return role.accessPolicies();
    }

    NavigableMap<io.confluent.security.authorizer.ResourcePattern, Set<AccessRule>> rbacRules(Scope scope) {
        return this.rbacAccessRuleStore.get(scope);
    }

    private String bindingScope(RoleBindingKey roleBindingKey) {
        return roleBindingKey.scope().bindingScope();
    }

    private Map<io.confluent.security.authorizer.ResourcePattern, Set<AccessRule>> accessRules(RoleBindingKey roleBindingKey, RoleBindingValue roleBindingValue) {
        HashMap<io.confluent.security.authorizer.ResourcePattern, Set<AccessRule>> accessRules = new HashMap<io.confluent.security.authorizer.ResourcePattern, Set<AccessRule>>();
        RoleBinding roleBinding = this.roleBinding(roleBindingKey, roleBindingValue);
        KafkaPrincipal principal = roleBindingKey.principal();
        String bindingScope = this.bindingScope(roleBindingKey);
        Collection<AccessPolicy> accessPolicies = this.accessPolicies(roleBindingKey).get(bindingScope);
        if (accessPolicies == null) {
            return accessRules;
        }
        for (AccessPolicy accessPolicy : accessPolicies) {
            if (accessPolicy == null) continue;
            Collection<Object> resources = !accessPolicy.bindWithResource() ? accessPolicy.wildcardResourcePatterns() : (roleBindingValue.resources().isEmpty() ? Collections.emptySet() : roleBindingValue.resources());
            for (io.confluent.security.authorizer.ResourcePattern resource : resources) {
                HashSet<RbacAccessRule> resourceRules = new HashSet<RbacAccessRule>();
                for (Operation op : accessPolicy.allowedOperations(resource.resourceType())) {
                    RbacAccessRule rule = new RbacAccessRule(resource, principal, PermissionType.ALLOW, WILDCARD_HOST, op, AuthorizePolicy.PolicyType.ALLOW_ROLE, roleBinding);
                    resourceRules.add(rule);
                }
                accessRules.put(resource, resourceRules);
            }
        }
        return accessRules;
    }

    private void removeDeletedAccessPolicies(KafkaPrincipal principal, Scope scope) {
        HashMap<io.confluent.security.authorizer.ResourcePattern, Set<AccessRule>> keepRules = new HashMap<io.confluent.security.authorizer.ResourcePattern, Set<AccessRule>>();
        this.roleBindings.getOrDefault(principal, NO_ROLE_BINDINGS).entrySet().stream().filter(e -> scope.containsScope(((RoleBindingKey)e.getKey()).scope())).flatMap(e -> {
            RoleBindingKey key = new RoleBindingKey(((RoleBindingKey)e.getKey()).principal(), ((RoleBindingKey)e.getKey()).role(), scope);
            return this.accessRules(key, (RoleBindingValue)e.getValue()).entrySet().stream();
        }).forEach(e -> keepRules.computeIfAbsent((io.confluent.security.authorizer.ResourcePattern)e.getKey(), r -> ConcurrentHashMap.newKeySet()).addAll((Collection)e.getValue()));
        this.rbacAccessRuleStore.removeDeletedAccessRules(scope, principal, keepRules);
    }

    private RoleBinding roleBinding(RoleBindingKey key, RoleBindingValue value) {
        return new RoleBinding(key.principal(), key.role(), key.scope(), value.resources());
    }

    private AclBindingValue aclBindingValue(Set<AccessRule> rules) {
        return new AclBindingValue((Collection)rules.stream().map(AclRule::from).collect(Collectors.toSet()));
    }

    private AccessRule accessRule(io.confluent.security.authorizer.ResourcePattern resource, AclRule rule) {
        ResourcePattern kafkaResource = io.confluent.security.authorizer.ResourcePattern.to((io.confluent.security.authorizer.ResourcePattern)resource);
        AclBinding aclBinding = new AclBinding(kafkaResource, rule.toAccessControlEntry());
        AuthorizePolicy.PolicyType policyType = rule.permissionType() == PermissionType.ALLOW ? AuthorizePolicy.PolicyType.ALLOW_ACL : AuthorizePolicy.PolicyType.DENY_ACL;
        return new AclAccessRule(resource, rule.principal(), rule.permissionType(), rule.host(), rule.operation(), policyType, aclBinding);
    }

    private AclBindingValue updateAclBinding(AclBindingKey key, AclBindingValue value) {
        Scope scope = key.scope();
        if (!this.rootScope.containsScope(scope)) {
            return null;
        }
        AclBindingValue oldValue = (AclBindingValue)this.get((AuthKey)key);
        Set<AccessRule> newRules = value.aclRules().stream().map((? super T aclRule) -> this.accessRule(key.resourcePattern(), (AclRule)aclRule)).collect(Collectors.toSet());
        this.aclAccessRuleStore.update(scope, key.resourcePattern(), newRules);
        return oldValue;
    }

    private AclBindingValue removeAclBinding(AclBindingKey key) {
        Scope scope = key.scope();
        if (!this.rootScope.containsScope(scope)) {
            return null;
        }
        Set<AccessRule> accessRules = this.aclAccessRuleStore.remove(scope, key.resourcePattern());
        if (accessRules != null) {
            return this.aclBindingValue(accessRules);
        }
        return null;
    }
}

