/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.config.ConfigItem;
import io.confluent.ksql.config.KsqlConfigResolver;
import io.confluent.ksql.rest.entity.KsqlEntity;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PropertiesList
extends KsqlEntity {
    public static final Set<String> QueryLevelProperties = ImmutableSet.of((Object)"auto.offset.reset", (Object)"buffered.records.per.partition", (Object)"cache.max.bytes.buffering", (Object)"ksql.fail.on.deserialization.error", (Object)"ksql.cast.strings.preserve.nulls", (Object)"ksql.nested.error.set.null", (Object[])new String[]{"ksql.query.retry.backoff.max.ms", "ksql.query.pull.max.allowed.offset.lag", "ksql.query.pull.table.scan.enabled", "ksql.timestamp.throw.on.invalid", "max.task.idle.ms", "task.timeout.ms"});
    public static final Set<String> MutableSystemProperties = ImmutableSet.of((Object)"max.poll.records", (Object)"max.poll.interval.ms", (Object)"session.timeout.ms", (Object)"heartbeat.interval.ms", (Object)"fetch.min.bytes", (Object)"fetch.max.bytes", (Object[])new String[]{"fetch.max.wait.ms", "metadata.max.age.ms", "max.partition.fetch.bytes", "batch.size", "linger.ms", "delivery.timeout.ms", "max.request.size", "max.block.ms", "buffer.memory", "compression.type", "acceptable.recovery.lag", "commit.interval.ms", "max.warmup.replicas", "num.standby.replicas", "poll.ms", "probing.rebalance.interval.ms", "processing.guarantee", "window.size.ms"});
    private final ImmutableList<Property> properties;
    private final ImmutableList<String> overwrittenProperties;
    private final ImmutableList<String> defaultProperties;

    @JsonCreator
    public PropertiesList(@JsonProperty(value="statementText") String statementText, @JsonProperty(value="properties") List<Property> properties, @JsonProperty(value="overwrittenProperties") List<String> overwrittenProperties, @JsonProperty(value="defaultProperties") List<String> defaultProperties) {
        super(statementText);
        this.properties = ImmutableList.copyOf(properties);
        this.overwrittenProperties = ImmutableList.copyOf(overwrittenProperties);
        this.defaultProperties = ImmutableList.copyOf(defaultProperties);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="properties is ImmutableList")
    public List<Property> getProperties() {
        return this.properties;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="overwrittenProperties is ImmutableList")
    public List<String> getOverwrittenProperties() {
        return this.overwrittenProperties;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="defaultProperties is ImmutableList")
    public List<String> getDefaultProperties() {
        return this.defaultProperties;
    }

    public boolean equals(Object o) {
        return o instanceof PropertiesList && Objects.equals(this.properties, ((PropertiesList)o).properties) && Objects.equals(this.overwrittenProperties, ((PropertiesList)o).overwrittenProperties) && Objects.equals(this.defaultProperties, ((PropertiesList)o).defaultProperties);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.overwrittenProperties, this.defaultProperties);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Property {
        private final String name;
        private final String scope;
        private final String value;
        @JsonProperty(value="editable")
        private final boolean editable;
        @JsonProperty(value="level")
        private final String level;

        @JsonCreator
        public Property(@JsonProperty(value="name") String name, @JsonProperty(value="scope") String scope, @JsonProperty(value="value") String value) {
            this.name = name;
            this.scope = scope;
            this.value = value;
            this.editable = Property.isEditable(name);
            this.level = QueryLevelProperties.contains(name) ? "QUERY" : "SERVER";
        }

        public static boolean isEditable(String propertyName) {
            KsqlConfigResolver resolver = new KsqlConfigResolver();
            Optional resolvedItem = resolver.resolve(propertyName, false);
            return resolvedItem.isPresent() && (MutableSystemProperties.contains(((ConfigItem)resolvedItem.get()).getPropertyName()) || QueryLevelProperties.contains(((ConfigItem)resolvedItem.get()).getPropertyName()));
        }

        public String getLevel() {
            return this.level;
        }

        public boolean getEditable() {
            return this.editable;
        }

        public String getName() {
            return this.name;
        }

        public String getScope() {
            return this.scope;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Property that = (Property)object;
            return Objects.equals(this.name, that.name) && Objects.equals(this.scope, that.scope) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.scope, this.value);
        }

        public String toString() {
            return "Property{name='" + this.name + '\'' + ", scope='" + this.scope + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }
}

